/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

class UnusedOptionTreeContentProvider
implements ITreeContentProvider {
    private Map<String, List<String>> options;
    private ToolChunk chunk;
    private boolean showNormal = true;
    private boolean showExtended = true;

    UnusedOptionTreeContentProvider() {
    }

    public void setVisibility(boolean showNormal, boolean showExtended) {
        boolean changed;
        boolean bl = changed = this.showNormal != showNormal || this.showExtended != showExtended;
        if (changed) {
            this.showNormal = showNormal;
            this.showExtended = showExtended;
            this.updateOptions();
        }
    }

    private void updateOptions() {
        this.options = new LinkedHashMap<String, List<String>>();
        IToolOptions toolOptions = this.chunk.getToolOptions();
        ArrayList optionsToDisplay = new ArrayList();
        optionsToDisplay.addAll(toolOptions.getAvailableOptions());
        optionsToDisplay.removeAll(this.chunk.getConfiguredOptions());
        ArrayList<String> hiddenOptions = new ArrayList<String>();
        for (String string : optionsToDisplay) {
            String optionType = toolOptions.getType(string);
            if ("normal".equals(optionType) && !this.showNormal || "extended".equals(optionType) && !this.showExtended || "internal".equals(optionType)) {
                hiddenOptions.add(string);
                continue;
            }
            String groupName = toolOptions.getGroup(string);
            if (!this.options.containsKey(groupName)) {
                this.options.put(groupName, new ArrayList());
            }
            this.options.get(groupName).add(string);
        }
        for (List list : this.options.values()) {
            Collections.sort(list);
        }
        optionsToDisplay.removeAll(hiddenOptions);
    }

    public Object[] getChildren(Object parentElement) {
        if (this.options.containsKey(parentElement)) {
            return this.options.get(parentElement).toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (this.chunk.getToolOptions().getAvailableOptions().contains(element)) {
            return this.chunk.getToolOptions().getGroup((String)element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.options.containsKey(element);
    }

    public Object[] getElements(Object inputElement) {
        this.updateOptions();
        ArrayList<String> usedOptGroups = new ArrayList<String>(this.options.keySet());
        Collections.sort(usedOptGroups);
        return usedOptGroups.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof ToolChunk) {
            this.chunk = (ToolChunk)newInput;
            this.updateOptions();
        }
    }

    public void dispose() {
        this.options = null;
        this.chunk = null;
    }
}

