/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.ant_launching;

import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchConfigurator;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntLaunchListener
implements ILaunchesListener2 {
    private static final String BUILDER_ISSUE_REGEX = "\\*\\* (error|ERROR|warning|WARNING) jamaica.*?:[ ]?(.+)";
    private static final String ANT_PROC_NAME_REMOTE = "RemoteAntRuntimeProcess";
    private static final String ANT_PROC_NAME_LOCAL = "AntProcess";
    private JamaicaAntEditor jamAntEditor_ = null;
    private Map<ILaunch, AntProcessListener> activeLaunches = new HashMap<ILaunch, AntProcessListener>();

    public AntLaunchListener(JamaicaAntEditor jae) {
        this.jamAntEditor_ = jae;
    }

    private boolean isLaunchOfLinkedJAE(ILaunch launch) {
        String locLaunch = null;
        Path pathLaunch = Path.EMPTY;
        Path pathJAE = Path.EMPTY;
        boolean isJAELaunch = false;
        boolean isSameJAE = false;
        AntLaunchConfigurator confer = AntLaunchConfigurator.getInstance();
        try {
            isJAELaunch = confer.isAntEditorLaunch(launch.getLaunchConfiguration());
            locLaunch = confer.getLocation(launch.getLaunchConfiguration());
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (locLaunch == null) {
            return false;
        }
        pathLaunch = new Path(locLaunch);
        pathJAE = this.jamAntEditor_.getFile().getLocation();
        isSameJAE = pathJAE.equals((Object)pathLaunch);
        return isJAELaunch && isSameJAE;
    }

    private List<String> getAntTargets(ILaunch launch) {
        List<String> executedAntTargets = Arrays.asList(new String[0]);
        try {
            executedAntTargets = AntLaunchConfigurator.getInstance().getAntTargets(launch.getLaunchConfiguration());
        }
        catch (CoreException e) {
            executedAntTargets = Arrays.asList(new String[0]);
        }
        return executedAntTargets;
    }

    private String getClickedAntTargetName(List<String> targetList) {
        String retval = "";
        retval = targetList.isEmpty() ? ProjectFile.getInstance(this.jamAntEditor_.getFile()).getDefaultTarget() : targetList.get(0);
        return retval;
    }

    public void launchesRemoved(ILaunch[] launches) {
        ILaunch[] iLaunchArray = launches;
        int n = launches.length;
        int n2 = 0;
        while (n2 < n) {
            AntProcessListener apl;
            ILaunch curLaunch = iLaunchArray[n2];
            if (this.isLaunchOfLinkedJAE(curLaunch) && (apl = this.activeLaunches.remove(curLaunch)) != null) {
                apl.unhookStreamListeners();
            }
            ++n2;
        }
    }

    public void launchesAdded(ILaunch[] launches) {
        ProjectFile project = ProjectFile.getInstance(this.jamAntEditor_.getFile());
        List<String> executedAntTargets = null;
        int i = 0;
        while (i < launches.length) {
            ILaunch curLaunch = launches[i];
            if (this.isLaunchOfLinkedJAE(curLaunch)) {
                ToolChunk buildTarget;
                String antProcName;
                executedAntTargets = this.getAntTargets(curLaunch);
                String clickedTargetName = this.getClickedAntTargetName(executedAntTargets);
                this.activeLaunches.put(curLaunch, null);
                if (curLaunch.hasChildren() && this.activeLaunches.get(curLaunch) == null && ((antProcName = curLaunch.getProcesses()[0].getClass().getSimpleName()).equals(ANT_PROC_NAME_LOCAL) || antProcName.equals(ANT_PROC_NAME_REMOTE))) {
                    this.activeLaunches.put(curLaunch, new AntProcessListener(curLaunch.getProcesses()[0]));
                }
                if ((buildTarget = project.getToolChunkManager().getTag(clickedTargetName)) == null) {
                    ExecChunk launchTarget = project.getExecChunkManager().getTag(clickedTargetName);
                    if (launchTarget != null) {
                        launchTarget.clearProblems();
                    }
                } else {
                    buildTarget.clearProblems();
                }
            }
            ++i;
        }
    }

    public void launchesChanged(ILaunch[] launches) {
        int i = 0;
        while (i < launches.length) {
            ILaunch curLaunch = launches[i];
            if (this.isLaunchOfLinkedJAE(curLaunch)) {
                String antProcName;
                if (!this.activeLaunches.containsKey(curLaunch)) {
                    this.activeLaunches.put(curLaunch, null);
                }
                if (curLaunch.hasChildren() && this.activeLaunches.get(curLaunch) == null && ((antProcName = curLaunch.getProcesses()[0].getClass().getSimpleName()).equals(ANT_PROC_NAME_LOCAL) || antProcName.equals(ANT_PROC_NAME_REMOTE))) {
                    this.activeLaunches.put(curLaunch, new AntProcessListener(curLaunch.getProcesses()[0]));
                }
            }
            ++i;
        }
    }

    public void launchesTerminated(ILaunch[] launches) {
        Pattern issuePattern = Pattern.compile(BUILDER_ISSUE_REGEX);
        ProjectFile project = ProjectFile.getInstance(this.jamAntEditor_.getFile());
        List<String> executedAntTargets = null;
        int i = 0;
        while (i < launches.length) {
            ILaunch curLaunch = launches[i];
            if (this.isLaunchOfLinkedJAE(curLaunch) && this.activeLaunches.get(curLaunch) != null) {
                executedAntTargets = this.getAntTargets(curLaunch);
                String clickedTargetName = this.getClickedAntTargetName(executedAntTargets);
                String err = this.activeLaunches.get(curLaunch).getErrString();
                String out = this.activeLaunches.get(curLaunch).getOutString();
                String warn = this.activeLaunches.get(curLaunch).getWarnString();
                this.activeLaunches.remove(curLaunch).unhookStreamListeners();
                ArrayList<ProblemManager.Problem> probList = new ArrayList<ProblemManager.Problem>();
                ProblemManager probMan = project.getProblemManager();
                ToolChunkManager toolTargetMan = project.getToolChunkManager();
                ExecChunkManager execTargetMan = project.getExecChunkManager();
                Matcher issueMatcher = issuePattern.matcher(warn);
                while (issueMatcher.find()) {
                    String issueKind = issueMatcher.group(1);
                    String issueMessage = issueMatcher.group(2);
                    probList.add(probMan.reportProblem("Jamaica Builder / Ant target '" + clickedTargetName + "'", issueMessage, issueKind.equalsIgnoreCase("error") ? 2 : 1));
                }
                InteractiveTargetChunk antTarget = toolTargetMan.getTag(clickedTargetName);
                if (antTarget == null) {
                    antTarget = execTargetMan.getTag(clickedTargetName);
                }
                if (antTarget != null) {
                    antTarget.addProblems(probList);
                }
            }
            ++i;
        }
    }

    static class AntProcessListener {
        private StringBuilder errString_ = new StringBuilder();
        private StringBuilder outString_ = new StringBuilder();
        private StringBuilder warnString_ = new StringBuilder();
        private IStreamListener outListener;
        private IStreamListener errListener;
        private IStreamListener warnListener;
        private IStreamMonitor warnMonitor;
        private IStreamMonitor errMonitor;
        private IStreamMonitor outMonitor;

        public AntProcessListener(IProcess p) {
            if (!p.getClass().getSimpleName().equals(AntLaunchListener.ANT_PROC_NAME_LOCAL) && !p.getClass().getSimpleName().equals(AntLaunchListener.ANT_PROC_NAME_REMOTE)) {
                throw new IllegalArgumentException("Passed process must be of type 'AntProcess' or 'RemoteAntRuntimeProcess'.");
            }
            IStreamsProxy streamProxy = p.getStreamsProxy();
            if (!streamProxy.getClass().getSimpleName().equals("AntStreamsProxy")) {
                throw new IllegalArgumentException("Streams proxy of AntProcess must be AntStreamsProxy.");
            }
            this.warnListener = new AntProcessStreamListener(this.warnString_);
            try {
                this.warnMonitor = (IStreamMonitor)streamProxy.getClass().getMethod("getWarningStreamMonitor", new Class[0]).invoke((Object)streamProxy, new Object[0]);
                this.warnMonitor.addListener(this.warnListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.errListener = new AntProcessStreamListener(this.errString_);
            this.errMonitor = streamProxy.getErrorStreamMonitor();
            this.errMonitor.addListener(this.errListener);
            this.outListener = new AntProcessStreamListener(this.outString_);
            this.outMonitor = streamProxy.getOutputStreamMonitor();
            this.outMonitor.addListener(this.outListener);
        }

        public String getErrString() {
            return this.errString_.toString();
        }

        public String getOutString() {
            return this.outString_.toString();
        }

        public String getWarnString() {
            return this.warnString_.toString();
        }

        public void unhookStreamListeners() {
            this.outMonitor.removeListener(this.outListener);
            this.errMonitor.removeListener(this.errListener);
            if (this.warnMonitor != null) {
                this.warnMonitor.removeListener(this.warnListener);
            }
        }

        class AntProcessStreamListener
        implements IStreamListener {
            private StringBuilder stringBuilder_;

            public AntProcessStreamListener(StringBuilder sb) {
                this.stringBuilder_ = sb;
            }

            public void streamAppended(String text, IStreamMonitor monitor) {
                this.stringBuilder_.append(text);
            }
        }
    }
}

