/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskdefManager
extends ModelPartManager<TaskdefTag> {
    public TaskdefManager(ProjectFile parent) {
        super(parent);
    }

    public JamaicaVMDistribution getDistribution(String name) {
        return this.containsChunk(name) ? ((TaskdefTag)this.getTag(name)).getDistribution() : null;
    }

    public ToolType getToolType(String name) {
        return this.containsChunk(name) ? ((TaskdefTag)this.getTag(name)).getToolType() : null;
    }

    public IToolOptions getToolOptions(String name) {
        return this.getDistribution(name) != null ? this.getDistribution(name).getToolOptions(this.getToolType(name)) : null;
    }

    public boolean isBound(String name) {
        return this.containsChunk(name) && ((TaskdefTag)this.getTag(name)).isBound();
    }

    public void addTaskdef(String name, JamaicaVMDistribution distribution, ToolType type) throws ModelException {
        this.removeTaskdef(name);
        Element newTaskTag = this.getProjectFile().getDocument().createElement("taskdef");
        newTaskTag.setAttribute("name", name);
        newTaskTag.setAttribute("classname", type.classname());
        newTaskTag.setAttribute("classpath", distribution.getToolOptions(type).getToolClasspath());
        TaskdefTag tdef = new TaskdefTag(newTaskTag, this);
        this.setTag(name, tdef);
        tdef.validateClasspath();
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.TASKDEF, name));
    }

    public TaskdefTag addTaskdefInternal(String name, JamaicaVMDistribution distribution, ToolType type) throws ModelException {
        Element newTaskTag = this.getProjectFile().getDocument().createElement("taskdef");
        newTaskTag.setAttribute("name", name);
        newTaskTag.setAttribute("classname", type.classname());
        newTaskTag.setAttribute("classpath", distribution.getToolOptions(type).getToolClasspath());
        TaskdefTag tdef = new TaskdefTag(newTaskTag, this);
        return tdef;
    }

    public void validateTaskdefs() {
        List<String> knownTaskdefs = this.getNames();
        for (String curTask : knownTaskdefs) {
            ((TaskdefTag)this.getTag(curTask)).validateClasspath();
        }
    }

    public void removeTaskdef(String name) {
        if (this.removeChunk(name)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TASKDEF, name));
        }
    }

    @Override
    public void doClear() {
        super.doClear();
        TaskdefTag.askUserOnUnboundTaskdef = true;
        TaskdefTag.unboundTaskdefDialogSelection = -1;
    }
}

