/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.Tag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class PropertyTag
extends Tag {
    private boolean isEnvProp = false;

    public PropertyTag(Node node, PropertiesManager manager) throws ModelException {
        super(node, null, manager);
        Element ele = (Element)node;
        if (ele.getTagName().equals("condition")) {
            return;
        }
        String envAttr = ele.getAttribute("environment");
        String nameAttr = ele.getAttribute("name");
        if (ele.hasAttribute("environment")) {
            this.isEnvProp = true;
            this.getManager().setEnvironmentProperty(this);
        } else if (nameAttr.isEmpty()) {
            throw new ModelException(Messages.PropertyTag_Unnamed_properties____are_not_yet_supported);
        }
    }

    public String getValue() {
        String retVal = null;
        retVal = this.isEnvProp ? ((Element)this.getNode()).getAttribute("environment") : ((Element)this.getNode()).getAttribute("value");
        return retVal;
    }

    public void setValue(String value) {
        if (this.isEnvProp) {
            ((Element)this.getNode()).setAttribute("environment", value);
        } else {
            ((Element)this.getNode()).setAttribute("value", value);
        }
    }

    public String getName() {
        String retVal = null;
        if (this.isEnvProp) {
            String envSuffix = "" + this.getManager().getEnvironmentPropertyRank(this);
            retVal = "<environment" + envSuffix + ">";
        } else {
            retVal = ((Element)this.getNode()).getAttribute("name");
        }
        return retVal;
    }

    public void setName(String name) {
        if (!this.isEnvProp) {
            ((Element)this.getNode()).setAttribute("name", name);
        }
    }

    public PropertiesManager getManager() {
        return (PropertiesManager)super.getManager();
    }

    public boolean isEnvironmentProperty() {
        return this.isEnvProp;
    }
}

