/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AgentlibSettingEditor
extends AbstractSettingEditor {
    private Text hostnameField;
    private Text portField;
    private Button serverModeButton;
    private Button suspendButton;
    private static final String AGENT_AND_TRANSPORT_DEFINITION = "BuiltInAgent=transport=dt_socket";
    private static final Pattern ARGUMENT_REGEX = Pattern.compile("BuiltInAgent=transport=dt_socket,server=([yn]),suspend=([yn]),address=([\\p{Alnum}\\.-]*):([0-9]{1,5})");
    private static final ToolChunk.UIValidator agentlibValidator = new ToolChunk.UIValidator(){

        public String validateForUI(String value) {
            return ARGUMENT_REGEX.matcher(value).matches() ? null : MessageFormat.format(Messages.AgentlibSettingEditor_Value___1___does_not_match_the_required_regular_expression, value);
        }
    };
    private static final int SERVER = 1;
    private static final int SUSPEND = 2;
    private static final int HOSTNAME = 3;
    private static final int PORT = 4;
    private boolean deactivateEvents = false;
    private Object deactivateEventsLock = new Object();
    private final Listener handlyModifyListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            Object object = AgentlibSettingEditor.this.deactivateEventsLock;
            synchronized (object) {
                if (!AgentlibSettingEditor.this.deactivateEvents) {
                    AgentlibSettingEditor.this.handeModify();
                }
            }
        }
    };

    public AgentlibSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
        try {
            chunk.addUIValidator(optionName, agentlibValidator);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(4, false);
        gridLay.verticalSpacing = 0;
        gridLay.marginHeight = 0;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        Label hostnameLabel = toolkit.createLabel(parent, String.valueOf(Messages.AgentlibSettingEditor_Host) + ':');
        hostnameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        hostnameLabel.setFont(this.groupFont);
        hostnameLabel.setBackground(this.groupColor);
        this.hostnameField = toolkit.createText(parent, Messages.AgentlibSettingEditor_unknown, 2052);
        this.hostnameField.addListener(24, this.handlyModifyListener);
        this.hostnameField.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.hostnameField.setFont(this.groupFont);
        this.hostnameField.setBackground(this.textfieldColor);
        Label portLabel = toolkit.createLabel(parent, String.valueOf(Messages.AgentlibSettingEditor_Port) + ':');
        portLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        portLabel.setFont(this.groupFont);
        portLabel.setBackground(this.groupColor);
        this.portField = toolkit.createText(parent, Messages.AgentlibSettingEditor_unknown, 2052);
        this.portField.addListener(24, this.handlyModifyListener);
        this.portField.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.portField.setFont(this.groupFont);
        this.portField.setBackground(this.textfieldColor);
        this.serverModeButton = toolkit.createButton(parent, Messages.AgentlibSettingEditor_Server_mode, 32);
        this.serverModeButton.setSelection(true);
        this.serverModeButton.addListener(13, this.handlyModifyListener);
        this.serverModeButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.serverModeButton.setFont(this.groupFont);
        this.serverModeButton.setBackground(this.groupColor);
        this.suspendButton = toolkit.createButton(parent, Messages.AgentlibSettingEditor_Suspend_in_main, 32);
        this.suspendButton.setSelection(true);
        this.suspendButton.addListener(13, this.handlyModifyListener);
        this.suspendButton.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.suspendButton.setFont(this.groupFont);
        this.suspendButton.setBackground(this.groupColor);
        if (this.getValue().length() == 0) {
            this.setValue("BuiltInAgent=transport=dt_socket,server=y,suspend=y,address=localhost:8000");
        }
    }

    private void handeModify() {
        String newValue = "BuiltInAgent=transport=dt_socket,server=" + (this.serverModeButton.getSelection() ? "y" : "n") + ",suspend=" + (this.suspendButton.getSelection() ? "y" : "n") + ",address=" + this.hostnameField.getText() + ":" + this.portField.getText();
        try {
            newValue = this.propertiesManager.resolveStringWithProperties(newValue);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        this.setValue(newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        super.updateUI();
        boolean state = this.getState();
        this.hostnameField.setEnabled(state);
        this.portField.setEnabled(state);
        this.serverModeButton.setEnabled(state);
        this.suspendButton.setEnabled(state);
        Matcher m = ARGUMENT_REGEX.matcher(this.getValueResolved());
        if (m.matches()) {
            Object object = this.deactivateEventsLock;
            synchronized (object) {
                this.deactivateEvents = true;
            }
            this.hostnameField.setText(m.group(3));
            this.hostnameField.setSelection(this.hostnameField.getText().length());
            this.portField.setText(m.group(4));
            this.portField.setSelection(this.portField.getText().length());
            this.serverModeButton.setSelection(m.group(1).equals("y"));
            this.suspendButton.setSelection(m.group(2).equals("y"));
            object = this.deactivateEventsLock;
            synchronized (object) {
                this.deactivateEvents = false;
            }
        }
    }

    public void grabFocus() {
        super.grabFocus();
        this.hostnameField.setFocus();
    }
}

