/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchUtils;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class OverviewTargetGroup
extends Group {
    protected InteractiveTargetChunk antTarget;
    protected JamaicaAntEditor editor;
    protected ProjectFile projData;
    protected CLabel idLabel = null;
    protected CLabel appLabel = null;
    protected CLabel auxLabel = null;
    protected CLabel statusLabel = null;
    protected Text appNameText = null;
    protected Text auxText = null;
    protected Button cloneButton = null;
    protected Button auxButton = null;
    protected Button invokeButton = null;
    protected Button removeButton = null;
    protected Color groupColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_GROUP);
    protected Color buttonColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_BUTTON);
    protected Color textfieldColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_TEXTFIELD);
    protected Font groupFont = JamaicaAntEditor.getResourceManager().createFont(JamaicaAntEditor.FONT_GROUP);

    public OverviewTargetGroup(Composite parent, int style, InteractiveTargetChunk itc, JamaicaAntEditor jae) {
        super(parent, style);
        this.antTarget = itc;
        this.editor = jae;
        this.projData = itc.getManager().getProjectFile();
        this.setSize(500, 100);
        this.setFont(this.groupFont);
        GridLayout gridLayout = new GridLayout(5, false);
        gridLayout.horizontalSpacing = 2;
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(4, 128, true, false, 1, 1));
        this.setBackground(this.groupColor);
        this.idLabel = new CLabel((Composite)this, 0);
        this.idLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, true, 1, 3));
        this.idLabel.setBackground(this.groupColor);
        this.appLabel = new CLabel((Composite)this, 0);
        this.appLabel.setFont(this.groupFont);
        GridData appLabelLayoutData = new GridData(4, 4, false, true, 1, 1);
        appLabelLayoutData.heightHint = -1;
        this.appLabel.setLayoutData((Object)appLabelLayoutData);
        this.appLabel.setText("Application:");
        this.appLabel.setBackground(this.groupColor);
        this.appNameText = new Text((Composite)this, 2060);
        GridData appNameTextLayoutData = new GridData(4, 0x1000000, true, true, 2, 1);
        appNameTextLayoutData.heightHint = -1;
        this.appNameText.setLayoutData((Object)appNameTextLayoutData);
        this.appNameText.setFont(this.groupFont);
        this.appNameText.setBackground(this.textfieldColor);
        this.appNameText.setEditable(false);
        this.cloneButton = new Button((Composite)this, 0);
        GridData cloneButtonLayoutData = new GridData(4, 4, false, true, 1, 1);
        cloneButtonLayoutData.heightHint = -1;
        this.cloneButton.setLayoutData((Object)cloneButtonLayoutData);
        this.cloneButton.setFont(this.groupFont);
        this.cloneButton.setBackground(this.buttonColor);
        this.auxLabel = new CLabel((Composite)this, 0);
        this.auxLabel.setFont(this.groupFont);
        GridData platformLabelLayoutData = new GridData(4, 4, false, true, 1, 1);
        platformLabelLayoutData.heightHint = -1;
        this.auxLabel.setLayoutData((Object)platformLabelLayoutData);
        this.auxLabel.setBackground(this.groupColor);
        this.auxText = new Text((Composite)this, 2060);
        this.auxText.setFont(this.groupFont);
        this.auxText.setBackground(this.textfieldColor);
        GridData platformNameTextLayoutData = new GridData(4, 0x1000000, true, true, 2, 1);
        platformNameTextLayoutData.heightHint = -1;
        this.auxText.setLayoutData((Object)platformNameTextLayoutData);
        this.auxText.setEditable(false);
        this.auxButton = new Button((Composite)this, 0);
        this.auxButton.setFont(this.groupFont);
        GridData editButtonLayoutData = new GridData(4, 4, false, true, 1, 1);
        editButtonLayoutData.heightHint = -1;
        this.auxButton.setLayoutData((Object)editButtonLayoutData);
        this.auxButton.setBackground(this.buttonColor);
        this.invokeButton = new Button((Composite)this, 0);
        this.invokeButton.setFont(this.groupFont);
        GridData invokeButtonLayoutData = new GridData(4, 4, false, true, 1, 1);
        invokeButtonLayoutData.heightHint = -1;
        this.invokeButton.setLayoutData((Object)invokeButtonLayoutData);
        this.invokeButton.setBackground(this.buttonColor);
        this.invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                try {
                    String antTargetName = OverviewTargetGroup.this.antTarget.getName();
                    if (!OverviewTargetGroup.this.projData.getExecChunkManager().getNames().contains(antTargetName) || OverviewTargetGroup.this.projData.getExecChunkManager().getTag(antTargetName).getExecutable() != null) {
                        AntLaunchUtils.runAntTarget(OverviewTargetGroup.this.projData.getFile(), antTargetName);
                    }
                }
                catch (CoreException ce) {
                    AntEditorPlugin.log(ce);
                }
            }
        });
        this.statusLabel = new CLabel((Composite)this, 0);
        this.statusLabel.setFont(this.groupFont);
        this.statusLabel.setBackground(this.groupColor);
        GridData statusLabelLayoutData = new GridData(4, 4, true, true, 2, 1);
        statusLabelLayoutData.heightHint = -1;
        this.statusLabel.setLayoutData((Object)statusLabelLayoutData);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setFont(this.groupFont);
        GridData removeButtonLayoutData = new GridData(4, 4, false, true, 1, 1);
        removeButtonLayoutData.heightHint = -1;
        this.removeButton.setLayoutData((Object)removeButtonLayoutData);
        this.removeButton.setText("Remove");
        this.removeButton.setBackground(this.buttonColor);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String antTargetName = OverviewTargetGroup.this.antTarget.getName();
                if (MessageDialog.openQuestion((Shell)OverviewTargetGroup.this.getShell(), (String)Messages.OverviewPage_Remove_Ant_target__, (String)MessageFormat.format(Messages.OverviewPage_Do_you_want_to_remove_the_Ant_target___1____, antTargetName))) {
                    if (OverviewTargetGroup.this.antTarget instanceof ToolChunk) {
                        OverviewTargetGroup.this.projData.getToolChunkManager().removeToolChunk(antTargetName);
                    } else if (OverviewTargetGroup.this.antTarget instanceof ExecChunk) {
                        OverviewTargetGroup.this.projData.getExecChunkManager().removeExecChunk(antTargetName);
                    }
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    public abstract void updateUI();
}

