/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchUtils;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.OptionSelectionDialog;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class OptionsPage
extends FormPage
implements IModelPartChangedListener,
IPropertyListener {
    public static final String OPTIONS_PAGE_ID_PREFIX = "com.aicas.jamaica.eclipse.ant_editor.editors.OptionsPage_";
    private JamaicaAntEditor editor;
    private String antTargetName;
    private ToolChunk model;
    private PropertiesManager propertiesManager;
    private TaskdefManager taskdefManager;
    private IFile buildFile;
    private ScrolledForm optionsForm;
    private Composite optionContainer;
    private ScrolledComposite optionScroller;
    private FormToolkit toolkit;
    private StyledText antTargetNameText;
    private StyledText antTargetDependsText;
    private Map<String, Section> sections;
    private static final int SECTION_STYLE = 258;
    private Map<String, AbstractSettingEditor> visibleOptions;
    private Color formColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_FORM);
    private Color groupColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_GROUP);
    private Color textfieldColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_TEXTFIELD);
    private Color buttonColor = JamaicaAntEditor.getResourceManager().createColor(JamaicaAntEditor.COLOR_BUTTON);

    public OptionsPage(JamaicaAntEditor parent, String antTargetName) {
        super((FormEditor)parent, OPTIONS_PAGE_ID_PREFIX + antTargetName, antTargetName);
        this.editor = parent;
        this.antTargetName = antTargetName;
        this.sections = new LinkedHashMap<String, Section>();
        this.visibleOptions = new LinkedHashMap<String, AbstractSettingEditor>();
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        this.optionsForm = managedForm.getForm();
        Composite formbody = this.optionsForm.getBody();
        this.toolkit.decorateFormHeading(this.optionsForm.getForm());
        this.optionsForm.getForm().setTextBackground(new Color[]{this.formColor, this.textfieldColor}, new int[]{100}, true);
        this.toolkit.paintBordersFor(formbody);
        this.optionsForm.setText(Messages.OptionsPage_header_prefix);
        this.optionsForm.setBackground(this.formColor);
        this.optionsForm.setImage(JamaicaAntEditor.getResourceManager().createImage(JamaicaAntEditor.ICON_OPTIONS_PAGE_HEADER));
        GridLayout bodyLayout = new GridLayout(1, true);
        bodyLayout.verticalSpacing = 0;
        bodyLayout.horizontalSpacing = 0;
        bodyLayout.marginHeight = 0;
        bodyLayout.marginWidth = 0;
        formbody.setLayout((Layout)bodyLayout);
        Composite mainContainer = new Composite(formbody, 0);
        GridData gdata = GridDataFactory.fillDefaults().grab(true, true).hint(formbody.getClientArea().width, formbody.getClientArea().height).create();
        mainContainer.setLayoutData((Object)gdata);
        this.optionsForm.setMinSize(0, 0);
        GridLayout mainContainerLayout = new GridLayout(1, true);
        mainContainerLayout.verticalSpacing = 15;
        mainContainerLayout.horizontalSpacing = 0;
        mainContainerLayout.marginHeight = 15;
        mainContainerLayout.marginWidth = 10;
        mainContainer.setLayout((Layout)mainContainerLayout);
        mainContainer.setBackground(this.formColor);
        this.createTargetSection(mainContainer, this.toolkit);
        this.createActionsSection(mainContainer, this.toolkit);
        this.optionScroller = new ScrolledComposite(mainContainer, 768);
        this.optionScroller.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.optionScroller.setBackground(this.formColor);
        this.optionScroller.setExpandHorizontal(true);
        this.optionScroller.setExpandVertical(true);
        this.optionContainer = new Composite((Composite)this.optionScroller, 0);
        this.optionContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout gl = new GridLayout(1, true);
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.optionContainer.setLayout((Layout)gl);
        this.optionContainer.setBackground(this.formColor);
        this.optionScroller.setContent((Control)this.optionContainer);
        this.optionScroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                OptionsPage.this.setOptionScrollerMinSize();
            }
        });
        this.optionScroller.setMinSize(0, 0);
        if (this.model != null) {
            this.updateUI(true);
        }
    }

    private void createActionsSection(Composite parent, FormToolkit toolkit) {
        Section actionSection = toolkit.createSection(parent, 256);
        actionSection.setBackground(this.formColor);
        actionSection.setText("Actions");
        actionSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.paintBordersFor((Composite)actionSection);
        Composite actionComposite = toolkit.createComposite((Composite)actionSection, 0);
        actionComposite.setBackground(this.groupColor);
        toolkit.paintBordersFor(actionComposite);
        actionSection.setClient((Control)actionComposite);
        FillLayout fl_composite_1 = new FillLayout(256);
        fl_composite_1.marginHeight = 2;
        fl_composite_1.spacing = 5;
        fl_composite_1.marginWidth = 0;
        actionComposite.setLayout((Layout)fl_composite_1);
        Button backButton = new Button(actionComposite, 0);
        backButton.setText("Overview");
        backButton.setBackground(this.buttonColor);
        backButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.editor.setActivePage("com.aicas.jamaica.eclipse.ant_editor.editors.OverviewPage");
            }
        });
        Button invokeButton = new Button(actionComposite, 0);
        invokeButton.setText("Build");
        invokeButton.setBackground(this.buttonColor);
        invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.invokeAntOnThisTarget();
            }
        });
        Button addButton = new Button(actionComposite, 0);
        addButton.setText("Add option");
        addButton.setBackground(this.buttonColor);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionsPage.this.openAddOptionDialog(false);
            }
        });
    }

    private void createTargetSection(Composite parent, FormToolkit toolkit) {
        Section targetSection = toolkit.createSection(parent, 256);
        targetSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        toolkit.paintBordersFor((Composite)targetSection);
        targetSection.setText("Target");
        targetSection.setBackground(this.formColor);
        Composite targetComposite = new Composite((Composite)targetSection, 0);
        toolkit.adapt(targetComposite);
        toolkit.paintBordersFor(targetComposite);
        targetSection.setClient((Control)targetComposite);
        FillLayout fl_composite = new FillLayout(256);
        fl_composite.spacing = 10;
        fl_composite.marginWidth = 10;
        targetComposite.setLayout((Layout)fl_composite);
        targetComposite.setBackground(this.groupColor);
        Group group = new Group(targetComposite, 0);
        toolkit.adapt((Composite)group);
        toolkit.paintBordersFor((Composite)group);
        group.setText("Name");
        group.setBackground(this.groupColor);
        GridLayout gl_group = new GridLayout(1, false);
        gl_group.verticalSpacing = 0;
        gl_group.marginWidth = 0;
        gl_group.marginTop = 6;
        gl_group.marginRight = 10;
        gl_group.marginLeft = 10;
        gl_group.marginHeight = 0;
        gl_group.marginBottom = 4;
        group.setLayout((Layout)gl_group);
        this.antTargetNameText = new StyledText((Composite)group, 2060);
        toolkit.adapt((Composite)this.antTargetNameText);
        toolkit.paintBordersFor((Composite)this.antTargetNameText);
        this.antTargetNameText.setEnabled(false);
        this.antTargetNameText.setEditable(false);
        this.antTargetNameText.setBackground(this.textfieldColor);
        this.antTargetNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Group grpDependency = new Group(targetComposite, 0);
        toolkit.adapt((Composite)grpDependency);
        toolkit.paintBordersFor((Composite)grpDependency);
        grpDependency.setText("Dependencies");
        grpDependency.setBackground(this.groupColor);
        GridLayout gl_grpDependency = new GridLayout(2, false);
        gl_grpDependency.verticalSpacing = 0;
        gl_grpDependency.marginWidth = 0;
        gl_grpDependency.marginTop = 6;
        gl_grpDependency.marginRight = 5;
        gl_grpDependency.marginLeft = 10;
        gl_grpDependency.marginHeight = 0;
        gl_grpDependency.marginBottom = 4;
        grpDependency.setLayout((Layout)gl_grpDependency);
        this.antTargetDependsText = new StyledText((Composite)grpDependency, 2060);
        toolkit.adapt((Composite)this.antTargetDependsText);
        toolkit.paintBordersFor((Composite)this.antTargetDependsText);
        this.antTargetDependsText.setEnabled(false);
        this.antTargetDependsText.setEditable(false);
        this.antTargetDependsText.setBackground(this.textfieldColor);
        this.antTargetDependsText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        Button button = new Button((Composite)grpDependency, 0);
        toolkit.adapt((Control)button, true, true);
        GridData gd_button = new GridData(16384, 128, false, false, 1, 1);
        gd_button.widthHint = 35;
        button.setLayoutData((Object)gd_button);
        button.setText("...");
        button.setBackground(this.buttonColor);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                ArrayList<String> allChunks = new ArrayList<String>();
                ProjectFile pf = OptionsPage.this.model.getManager().getProjectFile();
                allChunks.addAll(pf.getToolChunkManager().getNames());
                allChunks.addAll(pf.getExecChunkManager().getNames());
                allChunks.addAll(pf.getPlainTargetChunkManager().getNames());
                ListSelectionDialog lsd = new ListSelectionDialog(OptionsPage.this.getSite().getShell(), allChunks, (IStructuredContentProvider)new ArrayContentProvider(), (ILabelProvider)new LabelProvider(), Messages.OptionsPage_Select_Ant_target_dependencies);
                lsd.setTitle(Messages.OptionsPage_Change_dependecies);
                if (OptionsPage.this.model.getDepends() != null) {
                    Object[] dependsArray = OptionsPage.this.model.getDepends().split(",");
                    lsd.setInitialSelections(dependsArray);
                }
                if (lsd.open() == 0) {
                    Object[] result = lsd.getResult();
                    if (result.length > 0) {
                        OptionsPage.this.model.setDepends(AntEditorPlugin.join(result, ","));
                    } else {
                        OptionsPage.this.model.setDepends(null);
                    }
                }
            }
        });
    }

    public void setModel(ProjectFile model) {
        this.model = model.getToolChunkManager().getTag(this.antTargetName);
        this.propertiesManager = model.getPropertiesManager();
        this.taskdefManager = model.getTaskdefManager();
        model.addListener(this);
        this.buildFile = model.getFile();
        if (this.optionsForm != null) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    OptionsPage.this.updateUI(true);
                }
            });
        }
    }

    public void setActive(boolean active) {
        if (active) {
            this.updateUI(false);
        }
        super.setActive(active);
    }

    public void modelPartChanged(ModelPartChangedEvent event) {
        if (this.optionsForm != null && !this.optionsForm.isDisposed()) {
            if (event.getPart() == ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION && event.getSource() == this.getModel() && event.getElementName() != null) {
                final String optionName = event.getElementName();
                if (event.getAction() == ModelPartChangedEvent.ActionType.CHANGED) {
                    if (this.visibleOptions.containsKey(optionName)) {
                        if ("target".equals(optionName)) {
                            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    OptionsPage.this.updateUI(false);
                                }
                            });
                        } else {
                            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    OptionsPage.this.updateOption(optionName);
                                }
                            });
                        }
                    }
                } else if (event.getAction() == ModelPartChangedEvent.ActionType.ADDED) {
                    this.updateUI(false);
                    this.revealOption(optionName);
                } else if (event.getAction() == ModelPartChangedEvent.ActionType.REMOVED) {
                    this.updateUI(false);
                }
            } else if (event.getPart() != ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION_DIRTY && event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TOOL_CHUNK) && event.getAction().equals((Object)ModelPartChangedEvent.ActionType.CHANGED) && event.getSource().equals(this.getModel())) {
                this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        OptionsPage.this.updateUI(false);
                    }
                });
            }
        }
    }

    public void revealOption(final String name) {
        if (this.visibleOptions.containsKey(name)) {
            this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ((AbstractSettingEditor)OptionsPage.this.visibleOptions.get(name)).grabFocus();
                }
            });
        }
    }

    public void dispose() {
        if (this.model != null) {
            this.model.removeListener(this);
            this.propertiesManager.removeListener(this);
            this.taskdefManager.removeListener(this);
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        super.doSave(monitor);
    }

    private void setOptionScrollerMinSize() {
        Point optScrollSize = this.optionScroller.getSize();
        Point newOptContSize = this.optionContainer.computeSize(optScrollSize.x, -1);
        if (newOptContSize.y > optScrollSize.y) {
            newOptContSize.x -= this.optionScroller.getVerticalBar().getSize().x;
        }
        this.optionContainer.setSize(newOptContSize);
        this.optionScroller.setMinSize(newOptContSize);
    }

    private void addOption(String optionName) {
        assert (this.optionsForm != null && this.model != null && !this.visibleOptions.containsKey(optionName));
        IToolOptions toolOptions = this.model.getToolOptions();
        String groupName = toolOptions.getGroup(optionName) != null ? toolOptions.getGroup(optionName) : Messages.OptionsPage_Unknown_options;
        Section groupSection = null;
        if (this.sections.containsKey(groupName)) {
            groupSection = this.sections.get(groupName);
        } else {
            groupSection = this.toolkit.createSection(this.optionContainer, 258);
            ExpansionAdapter optionContainerExpansionListener = new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    OptionsPage.this.setOptionScrollerMinSize();
                }
            };
            groupSection.addExpansionListener((IExpansionListener)optionContainerExpansionListener);
            groupSection.setBackground(this.formColor);
            this.toolkit.paintBordersFor((Composite)groupSection);
            groupSection.setText(groupName);
            Composite groupSectionClient = this.toolkit.createComposite((Composite)groupSection);
            groupSectionClient.setBackground(this.formColor);
            groupSection.setClient((Control)groupSectionClient);
            groupSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            GridLayout gl = new GridLayout(1, true);
            gl.marginHeight = 2;
            gl.marginWidth = 0;
            gl.verticalSpacing = 2;
            gl.horizontalSpacing = 2;
            groupSectionClient.setLayout((Layout)gl);
            this.sections.put(groupName, groupSection);
            groupSection.setExpanded(true);
        }
        if (groupSection != null) {
            this.optionsForm.setRedraw(false);
            AbstractSettingEditor se = AbstractSettingEditor.newSettingEditor(optionName, this.model, (Composite)groupSection.getClient(), this.toolkit);
            this.visibleOptions.put(optionName, se);
            this.setOptionScrollerMinSize();
            this.optionContainer.layout();
            this.optionsForm.reflow(true);
            this.optionsForm.setRedraw(true);
        }
    }

    private void removeOption(String optionName) {
        assert (this.optionsForm != null && this.model != null && this.visibleOptions.containsKey(optionName));
        this.visibleOptions.get(optionName).dispose();
        this.visibleOptions.remove(optionName);
        this.removeEmptySections();
        this.optionsForm.setFocus();
    }

    private void removeEmptySections() {
        Iterator<Section> sectionIter = this.sections.values().iterator();
        while (sectionIter.hasNext()) {
            Section section = sectionIter.next();
            Composite sectionClient = (Composite)section.getClient();
            if (sectionClient.getChildren().length != 0) continue;
            section.dispose();
            sectionIter.remove();
        }
    }

    private void updateOption(String optionName) {
        assert (this.optionsForm != null && this.model != null && this.visibleOptions.containsKey(optionName));
        this.setOptionScrollerMinSize();
        this.visibleOptions.get(optionName).updateUI();
    }

    private void updateUI(boolean recreateAll) {
        if (this.model == null || this.optionsForm == null || this.optionsForm.isDisposed()) {
            return;
        }
        ArrayList<String> optionsToAdd = new ArrayList<String>();
        ArrayList<String> optionsToRemove = new ArrayList<String>();
        optionsToRemove.addAll(this.visibleOptions.keySet());
        optionsToAdd.addAll(this.model.getConfiguredOptions());
        if (!recreateAll) {
            optionsToRemove.removeAll(this.model.getConfiguredOptions());
            optionsToAdd.removeAll(this.visibleOptions.keySet());
        }
        this.optionsForm.setRedraw(false);
        this.antTargetNameText.setText(this.model.getName());
        this.antTargetDependsText.setText(this.model.getDepends());
        for (String optionName : optionsToRemove) {
            this.removeOption(optionName);
        }
        for (String optionName : optionsToAdd) {
            this.addOption(optionName);
        }
        if (!recreateAll) {
            for (String optionName : this.visibleOptions.keySet()) {
                this.updateOption(optionName);
            }
        }
        for (Section s : this.sections.values()) {
            s.layout();
        }
        if (this.optionScroller.getSize().y < 5) {
            this.optionScroller.setSize(this.optionScroller.computeSize(this.optionScroller.getSize().x, -1));
        }
        this.setOptionScrollerMinSize();
        this.optionScroller.layout(true, true);
        this.optionsForm.reflow(true);
        this.optionsForm.setMinSize(0, 0);
        this.optionsForm.layout(true, true);
        this.optionsForm.setRedraw(true);
    }

    public void openAddOptionDialog(boolean blockOnOpen) {
        if (this.model != null) {
            OptionSelectionDialog d = new OptionSelectionDialog(this.getSite().getShell(), this.model);
            d.setBlockOnOpen(blockOnOpen);
            d.open();
        }
    }

    public void invokeAntOnThisTarget() {
        try {
            AntLaunchUtils.runAntTarget(this.buildFile, this.antTargetName);
        }
        catch (CoreException ce) {
            AntEditorPlugin.log(ce);
        }
    }

    public ToolChunk getModel() {
        return this.model;
    }

    public void propertyChanged(Object source, int propId) {
        if (source.equals(this.editor)) {
            switch (propId) {
                case 258: {
                    this.setInput(this.editor.getEditorInput());
                    break;
                }
                case 1: {
                    break;
                }
                case 257: {
                    break;
                }
            }
        }
    }
}

