/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchListener;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OptionsPage;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewPage;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;

public class JamaicaAntEditor
extends FormEditor
implements IResourceChangeListener,
IModelPartChangedListener,
IGotoMarker,
IDocumentListener,
IElementStateListener,
IPropertyListener {
    public static final int SMALL_COLUMN_WIDTH = 250;
    public static final int BIG_COLUMN_WIDTH = 500;
    private static int instanceCounter = 0;
    private static LocalResourceManager resourceManager;
    public static final ImageDescriptor ICON_OPTIONS_PAGE_HEADER;
    public static final ImageDescriptor ICON_OVERVIEW_PAGE_HEADER;
    public static final ImageDescriptor ICON_OVERVIEW_PAGE_BUILD_TARGET;
    public static final ImageDescriptor ICON_OVERVIEW_PAGE_LAUNCH_TARGET;
    public static final ImageDescriptor ICON_CHECKED_BOX;
    public static final ImageDescriptor ICON_UNCHECKED_BOX;
    public static final ColorDescriptor COLOR_TEXTFIELD;
    public static final ColorDescriptor COLOR_GROUP;
    public static final ColorDescriptor COLOR_FORM;
    public static final ColorDescriptor COLOR_BUTTON;
    public static final FontDescriptor FONT_GROUP;
    private OverviewPage overviewPage;
    private Map<String, OptionsPage> optionPages;
    private TextEditor textEditor;
    private ProjectFile model;
    private boolean errorState;
    private boolean justSaved = false;
    private AntLaunchListener launchListener;

    static {
        ICON_OPTIONS_PAGE_HEADER = ImageDescriptor.createFromURL((URL)JamaicaAntEditor.class.getClassLoader().getResource("icons/gear.png"));
        ICON_OVERVIEW_PAGE_HEADER = ImageDescriptor.createFromURL((URL)JamaicaAntEditor.class.getClassLoader().getResource("icons/eye.png"));
        ICON_OVERVIEW_PAGE_BUILD_TARGET = ImageDescriptor.createFromURL((URL)JamaicaAntEditor.class.getClassLoader().getResource("icons/tools.png"));
        ICON_OVERVIEW_PAGE_LAUNCH_TARGET = ImageDescriptor.createFromURL((URL)JamaicaAntEditor.class.getClassLoader().getResource("icons/rocket.png"));
        ICON_CHECKED_BOX = ImageDescriptor.createFromURL((URL)JamaicaAntEditor.class.getClassLoader().getResource("icons/checked.gif"));
        ICON_UNCHECKED_BOX = ImageDescriptor.createFromURL((URL)JamaicaAntEditor.class.getClassLoader().getResource("icons/unchecked.gif"));
        COLOR_TEXTFIELD = ColorDescriptor.createFrom((Color)Display.getCurrent().getSystemColor(1));
        COLOR_FORM = COLOR_GROUP = ColorDescriptor.createFrom((Color)Display.getCurrent().getSystemColor(22));
        COLOR_BUTTON = COLOR_GROUP;
        FONT_GROUP = FontDescriptor.createFrom((Font)Display.getCurrent().getSystemFont());
    }

    public static LocalResourceManager getResourceManager() {
        if (resourceManager == null) {
            resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return resourceManager;
    }

    public JamaicaAntEditor() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        ++instanceCounter;
    }

    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    protected void addPages() {
        try {
            this.model = ProjectFile.getInstance(this.getFile());
            this.model.addListener(this);
            this.launchListener = new AntLaunchListener(this);
            DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.launchListener);
            this.overviewPage = new OverviewPage(this);
            int overviewPageNum = this.addPage((IFormPage)this.overviewPage);
            this.setPageText(overviewPageNum, this.overviewPage.getTitle());
            this.overviewPage.setModel(this.model);
            this.addPropertyListener(this.overviewPage);
            String antEditorClassName = "org.eclipse.ant.internal.ui.editor.AntEditor";
            try {
                Class<?> antEditorClazz = Class.forName(antEditorClassName);
                this.textEditor = (TextEditor)antEditorClazz.newInstance();
            }
            catch (Exception e) {
                this.textEditor = new TextEditor();
            }
            this.textEditor.addPropertyListener((IPropertyListener)this);
            int textEditorPageNum = this.addPage((IEditorPart)this.textEditor, this.getEditorInput());
            this.setPageText(textEditorPageNum, this.getEditorInput().getName());
            this.optionPages = new HashMap<String, OptionsPage>();
            IDocumentProvider docProv = this.textEditor.getDocumentProvider();
            if (docProv != null) {
                IFileEditorInput fileEditInput = (IFileEditorInput)this.getEditorInput();
                IDocument doc = docProv.getDocument((Object)fileEditInput);
                this.model.setDocumentProvider(docProv, fileEditInput);
                docProv.addElementStateListener((IElementStateListener)this);
                doc.addDocumentListener((IDocumentListener)this);
            }
            this.model.getProblemManager().showMarkers();
            JavaRuntime.getDefaultVMInstall();
            if (this.model.shouldRead()) {
                this.readFile();
            } else {
                this.updateUI();
            }
        }
        catch (PartInitException pie) {
            AntEditorPlugin.log(pie);
        }
    }

    public void dispose() {
        if (this.errorState) {
            IContentType contentType = IDE.getContentType((IFile)this.getFile());
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor[] editors = editorRegistry.getEditors(this.getFile().getName(), contentType);
            List<String> searchedEditorNames = Arrays.asList("Ant Editor", "Text Editor");
            HashMap<String, String> foundFallbackEditors = new HashMap<String, String>();
            int i = 0;
            while (i < editors.length) {
                if (searchedEditorNames.contains(editors[i].getLabel())) {
                    foundFallbackEditors.put(editors[i].getLabel(), editors[i].getId());
                }
                ++i;
            }
            if (!foundFallbackEditors.isEmpty()) {
                for (String editorName : searchedEditorNames) {
                    if (!foundFallbackEditors.containsKey(editorName)) continue;
                    IDE.setDefaultEditor((IFile)this.getFile(), (String)((String)foundFallbackEditors.get(editorName)));
                    break;
                }
            }
        }
        if (this.model != null) {
            this.model.getProblemManager().hideMarkers();
            this.model.removeListener(this);
            this.model.setDocumentProvider(null, null);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.launchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.launchListener);
        }
        if (--instanceCounter == 0 && resourceManager != null) {
            resourceManager.dispose();
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getActivePage() < this.getTextEditorPageNum() && this.model.isDirty()) {
            if (this.getSelectedPage() instanceof FormPage) {
                FormPage curPage = (FormPage)this.getSelectedPage();
                curPage.doSave(monitor);
            }
            this.writeContents();
        }
        this.getEditor(this.getTextEditorPageNum()).doSave(monitor);
    }

    public void doSaveAs() {
        if (this.getActivePage() < this.getTextEditorPageNum() && this.model.isDirty()) {
            this.writeContents();
        }
        IEditorPart editor = this.getEditor(this.getTextEditorPageNum());
        File preSaveFile = ((IFileEditorInput)editor.getEditorInput()).getFile().getLocation().toFile();
        editor.doSaveAs();
        File postSaveFile = ((IFileEditorInput)editor.getEditorInput()).getFile().getLocation().toFile();
        if (!postSaveFile.equals(preSaveFile)) {
            this.setInput(editor.getEditorInput());
            this.setPageText(this.getTextEditorPageNum(), editor.getTitle());
            this.setPartName(editor.getTitle());
            this.firePropertyChange(1);
            this.model.setDocumentProvider(this.textEditor.getDocumentProvider(), (IFileEditorInput)this.getEditorInput());
        }
    }

    public void gotoMarker(IMarker marker) {
        String location = marker.getAttribute("location", "");
        String[] path = location.split("/");
        if (path.length == 2) {
            String antTargetName = path[0];
            String optionName = path[1];
            OptionsPage op = this.optionPages.get(antTargetName);
            if (op != null) {
                if (!op.isActive()) {
                    this.setActivePage(op.getIndex());
                }
                op.revealOption(optionName);
            }
        } else {
            this.setActivePage(this.getTextEditorPageNum());
            IDE.gotoMarker((IEditorPart)this.getEditor(this.getTextEditorPageNum()), (IMarker)marker);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(Messages.JamaicaAntEditor_Invalid_input___Must_be_IFileEditorInput);
        }
        super.init(site, editorInput);
        this.setPartName(editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex < this.getTextEditorPageNum() && this.model.isStale()) {
            this.readFile();
        } else if (newPageIndex == this.getTextEditorPageNum() && this.model.isDirty()) {
            this.writeContents();
        }
        super.pageChange(newPageIndex);
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        block1 : switch (event.getType()) {
            case 2: {
                if (!this.getFile().getProject().equals((Object)event.getResource())) break;
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchPage[] pages = JamaicaAntEditor.this.getSite().getWorkbenchWindow().getPages();
                        int i = 0;
                        while (i < pages.length) {
                            IEditorPart editorPart = pages[i].findEditor(JamaicaAntEditor.this.getEditorInput());
                            pages[i].closeEditor(editorPart, true);
                            ++i;
                        }
                    }
                });
                break;
            }
            case 1: {
                IResourceDelta eventDelta = event.getDelta();
                if (eventDelta.findMember(this.getFile().getProject().getFullPath()) == null) break;
                for (String toolChunkName : this.model.getToolChunkManager().getNames()) {
                    int flags;
                    ToolChunk tc = this.model.getToolChunkManager().getTag(toolChunkName);
                    IResourceDelta toolchunkResDelta = eventDelta.findMember(tc.getPathOfMainClass());
                    if (toolchunkResDelta == null || ((flags = toolchunkResDelta.getFlags()) & 0x2000) <= 0) continue;
                    IPath newPathOfMainClass = toolchunkResDelta.getMovedToPath();
                    IJavaProject javaProject = ProjectFile.getInstance(this.getFile()).getProject();
                    IPath packagePathOfNewMainClass = newPathOfMainClass.removeLastSegments(1);
                    String newMainClassFileName = newPathOfMainClass.segment(newPathOfMainClass.segmentCount() - 1);
                    try {
                        IPackageFragment mainPackageFragment = javaProject.findPackageFragment(packagePathOfNewMainClass);
                        ICompilationUnit mainCompilationUnit = mainPackageFragment.getCompilationUnit(newMainClassFileName);
                        IType primaryType = mainCompilationUnit.findPrimaryType();
                        if (primaryType == null) continue;
                        String fullyQualifiedMainClassName = primaryType.getFullyQualifiedName();
                        tc.setOption("main", fullyQualifiedMainClassName);
                    }
                    catch (JavaModelException e) {
                        AntEditorPlugin.log(e);
                    }
                }
                IResourceDelta xmlFileDelta = eventDelta.findMember(this.getFile().getFullPath());
                if (xmlFileDelta == null) break;
                switch (xmlFileDelta.getKind()) {
                    case 1: {
                        this.model.markStale();
                        break block1;
                    }
                    case 2: {
                        int xmlDeltaFlags = xmlFileDelta.getFlags();
                        switch (xmlDeltaFlags) {
                            case 8192: {
                                IPath newFilePath = xmlFileDelta.getMovedToPath();
                                IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(newFilePath);
                                final FileEditorInput newEditorInput = new FileEditorInput(newFile);
                                Display.getDefault().syncExec(new Runnable(){

                                    public void run() {
                                        JamaicaAntEditor.this.textEditor.setInput((IEditorInput)newEditorInput);
                                        JamaicaAntEditor.this.setPageText(JamaicaAntEditor.this.getTextEditorPageNum(), JamaicaAntEditor.this.getEditorInput().getName());
                                        JamaicaAntEditor.this.setPartName(JamaicaAntEditor.this.getEditorInput().getName());
                                        JamaicaAntEditor.this.firePropertyChange(1);
                                        JamaicaAntEditor.this.model.setDocumentProvider(JamaicaAntEditor.this.textEditor.getDocumentProvider(), (IFileEditorInput)JamaicaAntEditor.this.getEditorInput());
                                    }
                                });
                                break block1;
                            }
                        }
                        this.close(false);
                        break block1;
                    }
                    case 4: {
                        int xmlDeltaFlags = xmlFileDelta.getFlags();
                        switch (xmlDeltaFlags) {
                            case 256: {
                                if (!this.justSaved) {
                                    this.model.markStale();
                                    break block1;
                                }
                                this.justSaved = false;
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean isDirty() {
        return this.model.isDirty() || this.textEditor.isDirty();
    }

    public void modelPartChanged(ModelPartChangedEvent mpcEvent) {
        boolean doUpdate = false;
        if (mpcEvent.getAction() == ModelPartChangedEvent.ActionType.READ_COMPLETE) {
            doUpdate |= true;
        }
        if ((mpcEvent.getAction() == ModelPartChangedEvent.ActionType.ADDED || mpcEvent.getAction() == ModelPartChangedEvent.ActionType.REMOVED) && mpcEvent.getPart() == ModelPartChangedEvent.ModelPartType.TOOL_CHUNK) {
            doUpdate |= true;
        }
        final boolean doUpdateFinal = doUpdate;
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (doUpdateFinal) {
                    JamaicaAntEditor.this.updateUI();
                }
                JamaicaAntEditor.this.firePropertyChange(257);
            }
        });
    }

    private void updateUI() {
        if (!this.model.isUsable()) {
            for (FormPage formPage : this.optionPages.values()) {
                this.removePage(formPage.getIndex());
            }
            this.optionPages.clear();
            return;
        }
        for (String string : this.model.getToolChunkManager().getNames()) {
            OptionsPage optPage = this.optionPages.get(string);
            if (optPage == null) {
                optPage = new OptionsPage(this, string);
                try {
                    this.addPage(this.getTextEditorPageNum(), (IFormPage)optPage);
                    this.optionPages.put(string, optPage);
                    this.addPropertyListener(optPage);
                }
                catch (PartInitException pte) {
                    AntEditorPlugin.log(pte);
                }
            }
            optPage.setModel(this.model);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String antTargetName : this.optionPages.keySet()) {
            if (this.model.getToolChunkManager().containsChunk(antTargetName)) continue;
            IFormPage pageToRemove = this.findPage("com.aicas.jamaica.eclipse.ant_editor.editors.OptionsPage_" + antTargetName);
            this.removePage(pageToRemove.getIndex());
            arrayList.add(antTargetName);
        }
        this.optionPages.keySet().removeAll(arrayList);
    }

    void becameActive() {
        if (this.model.isStale()) {
            this.readFile();
        }
    }

    private void readFile() {
        try {
            this.model.read();
            this.errorState = false;
            for (Map.Entry<String, OptionsPage> entry : this.optionPages.entrySet()) {
                entry.getValue().setModel(this.model);
            }
            this.overviewPage.setModel(this.model);
        }
        catch (ModelException me) {
            if (this.errorState) {
                return;
            }
            this.errorState = true;
            AntEditorPlugin.log(me);
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JamaicaAntEditor.this.updateUI();
                }
            });
            this.overviewPage.displayError(MessageFormat.format(Messages.JamaicaAntEditor_error_format, Messages.JamaicaAntEditor_An_uncorrectable_error_occured_while_reading_the_Ant_buildfile, me.getMessage(), me.getCause() == null ? "" : me.getCause().getMessage()));
            ErrorDialog.openError((Shell)this.getEditorSite().getShell(), (String)"JamaicaVM Tools", (String)Messages.JamaicaAntEditor_An_uncorrectable_error_occured_while_reading_the_Ant_buildfile, (IStatus)new Status(4, "com.aicas.jamaica.eclipse.ant_editor", -1, me.getMessage(), me.getCause() == null ? null : me.getCause()));
        }
    }

    private void writeContents() {
        assert (this.model != null);
        try {
            this.model.write();
        }
        catch (CoreException ce) {
            AntEditorPlugin.log(ce);
            ErrorDialog.openError((Shell)this.getEditorSite().getShell(), (String)"JamaicaVM Tools", (String)Messages.JamaicaAntEditor_An_error_occured_while_writing_the_Ant_buildfile, (IStatus)new Status(4, "com.aicas.jamaica.eclipse.ant_editor", -1, Messages.JamaicaAntEditor_File_contents_could_not_be_set, (Throwable)ce));
        }
    }

    private int getTextEditorPageNum() {
        assert (this.optionPages != null);
        return 1 + this.optionPages.size();
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (!this.model.isStale()) {
            this.model.markStale();
        }
    }

    public synchronized void elementDirtyStateChanged(Object element, boolean isDirty) {
        IFileEditorInput editorInput = (IFileEditorInput)this.getEditorInput();
        if (element.equals(editorInput) && !isDirty) {
            this.justSaved = true;
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
    }

    public void elementDeleted(Object element) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    public void propertyChanged(Object source, int propId) {
        if (source.equals(this.textEditor)) {
            switch (propId) {
                case 258: {
                    this.setInput(this.textEditor.getEditorInput());
                    break;
                }
                case 1: {
                    break;
                }
                case 257: {
                    break;
                }
            }
        }
    }
}

