/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.ant_launching;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ant_launching.AntLaunchConfigurator;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GalileoAntLaunchConfigurator
extends AntLaunchConfigurator {
    private String idAntLaunchConfigurationType = this.getFieldValue("org.eclipse.ant.ui.launching.IAntLaunchConfigurationConstants", "ID_ANT_LAUNCH_CONFIGURATION_TYPE");
    private String attrLocation = this.getFieldValue("org.eclipse.ui.externaltools.internal.model.IExternalToolConstants", "ATTR_LOCATION");
    private String attrWorkingDirectory = this.getFieldValue("org.eclipse.ui.externaltools.internal.model.IExternalToolConstants", "ATTR_WORKING_DIRECTORY");
    private String attrDefaultVMInstall = this.getFieldValue("org.eclipse.ant.ui.launching.IAntLaunchConfigurationConstants", "ATTR_DEFAULT_VM_INSTALL");
    private String attrAntTargets = this.getFieldValue("org.eclipse.ant.ui.launching.IAntLaunchConfigurationConstants", "ATTR_ANT_TARGETS");
    private String attrAntProperties = this.getFieldValue("org.eclipse.ant.ui.launching.IAntLaunchConfigurationConstants", "ATTR_ANT_PROPERTIES");
    private String attrBuildScope = this.getFieldValue("org.eclipse.ui.externaltools.internal.model.IExternalToolConstants", "ATTR_BUILD_SCOPE");

    private String getFieldValue(String className, String fieldName) {
        try {
            Class<?> clazz = Class.forName(className);
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (Exception e) {
            AntEditorPlugin.log(e);
            return null;
        }
    }

    @Override
    public ILaunchConfiguration[] getAntLaunchConfigurations() throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.idAntLaunchConfigurationType);
        return manager.getLaunchConfigurations(type);
    }

    @Override
    public Map<String, String> getAntProperties(ILaunchConfiguration launch) throws CoreException {
        return launch.getAttribute(this.attrAntProperties, null);
    }

    @Override
    public List<String> getAntTargets(ILaunchConfiguration launch) throws CoreException {
        String targets = launch.getAttribute(this.attrAntTargets, null);
        if (targets != null) {
            return Arrays.asList(targets.split(","));
        }
        return null;
    }

    @Override
    public String getLocation(ILaunchConfiguration launch) throws CoreException {
        return launch.getAttribute(this.attrLocation, null);
    }

    @Override
    public String getWorkingDirectory(ILaunchConfiguration launch) throws CoreException {
        return launch.getAttribute(this.attrWorkingDirectory, null);
    }

    @Override
    public ILaunchConfigurationWorkingCopy newAntLaunchConfiguration(String name) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.idAntLaunchConfigurationType);
        return type.newInstance(null, name);
    }

    @Override
    public void setAntProperties(ILaunchConfigurationWorkingCopy launch, Map<String, String> properties) {
        launch.setAttribute(this.attrAntProperties, properties);
    }

    @Override
    public void setAntTargets(ILaunchConfigurationWorkingCopy launch, List<String> targets) {
        launch.setAttribute(this.attrAntTargets, AntEditorPlugin.join(targets.toArray(), ","));
    }

    @Override
    public void setLocation(ILaunchConfigurationWorkingCopy launch, String location) {
        launch.setAttribute(this.attrLocation, location);
    }

    @Override
    public void setWorkingDirectory(ILaunchConfigurationWorkingCopy launch, String workDir) {
        launch.setAttribute(this.attrWorkingDirectory, workDir);
    }

    @Override
    public boolean getDefaultVMInstall(ILaunchConfiguration launch) throws CoreException {
        return launch.getAttribute(this.attrDefaultVMInstall, false);
    }

    @Override
    public void setDefaultVMInstall(ILaunchConfigurationWorkingCopy launch, boolean useDefaultVMInstall) {
        launch.setAttribute(this.attrDefaultVMInstall, useDefaultVMInstall);
    }

    @Override
    public String getBuildScope(ILaunchConfiguration launch) throws CoreException {
        return launch.getAttribute(this.attrBuildScope, null);
    }

    @Override
    public void setBuildScope(ILaunchConfigurationWorkingCopy launch, String scope) {
        launch.setAttribute(this.attrBuildScope, scope);
    }
}

