/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AgentlibSettingEditor
extends AbstractSettingEditor {
    private Text hostnameField;
    private Text portField;
    private Button serverModeButton;
    private Button suspendButton;
    public static final String AGENT_AND_TRANSPORT_DEFINITION = "BuiltInAgent=transport=dt_socket";
    private static final Pattern OPT_VALIDATION_REGEX = Pattern.compile("BuiltInAgent=transport=dt_socket,server=([yn]),suspend=([yn]),address=([\\p{Alnum}\\.-]+:|.{0})([0-9]{1,5})");
    private boolean deactivateEvents = false;
    private Object deactivateEventsLock = new Object();
    private final Listener handlyModifyListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event event) {
            Object object = AgentlibSettingEditor.this.deactivateEventsLock;
            synchronized (object) {
                if (!AgentlibSettingEditor.this.deactivateEvents) {
                    AgentlibSettingEditor.this.handeModify();
                }
            }
        }
    };

    public AgentlibSettingEditor(String optionName, ToolChunk chunk) {
        super(optionName, chunk);
    }

    protected void createInputArea(Composite parent, FormToolkit toolkit) {
        GridLayout gridLay = new GridLayout(1, false);
        gridLay.verticalSpacing = 10;
        gridLay.horizontalSpacing = 7;
        gridLay.marginHeight = 10;
        gridLay.marginWidth = 10;
        parent.setLayout((Layout)gridLay);
        Composite rowAddress = new Composite(parent, 0);
        rowAddress.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(1, 1).hint(430, -1).create());
        RowLayout rowLay = new RowLayout();
        rowLay.center = true;
        rowLay.spacing = 6;
        rowLay.wrap = false;
        rowAddress.setLayout((Layout)rowLay);
        RowData rowData = new RowData();
        Label hostnameLabel = new Label(rowAddress, 0);
        hostnameLabel.setText(String.valueOf(Messages.AgentlibSettingEditor_Host) + ':');
        hostnameLabel.setLayoutData((Object)rowData);
        hostnameLabel.setFont(this.groupFont);
        this.hostnameField = new Text(rowAddress, 2052);
        this.hostnameField.setMessage("<domain.or.ip>");
        this.hostnameField.setToolTipText("Enter the host address (domain or IP).\n\nLeaving this field blank represents host address 'localhost'.");
        this.hostnameField.addListener(24, this.handlyModifyListener);
        this.hostnameField.setLayoutData((Object)RowDataFactory.createFrom((RowData)rowData).hint(220, -1).create());
        this.hostnameField.setFont(this.groupFont);
        Label portLabel = new Label(rowAddress, 0);
        portLabel.setText(String.valueOf(Messages.AgentlibSettingEditor_Port) + ':');
        portLabel.setLayoutData((Object)new RowData());
        portLabel.setFont(this.groupFont);
        this.portField = new Text(rowAddress, 2052);
        this.portField.setMessage("<num>");
        this.portField.setToolTipText("Enter the port number for the connection.");
        this.portField.addListener(24, this.handlyModifyListener);
        this.portField.setLayoutData((Object)RowDataFactory.createFrom((RowData)rowData).hint(55, -1).create());
        this.portField.setFont(this.groupFont);
        Composite rowCheckbox = new Composite(parent, 0);
        rowCheckbox.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        rowCheckbox.setLayout((Layout)rowLay);
        this.serverModeButton = new Button(rowCheckbox, 32);
        this.serverModeButton.setText(Messages.AgentlibSettingEditor_Server_mode);
        this.serverModeButton.setToolTipText("In server mode, the built application will listen on given <host:port> for an incoming debug connection.\n\nIn client mode, the built application will try to connect to <host:port> to establish a debug connection.");
        this.serverModeButton.setSelection(true);
        this.serverModeButton.addListener(13, this.handlyModifyListener);
        this.serverModeButton.setLayoutData((Object)new RowData());
        this.serverModeButton.setFont(this.groupFont);
        this.suspendButton = new Button(rowCheckbox, 32);
        this.suspendButton.setText(Messages.AgentlibSettingEditor_Suspend_in_main);
        this.suspendButton.setToolTipText("In suspend mode, the built application will stop program execution until a debug connection could be established.");
        this.suspendButton.setSelection(true);
        this.suspendButton.addListener(13, this.handlyModifyListener);
        this.suspendButton.setLayoutData((Object)new RowData());
        this.suspendButton.setFont(this.groupFont);
        if (this.getValue().getString().length() == 0) {
            this.setValue(PossiblyEscapedString.plain((String)"BuiltInAgent=transport=dt_socket,server=y,suspend=y,address=localhost:8000"));
        }
        this.invalidDecorator = new ControlDecoration((Control)rowAddress, 0x1004000, (Composite)this.optionControls);
    }

    private void handeModify() {
        String newValue = "BuiltInAgent=transport=dt_socket,server=" + (this.serverModeButton.getSelection() ? "y" : "n") + ",suspend=" + (this.suspendButton.getSelection() ? "y" : "n") + ",address=" + (!this.hostnameField.getText().isEmpty() ? String.valueOf(this.hostnameField.getText()) + ":" : "") + this.portField.getText();
        try {
            newValue = this.propertiesManager.resolveStringWithProperties(newValue);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        this.setValue(PossiblyEscapedString.plain((String)newValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUI() {
        super.updateUI();
        boolean state = this.getState();
        this.hostnameField.setEnabled(state);
        this.portField.setEnabled(state);
        this.serverModeButton.setEnabled(state);
        this.suspendButton.setEnabled(state);
        AgentlibOption opt = new AgentlibOption(this.getValueResolved().getString());
        if (opt.matched) {
            Object object = this.deactivateEventsLock;
            synchronized (object) {
                this.deactivateEvents = true;
            }
            this.hostnameField.setText(opt.HOST);
            this.hostnameField.setSelection(this.hostnameField.getText().length());
            this.portField.setText(opt.PORT);
            this.portField.setSelection(this.portField.getText().length());
            this.serverModeButton.setSelection(opt.SERVER.equals("y"));
            this.suspendButton.setSelection(opt.SUSPEND.equals("y"));
            object = this.deactivateEventsLock;
            synchronized (object) {
                this.deactivateEvents = false;
            }
        }
    }

    public void grabFocus() {
        super.grabFocus();
        this.hostnameField.setFocus();
    }

    private static class AgentlibOption {
        private final Matcher m;
        public final boolean matched;
        public final String SERVER;
        public final String SUSPEND;
        public final String HOST;
        public final String PORT;

        public AgentlibOption(String optVal) {
            this.m = OPT_VALIDATION_REGEX.matcher(optVal);
            this.matched = this.m.matches();
            this.SERVER = this.server();
            this.SUSPEND = this.suspend();
            this.HOST = this.host();
            this.PORT = this.port();
        }

        private String server() {
            return this.matched ? this.m.group(1) : "";
        }

        private String suspend() {
            return this.matched ? this.m.group(2) : "";
        }

        private String host() {
            return this.matched ? this.m.group(3).replaceAll(":", "") : "";
        }

        private String port() {
            return this.matched ? this.m.group(4) : "";
        }
    }
}

