/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.dialogs.AddAcceleratorTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AddBuilderTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AddExecTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewBuildTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewLaunchTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.debug.ui.launcher.NameValuePairDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class OverviewPageBody
extends Composite {
    private ProjectFile projectData;
    private JamaicaAntEditor editor;
    private FormToolkit toolkit;
    private TableViewer propTable;
    private StyledText projectNameText;
    private StyledText defTargetText;
    private StyledText basedirText;
    private Map<String, OverviewTargetGroup> targets;
    private Composite targetContainer;
    private ScrolledComposite scrolledComposite;

    public OverviewPageBody(Composite parent, int style, ProjectFile project, JamaicaAntEditor editor, FormToolkit toolkit) {
        super(parent, 0);
        this.projectData = project;
        this.editor = editor;
        this.toolkit = toolkit;
        GridData gdata = GridDataFactory.fillDefaults().grab(true, true).hint(parent.getClientArea().width, parent.getClientArea().height).create();
        this.setLayoutData(gdata);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.marginWidth = 6;
        gridLayout.marginHeight = 6;
        gridLayout.horizontalSpacing = 6;
        gridLayout.verticalSpacing = 6;
        this.setLayout((Layout)gridLayout);
        toolkit.adapt((Composite)this);
        Section projectSection = toolkit.createSection((Composite)this, 256);
        projectSection.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        projectSection.setText("Project");
        Composite projectComposite = toolkit.createComposite((Composite)projectSection, 0);
        projectSection.setClient((Control)projectComposite);
        GridLayout projectBoxLayout = new GridLayout(3, true);
        projectBoxLayout.marginHeight = 0;
        projectBoxLayout.marginWidth = 0;
        projectBoxLayout.horizontalSpacing = 8;
        projectComposite.setLayout((Layout)projectBoxLayout);
        Composite nameGroup = new Composite(projectComposite, 0);
        toolkit.adapt(nameGroup);
        GridLayout gl_nameGroup = new GridLayout(2, false);
        gl_nameGroup.marginHeight = 0;
        gl_nameGroup.marginWidth = 0;
        gl_nameGroup.horizontalSpacing = 4;
        nameGroup.setLayout((Layout)gl_nameGroup);
        GridData nameGroupLayoutData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create();
        nameGroup.setLayoutData((Object)nameGroupLayoutData);
        CLabel projectNameLabel = new CLabel(nameGroup, 0);
        projectNameLabel.setText("Name:");
        this.projectNameText = new StyledText(nameGroup, 2060);
        toolkit.adapt((Composite)this.projectNameText);
        this.projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.projectNameText.setEditable(false);
        this.projectNameText.setCaret(null);
        Composite defTargetGroup = new Composite(projectComposite, 0);
        toolkit.adapt(defTargetGroup);
        GridLayout gl_defTargetGroup = new GridLayout(3, false);
        gl_defTargetGroup.marginWidth = 0;
        gl_defTargetGroup.marginHeight = 0;
        gl_defTargetGroup.horizontalSpacing = 4;
        defTargetGroup.setLayout((Layout)gl_defTargetGroup);
        GridData targetGroupLayoutData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create();
        defTargetGroup.setLayoutData((Object)targetGroupLayoutData);
        CLabel defTargetLabel = new CLabel(defTargetGroup, 0);
        defTargetLabel.setText("Default target:");
        this.defTargetText = new StyledText(defTargetGroup, 2060);
        toolkit.adapt((Composite)this.defTargetText);
        this.defTargetText.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.defTargetText.setEditable(false);
        this.defTargetText.setCaret(null);
        Button defTargetButton = new Button(defTargetGroup, 0);
        defTargetButton.setText("...");
        GridData gd_defTargetButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_defTargetButton.widthHint = 35;
        defTargetButton.setLayoutData((Object)gd_defTargetButton);
        defTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Object[] result;
                ElementListSelectionDialog elsd = new ElementListSelectionDialog(OverviewPageBody.this.getShell(), (ILabelProvider)new LabelProvider());
                elsd.setTitle(Messages.OverviewPage_Change_default_target);
                elsd.setMessage(Messages.OverviewPage_Select_new_default_target);
                ArrayList<String> allChunks = new ArrayList<String>();
                allChunks.addAll(OverviewPageBody.this.projectData.getToolChunkManager().getNames());
                allChunks.addAll(OverviewPageBody.this.projectData.getExecChunkManager().getNames());
                allChunks.addAll(OverviewPageBody.this.projectData.getPlainTargetChunkManager().getNames());
                elsd.setElements(allChunks.toArray());
                if (elsd.open() == 0 && (result = elsd.getResult()).length > 0) {
                    OverviewPageBody.this.projectData.setDefaultTarget((String)result[0]);
                }
            }
        });
        Composite basedirGroup = new Composite(projectComposite, 0);
        toolkit.adapt(basedirGroup);
        GridLayout gl_basedirGroup = new GridLayout(3, false);
        gl_basedirGroup.horizontalSpacing = 4;
        gl_basedirGroup.marginWidth = 0;
        gl_basedirGroup.marginHeight = 0;
        basedirGroup.setLayout((Layout)gl_basedirGroup);
        GridData basedirGroupLayoutData = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, true).create();
        basedirGroup.setLayoutData((Object)basedirGroupLayoutData);
        CLabel basedirLabel = new CLabel(basedirGroup, 0);
        basedirLabel.setText("Basedir:");
        this.basedirText = new StyledText(basedirGroup, 2060);
        toolkit.adapt((Composite)this.basedirText);
        this.basedirText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.basedirText.setEditable(false);
        this.basedirText.setCaret(null);
        Button basedirButton = new Button(basedirGroup, 0);
        GridData gd_basedirButton = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_basedirButton.widthHint = 35;
        basedirButton.setLayoutData((Object)gd_basedirButton);
        basedirButton.setText("...");
        basedirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                InputDialog id = new InputDialog(OverviewPageBody.this.getShell(), Messages.OverviewPage_Change_base_directory, Messages.OverviewPage_Specify_new_base_directory, OverviewPageBody.this.projectData.getBasedir(), null);
                if (id.open() == 0) {
                    OverviewPageBody.this.projectData.setBasedir(id.getValue());
                }
            }
        });
        Composite bodyComposite = toolkit.createComposite((Composite)this, 0);
        bodyComposite.setLayout((Layout)new FillLayout());
        bodyComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        SashForm bodySash = new SashForm(bodyComposite, 65792);
        toolkit.adapt((Composite)bodySash);
        Section targetSection = toolkit.createSection((Composite)bodySash, 256);
        targetSection.setText("Targets");
        Composite targetComposite = toolkit.createComposite((Composite)targetSection, 0);
        targetSection.setClient((Control)targetComposite);
        GridLayout gl_targetComposite = new GridLayout(2, true);
        gl_targetComposite.marginWidth = 0;
        gl_targetComposite.marginHeight = 0;
        gl_targetComposite.marginTop = 2;
        gl_targetComposite.verticalSpacing = 10;
        targetComposite.setLayout((Layout)gl_targetComposite);
        Composite targetButtonComposite = toolkit.createComposite(targetComposite, 0);
        RowLayout rl = new RowLayout(256);
        rl.wrap = true;
        rl.pack = false;
        rl.justify = false;
        rl.spacing = 5;
        targetButtonComposite.setLayout((Layout)rl);
        targetButtonComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Button buildButton = new Button(targetButtonComposite, 0);
        buildButton.setLayoutData((Object)new RowData());
        buildButton.setText("Build...");
        buildButton.setToolTipText("Create a target that calls the " + ToolType.JAMAICA.toolname() + ".");
        buildButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                new AddBuilderTargetDialog(OverviewPageBody.this.getShell(), OverviewPageBody.this.projectData).open();
            }
        });
        Button accelButton = new Button(targetButtonComposite, 0);
        accelButton.setLayoutData((Object)new RowData());
        accelButton.setText("Accelerate JAR...");
        accelButton.setToolTipText("Create a target that calls the " + ToolType.JARACCELERATOR.toolname() + ".");
        accelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                new AddAcceleratorTargetDialog(OverviewPageBody.this.getShell(), OverviewPageBody.this.projectData).open();
            }
        });
        Button launchButton = new Button(targetButtonComposite, 0);
        launchButton.setLayoutData((Object)new RowData());
        launchButton.setText("Launch...");
        launchButton.setToolTipText("Create a target that launches the executable produced by a Build-target.");
        launchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                new AddExecTargetDialog(OverviewPageBody.this.getShell(), OverviewPageBody.this.projectData).open();
            }
        });
        this.scrolledComposite = new ScrolledComposite(targetComposite, 768);
        toolkit.adapt((Composite)this.scrolledComposite);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                OverviewPageBody.this.setTargetScrollerMinSize();
            }
        });
        this.targetContainer = toolkit.createComposite((Composite)this.scrolledComposite, 0);
        GridLayout gl_composite = new GridLayout(1, false);
        gl_composite.verticalSpacing = 10;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.horizontalSpacing = 0;
        this.targetContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.targetContainer.setLayout((Layout)gl_composite);
        this.scrolledComposite.setContent((Control)this.targetContainer);
        this.setTargetScrollerMinSize();
        Section propSection = toolkit.createSection((Composite)bodySash, 256);
        propSection.setText("Properties");
        bodySash.setWeights(new int[]{67, 33});
        Composite propComposite = toolkit.createComposite((Composite)propSection, 0);
        propSection.setClient((Control)propComposite);
        GridLayout propCompoLayout = new GridLayout(2, true);
        propCompoLayout.marginWidth = 0;
        propCompoLayout.marginHeight = 0;
        propCompoLayout.marginTop = 2;
        propCompoLayout.verticalSpacing = 5;
        propComposite.setLayout((Layout)propCompoLayout);
        this.propTable = ViewerFactory.getPropertiesViewer(propComposite, this.projectData.getPropertiesManager());
        toolkit.adapt((Composite)this.propTable.getTable());
        GridData propTableLayoutData = new GridData(4, 4, true, true, 2, 1);
        this.propTable.getTable().setLayoutData((Object)propTableLayoutData);
        this.propTable.getTable().setToolTipText("Define Ant properties that will be set when a target of this project is invoked.");
        this.targets = new LinkedHashMap<String, OverviewTargetGroup>();
        Button propAddButton = new Button(propComposite, 0);
        propAddButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        propAddButton.setText("Add");
        propAddButton.setToolTipText("Add a new property.");
        propAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                NameValuePairDialog id = new NameValuePairDialog(OverviewPageBody.this.getShell(), Messages.OverviewPage_New_property_dialog_title, new String[]{Messages.OverviewPage_New_property_dialog_name_label, Messages.OverviewPage_New_property_dialog_value_label}, new String[]{"", ""});
                if (id.open() == 0) {
                    String propName = id.getNameValuePair()[0];
                    String propValue = id.getNameValuePair()[1];
                    OverviewPageBody.this.projectData.getPropertiesManager().setPropertyValue(propName, propValue);
                }
            }
        });
        Button propRemoveButton = new Button(propComposite, 0);
        propRemoveButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        propRemoveButton.setText("Remove");
        propRemoveButton.setToolTipText("Remove the selected properties.");
        propRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IStructuredSelection iss = (IStructuredSelection)OverviewPageBody.this.propTable.getSelection();
                for (Object propName : iss.toList()) {
                    OverviewPageBody.this.projectData.getPropertiesManager().removeProperty((String)propName);
                }
            }
        });
    }

    public void layout() {
        super.layout();
        this.scrolledComposite.layout(true, true);
    }

    protected void checkSubclass() {
    }

    protected void updateUI() {
        this.projectNameText.setText(this.projectData.getName() == null ? Messages.OverviewPage___not_set__ : this.projectData.getName());
        this.defTargetText.setText(this.projectData.getDefaultTarget() == null ? Messages.OverviewPage___not_specified__ : this.projectData.getDefaultTarget());
        this.basedirText.setText(this.projectData.getBasedir() == null ? Messages.OverviewPage___not_specified__ : this.projectData.getBasedir());
        for (OverviewTargetGroup curTargetGroup : this.targets.values()) {
            curTargetGroup.setVisible(false);
            curTargetGroup.dispose();
        }
        this.targets.clear();
        for (String curBuildTarget : this.projectData.getToolChunkManager().getNames()) {
            if (this.targets.containsKey(curBuildTarget)) {
                this.targets.get(curBuildTarget).updateUI();
                continue;
            }
            OverviewBuildTargetGroup buildTarget = new OverviewBuildTargetGroup(this.targetContainer, 0, this.projectData.getToolChunkManager().getTag(curBuildTarget), this.editor);
            this.toolkit.adapt((Composite)buildTarget);
            this.targets.put(curBuildTarget, buildTarget);
        }
        for (String curLaunchTarget : this.projectData.getExecChunkManager().getNames()) {
            if (this.targets.containsKey(curLaunchTarget)) {
                this.targets.get(curLaunchTarget).updateUI();
                continue;
            }
            OverviewLaunchTargetGroup launchTarget = new OverviewLaunchTargetGroup(this.targetContainer, 0, this.projectData.getExecChunkManager().getTag(curLaunchTarget), this.editor);
            this.toolkit.adapt((Composite)launchTarget);
            this.targets.put(curLaunchTarget, launchTarget);
        }
        this.setTargetScrollerMinSize();
        this.layout();
        List<String> properties = this.projectData.getPropertiesManager().getNames();
        if (properties != null) {
            this.propTable.setInput(properties);
        }
        TableColumn[] tableColumnArray = this.propTable.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    private void setTargetScrollerMinSize() {
        Point targetContainerSize = this.targetContainer.computeSize(-1, -1);
        this.targetContainer.setSize(targetContainerSize);
        this.scrolledComposite.setMinSize(targetContainerSize);
    }
}

