/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.editors.se.AbstractSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OptionValueEditorDialog
extends StatusDialog {
    private AbstractSettingEditor ase;
    private String optionName;
    private ToolChunk model;
    private FormToolkit toolkit;

    public OptionValueEditorDialog(Shell parentShell, ToolChunk toolchunk, String optname, FormToolkit tkit) {
        super(parentShell);
        this.setBlockOnOpen(true);
        this.setHelpAvailable(false);
        this.setStatusLineAboveButtons(false);
        this.optionName = optname;
        this.model = toolchunk;
        this.toolkit = tkit;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.ase = AbstractSettingEditor.newSettingEditor(this.optionName, this.model, composite, this.toolkit);
        this.updateUI();
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Configure option: " + this.optionName);
        newShell.setDefaultButton(this.getButton(0));
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(0x10060 | newShellStyle);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void cancelPressed() {
        this.ase.resetValue();
        super.cancelPressed();
    }

    protected void handleShellCloseEvent() {
        if (this.model.getConfiguredOptions().contains(this.optionName)) {
            this.ase.resetValue();
        }
        super.handleShellCloseEvent();
    }

    public void updateUI() {
        if (this.ase != null) {
            this.ase.updateUI();
        }
        if (!this.model.isValidOption(this.optionName)) {
            Status errStat = new Status(2, "com.aicas.jamaica.eclipse.ant_editor", "Invalid option value!");
            this.updateStatus((IStatus)errStat);
        } else {
            this.updateStatus(Status.OK_STATUS);
        }
    }
}

