/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class InfoPopUp
extends PopupDialog {
    private Control content = null;
    private static final int SHELL_STYLE = 80;

    public static void showOptionHelp(Shell parent, ToolChunk toolchunk, String optionname) {
        InfoPopUp helpPop = new InfoPopUp(parent, "Help / Option: " + optionname, toolchunk.getToolType().toolname());
        Composite helpContainer = new Composite((Composite)parent, 0);
        helpContainer.setLayout((Layout)new FillLayout());
        GridData gridData = GridDataFactory.fillDefaults().grab(true, true).hint(450, 250).create();
        helpContainer.setLayoutData((Object)gridData);
        IToolOptions toolOpts = toolchunk.getToolOptions();
        String optionDesc = toolOpts.getDescription(optionname, toolchunk.getTargetValue().getString());
        String syntaxDesc = toolOpts.getArgument(optionname);
        String helpText = syntaxDesc != null ? "Syntax: " + optionname + "=" + syntaxDesc + System.lineSeparator() + System.lineSeparator() + optionDesc : optionDesc;
        Text tex = new Text(helpContainer, 586);
        tex.setText(helpText);
        helpPop.setContent((Control)helpContainer);
        helpPop.open();
    }

    public static void showPropertyEditor(Shell parent, final ToolChunk toolchunk, final String optionname) {
        PropertiesManager propertiesManager = toolchunk.getManager().getProjectFile().getPropertiesManager();
        PossiblyEscapedString optionValue = toolchunk.getOptionValue(optionname);
        InfoPopUp propertyPop = new InfoPopUp(parent, "Properties / Option: " + optionname, toolchunk.getToolType().toolname());
        List<String> properties = PropertiesManager.extractProperties(optionValue.getString());
        Composite propertyContainer = new Composite((Composite)parent, 0);
        propertyContainer.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(450, 250).create());
        propertyContainer.setLayout((Layout)new GridLayout(1, false));
        final TableViewer propertiesViewer = ViewerFactory.getPropertiesViewer(propertyContainer, propertiesManager);
        propertiesViewer.getCellEditors()[1].addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                PossiblyEscapedString optionValue = toolchunk.getOptionValue(optionname);
                propertiesViewer.setInput(PropertiesManager.extractProperties(optionValue.getString()));
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
        propertiesViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        if (properties.size() > 0) {
            propertiesViewer.setInput(properties);
            TableColumn[] tableColumnArray = propertiesViewer.getTable().getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn col = tableColumnArray[n2];
                col.pack();
                ++n2;
            }
        }
        propertyPop.setContent((Control)propertyContainer);
        propertyPop.open();
    }

    public InfoPopUp(Shell parent, String infoText) {
        this(parent, 80, false, false, false, false, false, null, infoText);
    }

    public InfoPopUp(Shell parent, String titleText, String infoText) {
        this(parent, 80, true, false, false, true, false, titleText, infoText);
    }

    public InfoPopUp(Shell parent, int shellStyle, boolean takeFocusOnOpen, boolean persistSize, boolean persistLocation, boolean showDialogMenu, boolean showPersistActions, String titleText, String infoText) {
        super(parent, shellStyle, takeFocusOnOpen, persistSize, persistLocation, showDialogMenu, showPersistActions, titleText, infoText);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.content.setParent(dialogArea);
        return dialogArea;
    }

    public void setContent(Control c) {
        this.content = c;
    }
}

