/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AbstractAddTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AddExecTargetDialog
extends AbstractAddTargetDialog {
    private ComboViewer jamaicaTargetViewer;

    public AddExecTargetDialog(Shell parentShell, ProjectFile model) {
        super(parentShell, model);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddExecTargetDialog_window_title);
    }

    protected void createTargetSpecificArea(Composite parent) {
        this.setTitle(Messages.AddExecTargetDialog_title);
        this.setMessage(Messages.AddExecTargetDialog_message);
        Group execTargetGroup = new Group(parent, 0);
        execTargetGroup.setText(Messages.AddExecTargetDialog_Exec_target_settings);
        execTargetGroup.setLayout((Layout)new GridLayout(2, false));
        execTargetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label selectTargetLabel = new Label((Composite)execTargetGroup, 0);
        selectTargetLabel.setText(String.valueOf(Messages.AddExecTargetDialog_Generate_for) + ':');
        this.jamaicaTargetViewer = ViewerFactory.getToolTargetsViewer((Composite)execTargetGroup, this.model.getToolChunkManager(), ToolType.JAMAICA, ToolType.JAMAICA_INTERNAL);
        this.jamaicaTargetViewer.getCombo().select(0);
        this.jamaicaTargetViewer.getCombo().setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void okPressed() {
        IStructuredSelection selection;
        String name = this.nameText.getText().trim();
        if ("".equals(name)) {
            this.setErrorMessage(Messages.AddExecTargetDialog_Please_specify_a_name__);
            return;
        }
        if (this.targetNameUsed(name)) {
            this.setErrorMessage("Target name is already used");
            return;
        }
        String depends = this.dependsText.getText().trim();
        if ("".equals(depends)) {
            depends = null;
        }
        if (!(selection = (IStructuredSelection)this.jamaicaTargetViewer.getSelection()).isEmpty()) {
            try {
                this.model.getExecChunkManager().addExecChunkForToolTarget(name, depends, new ArrayList<String>(), (String)selection.getFirstElement());
            }
            catch (ModelException me) {
                AntEditorPlugin.log(me);
                this.setErrorMessage(MessageFormat.format(Messages.AddExecTargetDialog_Could_not_add_new_launch_application_target___1_____2, name, me.getMessage()));
                return;
            }
        }
        super.okPressed();
    }
}

