/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.analyzer;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall3;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.CompatibleEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentAnalyzerDelegate;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaicaExeEnvAnalyzer
implements IExecutionEnvironmentAnalyzerDelegate {
    private static final String JamaicaVM_6 = "JamaicaVM-6";
    private static final String JamaicaVM_8 = "JamaicaVM-8";
    private static final String JavaSE_1_8 = "JavaSE-1.8";
    private static final String JavaSE_1_7 = "JavaSE-1.7";
    private static final String JavaSE_1_6 = "JavaSE-1.6";
    private static final String JAVA_SPEC_VERSION = "java.specification.version";
    private static final String JAVA_SPEC_NAME = "java.specification.name";
    private static final String JAVA_VERSION = "java.version";
    private static final String JAVA_VM_VERSION = "java.vm.version";
    private static final String JAVA_VM_NAME = "java.vm.name";
    private static final String JAVA_VM_VENDOR = "java.vm.vendor";
    private static final String[] VM_PROPERTIES = new String[]{"java.specification.name", "java.specification.version", "java.version", "java.vm.version", "java.vm.name", "java.vm.vendor"};
    private static final Set<IVMInstall> warnList = Collections.synchronizedSet(new HashSet());

    public CompatibleEnvironment[] analyze(final IVMInstall vm, IProgressMonitor monitor) throws CoreException {
        ArrayList<CompatibleEnvironment> result = new ArrayList<CompatibleEnvironment>();
        if (vm.getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType")) {
            ArrayList<String> types = new ArrayList<String>();
            if (!(vm instanceof IVMInstall3)) {
                return new CompatibleEnvironment[0];
            }
            IVMInstall3 vm3 = (IVMInstall3)vm;
            String vmName = "";
            String vmVersion = "";
            String vmVendor = "";
            String javaVersion = "";
            Map map = null;
            try {
                map = vm3.evaluateSystemProperties(VM_PROPERTIES, monitor);
                vmName = (String)map.get(JAVA_VM_NAME);
                vmVersion = (String)map.get(JAVA_VM_VERSION);
                vmVendor = (String)map.get(JAVA_VM_VENDOR);
                javaVersion = (String)map.get(JAVA_VERSION);
            }
            catch (CoreException ce) {
                JamaicaVMDistribution dist = JamaicaVMDistribution.findOrSetup(vm.getInstallLocation().getAbsolutePath());
                String vmError = "";
                vmName = vm.getVMInstallType().getName();
                String jreName = vm.getName();
                vmVendor = "aicas GmbH";
                if (dist != null) {
                    String testVmPath;
                    String string = testVmPath = dist.getVM(AbstractJamaicaDistribution.VMType.VM_DEFAULT) != null ? dist.getVM(AbstractJamaicaDistribution.VMType.VM_DEFAULT) : dist.getVM(AbstractJamaicaDistribution.VMType.VM_SLIM);
                    if (testVmPath != null) {
                        try {
                            Process p = Runtime.getRuntime().exec(testVmPath);
                            Scanner sc = new Scanner(p.getErrorStream());
                            if (sc.hasNext()) {
                                vmError = String.valueOf(vmError) + sc.nextLine();
                            }
                        }
                        catch (IOException ioe) {
                            LauncherPlugin.log(ioe.getMessage(), ioe);
                        }
                    } else {
                        vmError = "No VM available (!VM_DEFAULT + !VM_SLIM)";
                    }
                }
                String vmErrorMsg = vmError;
                if (!warnList.contains(vm)) {
                    warnList.add(vm);
                    String jreTypeName = vmName;
                    final String errMsgTitle = "Couldn't start " + jreTypeName + ": " + jreName;
                    final String errMsgBody = "When starting the VM binary following error occurred:" + System.lineSeparator() + System.lineSeparator() + vmErrorMsg;
                    LauncherPlugin.log(String.valueOf(errMsgTitle) + ". " + errMsgBody);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openWarning(null, (String)errMsgTitle, (String)errMsgBody);
                            warnList.remove(vm);
                        }
                    });
                }
                if (dist != null) {
                    int distVerMaj = dist.getVersionMajor();
                    int distVerMin = dist.getVersionMinor();
                    int distVerRel = dist.getVersionRelease();
                    vmVersion = String.valueOf(distVerMaj) + "." + distVerMin + "." + distVerRel;
                    if (distVerMaj >= 8) {
                        javaVersion = "1.8.0";
                    }
                    if (distVerMaj >= 6) {
                        javaVersion = "1.6.0";
                    }
                    if (distVerMaj > 3 || distVerMaj == 3 && distVerMin >= 2) {
                        javaVersion = "1.5.0";
                    }
                    return new CompatibleEnvironment[0];
                }
                return new CompatibleEnvironment[0];
            }
            if (vmName != null && vmName.toLowerCase().contains("jamaicavm") && vmVendor != null && vmVendor.toLowerCase().contains("aicas")) {
                if (vmVersion != null && vmVersion.matches("[0]?6\\.[\\d]*[\\w]*.*") && javaVersion != null && javaVersion.startsWith("1.6")) {
                    types.add(JamaicaVM_6);
                    types.add(JavaSE_1_6);
                } else if ((vmVersion != null && vmVersion.matches("[0]?6\\.[\\d]*[\\w]*.*") || vmVersion != null && vmVersion.matches("[0]?8\\.[\\d]*[\\w]*.*")) && javaVersion != null && javaVersion.startsWith("1.8")) {
                    types.add(JamaicaVM_8);
                    types.add(JamaicaVM_6);
                    types.add(JavaSE_1_8);
                    types.add(JavaSE_1_7);
                    types.add(JavaSE_1_6);
                }
            }
            int i = 0;
            while (i < types.size()) {
                this.addEnvironment(result, (String)types.get(i), i == 0);
                ++i;
            }
        }
        return result.toArray(new CompatibleEnvironment[0]);
    }

    private void addEnvironment(List<CompatibleEnvironment> result, String id, boolean strict) {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        IExecutionEnvironment env = manager.getEnvironment(id);
        if (env != null) {
            result.add(new CompatibleEnvironment(env, strict));
        }
    }
}

