/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.Messages;
import com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMNatureJob;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class LauncherPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aicas.jamaica.eclipse.launcher";
    private static LauncherPlugin plugin;
    private IVMInstallChangedListener vmInstallChangedListener = new IVMInstallChangedListener(){

        public void vmRemoved(IVMInstall vm) {
            String path;
            if (vm.getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType") && JamaicaVMDistribution.distributions.containsKey(path = LauncherPlugin.normalize(vm.getInstallLocation().getAbsolutePath()))) {
                JamaicaVMDistribution.distributions.remove(path);
            }
        }

        public void vmChanged(PropertyChangeEvent event) {
            AbstractVMInstall avm;
            if (event.getSource() instanceof AbstractVMInstall && (avm = (AbstractVMInstall)event.getSource()).getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType") && event.getProperty().equals("org.eclipse.jdt.launching.PROPERTY_NAME")) {
                String path = LauncherPlugin.normalize(avm.getInstallLocation().getAbsolutePath());
                JamaicaVMDistribution distro = JamaicaVMDistribution.findOrSetup(path);
                distro.setName(avm.getVMInstallType().getName());
            }
        }

        public void vmAdded(IVMInstall vm) {
            String path;
            JamaicaVMDistribution distro;
            if (vm.getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType") && (distro = JamaicaVMDistribution.findOrSetup(path = LauncherPlugin.normalize(vm.getInstallLocation().getAbsolutePath()))) != null) {
                distro.setName(vm.getVMInstallType().getName());
            }
        }

        public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        }
    };
    private IElementChangedListener javaProjectChangedListener = new IElementChangedListener(){

        public void elementChanged(ElementChangedEvent event) {
            if (event.getType() == 1) {
                IJavaElementDelta[] child_deltas;
                IJavaElementDelta rootdelta = event.getDelta();
                IJavaElementDelta[] iJavaElementDeltaArray = child_deltas = rootdelta.getAffectedChildren();
                int n = child_deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IJavaElementDelta delta = iJavaElementDeltaArray[n2];
                    if (delta.getKind() == 4 && (delta.getFlags() & 0x20000) != 0 || delta.getKind() == 1) {
                        IJavaProject jproj = delta.getElement().getJavaProject();
                        new JamaicaVMNatureJob(jproj).schedule();
                    }
                    ++n2;
                }
            }
        }
    };

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this.vmInstallChangedListener);
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaProjectChangedListener);
        new JamaicaVMNatureJob().schedule();
    }

    public void stop(BundleContext context) throws Exception {
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaProjectChangedListener);
        JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this.vmInstallChangedListener);
        plugin = null;
        super.stop(context);
    }

    public static LauncherPlugin getDefault() {
        return plugin;
    }

    public static Version getEclipseVersion() {
        IBundleGroupProvider[] bgps;
        String platformVersionString = null;
        IBundleGroupProvider[] iBundleGroupProviderArray = bgps = Platform.getBundleGroupProviders();
        int n = bgps.length;
        int n2 = 0;
        while (n2 < n) {
            IBundleGroupProvider bgp = iBundleGroupProviderArray[n2];
            IBundleGroup[] iBundleGroupArray = bgp.getBundleGroups();
            int n3 = iBundleGroupArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IBundleGroup bg = iBundleGroupArray[n4];
                if ("org.eclipse.platform".equals(bg.getIdentifier())) {
                    platformVersionString = bg.getVersion();
                    break;
                }
                ++n4;
            }
            ++n2;
        }
        if (platformVersionString != null) {
            return new Version(platformVersionString);
        }
        LauncherPlugin.log(Messages.LauncherPlugin_Could_not_determine_the_Eclipse_version);
        return null;
    }

    public static String normalize(String path) {
        return LauncherPlugin.normalize(path, null);
    }

    public static String normalize(String path, String relativeBase) {
        Path pp = new Path(path);
        if (relativeBase != null) {
            Path base = new Path(relativeBase);
            if (base.equals((Object)pp)) {
                return ".";
            }
            if (base.isPrefixOf((IPath)pp)) {
                IPath relative = pp.removeFirstSegments(pp.matchingFirstSegments((IPath)base));
                relative = relative.makeRelative();
                relative = relative.setDevice(null);
                return relative.toString();
            }
        }
        return pp.makeAbsolute().removeTrailingSeparator().toString();
    }

    public static void log(Throwable t) {
        LauncherPlugin.log(Messages.LauncherPlugin_generic_error_message, t);
    }

    public static void log(String message) {
        LauncherPlugin.log(message, null);
    }

    public static void log(String message, Throwable t) {
        LauncherPlugin.log(4, PLUGIN_ID, -1, message, t);
    }

    public static void log(int sev, String id, int code, String msg, Throwable t) {
        Status s = new Status(sev, id, code, msg, t);
        LauncherPlugin.getDefault().getLog().log((IStatus)s);
    }
}

