/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.BoxiOptions;
import com.aicas.jamaica.eclipse.launcher.JarExportedOptions;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.Messages;
import com.aicas.jamaica.eclipse.launcher.NullOptions;
import com.aicas.jamaica.eclipse.launcher.ToolInfoOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.JavaRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JamaicaVMDistribution
extends AbstractJamaicaDistribution {
    public static Map<String, JamaicaVMDistribution> distributions = new LinkedHashMap<String, JamaicaVMDistribution>();

    protected void initTargets(IProgressMonitor monitor) {
        monitor.subTask(Messages.JamaicaDistribution_Detecting_available_targets);
        this.availableTargets = new ArrayList();
        File targetDir = new File(String.valueOf(this.installDirectory) + File.separator + TARGET_DIRECTORY);
        if (!targetDir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(Messages.JamaicaVMDistribution_Not_a_valid_distro) + " No target directory");
        }
        String[] stringArray = targetDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String target = stringArray[n2];
            this.availableTargets.add(target);
            ++n2;
        }
        monitor.worked(10);
        monitor.subTask(Messages.JamaicaDistribution_Detecting_host_target);
        Properties rootJamaicaConf = new Properties();
        File globalConf = new File(String.valueOf(this.installDirectory) + File.separator + "etc" + File.separator + "global.conf");
        if (globalConf.isFile()) {
            try {
                rootJamaicaConf.load(new FileInputStream(globalConf));
                this.hostTarget = rootJamaicaConf.getProperty("host");
            }
            catch (IOException ioe) {
                LauncherPlugin.log(ioe);
            }
        } else {
            File jamaicaConf = new File(String.valueOf(this.installDirectory) + File.separator + "etc" + File.separator + "jamaica.conf");
            if (jamaicaConf.isFile()) {
                try {
                    rootJamaicaConf.load(new FileInputStream(jamaicaConf));
                    this.hostTarget = rootJamaicaConf.getProperty("target");
                }
                catch (IOException ioe) {
                    LauncherPlugin.log(ioe);
                }
            }
        }
        if (this.hostTarget == null) {
            String string = this.hostTarget = Platform.getOS().equals("win32") ? "windows-x86" : "linux-x86_64";
        }
        if (!this.availableTargets.contains(this.hostTarget)) {
            throw new IllegalArgumentException(Messages.JamaicaDistribution_Distribution_does_not_contain_the_declared_host_target);
        }
        monitor.worked(5);
    }

    protected void initVMs(IProgressMonitor monitor) {
        monitor.subTask(Messages.JamaicaDistribution_Detecting_available_VMs);
        this.availableVMs = new LinkedHashMap();
        String binDir = this.installDirectory;
        File targetBinDir = new File(String.valueOf(this.installDirectory) + File.separator + TARGET_DIRECTORY + this.hostTarget + File.separator + "bin");
        if (targetBinDir.isDirectory()) {
            binDir = targetBinDir.getAbsolutePath();
        } else {
            File mainBinDir = new File(String.valueOf(this.installDirectory) + File.separator + "bin");
            if (mainBinDir.isDirectory()) {
                binDir = mainBinDir.getAbsolutePath();
            }
        }
        AbstractJamaicaDistribution.VMType[] vMTypeArray = AbstractJamaicaDistribution.VMType.values();
        int n = vMTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractJamaicaDistribution.VMType vmtype = vMTypeArray[n2];
            this.tryToRegisterVM(vmtype, binDir);
            ++n2;
        }
        if (this.availableVMs.isEmpty()) {
            throw new IllegalArgumentException(Messages.JamaicaDistribution_Distribution_has_no_vms);
        }
        monitor.worked(10);
    }

    protected void initVersion(IProgressMonitor monitor) {
        monitor.subTask(Messages.JamaicaDistribution_Detecting_version);
        IOException buildInfoException = null;
        try {
            this.jamaicaVersion = this.getVersionFromBuildInfo(this.installDirectory);
        }
        catch (IOException ioe) {
            buildInfoException = ioe;
        }
        if (!(buildInfoException == null && this.jamaicaVersion != null || this.availableVMs.isEmpty())) {
            AbstractJamaicaDistribution.VMType vmt = this.availableVMs.keySet().toArray(new AbstractJamaicaDistribution.VMType[0])[0];
            this.jamaicaVersion = this.getVersionFromBinary(vmt, "-version");
        }
        if (this.jamaicaVersion == null) {
            this.jamaicaVersion = Messages.JamaicaDistribution_Unknown;
            LauncherPlugin.log(MessageFormat.format(Messages.JamaicaDistribution_Could_not_determine_the_version_string_for_distribution___1__, this.installDirectory));
        }
        this.parseVersionSegments();
        this.isDeveloperBuild = new File(String.valueOf(this.installDirectory) + File.separator + "jconfigure.status").isFile();
        monitor.worked(10);
    }

    protected void initTools(IProgressMonitor monitor) {
        monitor.subTask(Messages.JamaicaDistribution_Detecting_available_tools);
        ArrayList<ToolType> tools = new ArrayList<ToolType>();
        tools.add(ToolType.JAMAICA);
        tools.add(ToolType.JAMAICAH);
        tools.add(ToolType.THREADMONITOR);
        if (this.getVersionMajor() >= 6) {
            if (this.isDeveloperBuild()) {
                tools.add(ToolType.JAMAICA_INTERNAL);
                tools.add(ToolType.JAMAICAH_INTERNAL);
            }
            if (this.getVersionMajor() > 6 || this.getVersionMajor() == 6 && this.getVersionMinor() >= 4) {
                tools.add(ToolType.JARACCELERATOR);
            }
            if (this.getVersionMajor() > 8 || this.getVersionMajor() == 8 && this.getVersionMinor() >= 5) {
                tools.add(ToolType.PROFILE_ANALYZER);
            }
        }
        Exception e = null;
        for (ToolType tool : tools) {
            e = this.tryToRegisterTool(tool);
            if (e == null) continue;
            LauncherPlugin.log("In " + (Object)((Object)this) + ": Could not register tool: " + tool.toolname(), e);
        }
        monitor.worked(10);
    }

    public JamaicaVMDistribution(String installDirectory, IProgressMonitor monitor) {
        this.distroType = AbstractJamaicaDistribution.DistroType.VM;
        this.installDirectory = installDirectory;
        this.name = JavaRuntime.getVMInstallType((String)"com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType").getName();
        this.availableTools = new LinkedHashMap();
        monitor.beginTask(MessageFormat.format(Messages.JamaicaDistribution_Getting_distribution_information_for___1__, installDirectory), 45);
        this.initTargets(monitor);
        this.initVMs(monitor);
        this.initVersion(monitor);
        this.initTools(monitor);
        if (!this.isWorkingBuild()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.JamaicaDistribution_Distribution___1___will_not_work_properly_as_a_JRE___, installDirectory));
        }
        monitor.done();
    }

    public static JamaicaVMDistribution findOrSetup(String path) {
        return JamaicaVMDistribution.findOrSetup(path, null);
    }

    public static JamaicaVMDistribution findOrSetup(String path, StringBuilder errDesc) {
        return (JamaicaVMDistribution)JamaicaVMDistribution.findOrSetup((String)path, (StringBuilder)errDesc, distributions, JamaicaVMDistribution.class);
    }

    protected Exception tryToRegisterTool(ToolType tool) {
        Exception retval = null;
        int major = this.getVersionMajor();
        int minor = this.getVersionMinor();
        Object toolOptions = null;
        toolOptions = major > 8 || major == 8 && minor >= 5 ? new ToolInfoOptions() : (major >= 6 ? new JarExportedOptions() : (major > 3 || major == 3 && minor >= 2 ? new BoxiOptions() : new NullOptions()));
        try {
            toolOptions.init((AbstractJamaicaDistribution)this, tool);
            this.availableTools.put(tool, toolOptions);
        }
        catch (Exception e) {
            retval = e;
        }
        return retval;
    }

    protected void tryToRegisterVM(final AbstractJamaicaDistribution.VMType type, String binDir) {
        FilenameFilter vmBinaryFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return type.name().startsWith("VM") && type.getPattern().matcher(name).matches();
            }
        };
        String[] foundVmBinaries = null;
        File vmExeDir = new File(binDir);
        File chosenVmExe = null;
        if (vmExeDir.exists()) {
            foundVmBinaries = vmExeDir.list(vmBinaryFilter);
        }
        if (foundVmBinaries != null && foundVmBinaries.length > 0) {
            chosenVmExe = new File(String.valueOf(binDir) + File.separator + foundVmBinaries[0]);
        }
        if (chosenVmExe != null && chosenVmExe.exists()) {
            this.availableVMs.put(type, LauncherPlugin.normalize(chosenVmExe.getAbsolutePath()));
        }
    }

    public String getTargetBinDirectory(String target) {
        if (this.availableTargets.contains(target)) {
            return LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "bin");
        }
        return null;
    }

    public String getClassesDirectory(String target) {
        String retval = null;
        if (this.availableTargets.contains(target) && !this.fileExists(retval = LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "classes"), true)) {
            retval = null;
        }
        return retval;
    }

    public String getClassesJar(String target) {
        String retval = null;
        if (this.availableTargets.contains(target) && !this.fileExists(retval = this.getVersionMajor() > 0 && this.getVersionMajor() < 6 ? LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "classes" + File.separator + "jamaica-classes.jar") : (this.getVersionMajor() > 5 && this.getVersionMajor() < 9 ? LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "lib" + File.separator + "rt.jar") : (this.getVersionMajor() > 8 && this.getVersionMajor() < 18 ? LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "modules" + File.separator + "java.base.jar") : LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "lib" + File.separator + "rt.jar"))), false)) {
            retval = null;
        }
        return retval;
    }

    protected String[] getLibraryJARS(String target, File libFolder, final List<String> filterList) {
        String[] detectedJars = new String[]{};
        if (this.availableTargets.contains(target) && libFolder.isDirectory()) {
            detectedJars = libFolder.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return filterList.contains(name);
                }
            });
            int i = 0;
            while (i < detectedJars.length) {
                detectedJars[i] = LauncherPlugin.normalize(libFolder + File.separator + detectedJars[i]);
                ++i;
            }
        }
        return detectedJars;
    }

    public String[] getAdditionalLibraryJARS(String target) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> filterList = new ArrayList<String>();
        if (this.getVersionMajor() > 8) {
            File targetModuleFolder = new File(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "modules");
            File[] fileArray = targetModuleFolder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File module = fileArray[n2];
                if (module.isFile() && module.getName().endsWith(".jar") && !module.getName().equals("java.base.jar")) {
                    filterList.add(module.getName());
                }
                ++n2;
            }
            result.addAll(Arrays.asList(this.getLibraryJARS(target, targetModuleFolder, filterList)));
        }
        File targetLibFolder = new File(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "lib");
        filterList = Arrays.asList("resources.jar", "jsse.jar", "jce.jar", "charsets.jar", "jfr.jar");
        result.addAll(Arrays.asList(this.getLibraryJARS(target, targetLibFolder, filterList)));
        return result.toArray(new String[0]);
    }

    public String[] getExtensionLibraryJARS(String target) {
        File targetExtensionFolder = new File(String.valueOf(this.installDirectory) + File.separator + "target" + File.separator + target + File.separator + "lib" + File.separator + "ext");
        List<String> filterList = Arrays.asList("localedata.jar", "sunec.jar", "sunjce_provider.jar", "nashorn.jar", "jaccess.jar", "zipfs.jar", "jfxrt.jar", "cldrdata.jar", "dnsns.jar", "sunpkcs11.jar");
        return this.getLibraryJARS(target, targetExtensionFolder, filterList);
    }

    public boolean isWorkingBuild() {
        return this.availableVMs.size() > 0 && this.getClassesJar(this.getHostTarget()) != null;
    }

    public String getBuildInfoFile() {
        String retval = null;
        retval = LauncherPlugin.normalize(String.valueOf(this.installDirectory) + File.separator + BUILD_INFO);
        if (!this.fileExists(retval, false)) {
            retval = null;
        }
        return retval;
    }

    protected String getVersionFromBinary(AbstractJamaicaDistribution.VMType vmtype, String versionOption) {
        String result = null;
        String regexOld = ".*[Jj]amaica.*[Vv]ersion (\\d+[.]\\d+.*)";
        String regexNew = ".*[Jj]amaicaVM.*[Bb]uild (\\d+[.]\\d+.*)[)]";
        Pattern[] verPats = new Pattern[]{Pattern.compile(".*[Jj]amaicaVM.*[Bb]uild (\\d+[.]\\d+.*)[)]"), Pattern.compile(".*[Jj]amaica.*[Vv]ersion (\\d+[.]\\d+.*)")};
        String versionOutput = super.getVersionFromBinary(vmtype, versionOption);
        if (versionOutput != null) {
            Pattern[] patternArray = verPats;
            int n = verPats.length;
            int n2 = 0;
            while (n2 < n) {
                Pattern pat = patternArray[n2];
                Matcher mat = pat.matcher(versionOutput);
                if (mat.matches()) {
                    result = mat.group(1);
                    break;
                }
                ++n2;
            }
        }
        return result;
    }
}

