/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class OpenTraceHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IProject project = null;
        IJavaProject jp = null;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof IEditorPart) {
            IEditorPart editor = page.getActiveEditor();
            if (editor != null) {
                IEditorInput input = editor.getEditorInput();
                IFile ifile = ((FileEditorInput)input).getFile();
                project = ifile.getProject();
                jp = JavaCore.create((IProject)project);
            }
        } else {
            IStructuredSelection selection = (IStructuredSelection)window.getSelectionService().getSelection();
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof IResource) {
                IProject p = ((IResource)firstElement).getProject();
                jp = JavaCore.create((IProject)p);
            } else if (firstElement instanceof IJavaElement) {
                jp = ((IJavaElement)firstElement).getJavaProject();
            } else if (firstElement instanceof PackageFragmentRootContainer) {
                jp = ((PackageFragmentRootContainer)firstElement).getJavaProject();
            }
        }
        if (jp != null) {
            String distroPath;
            JamaicaVMDistribution distro;
            IToolOptions traceOptions;
            IVMInstall vm = null;
            try {
                vm = JavaRuntime.getVMInstall(jp);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (vm != null && (traceOptions = (distro = JamaicaVMDistribution.findOrSetup(distroPath = vm.getInstallLocation().getAbsolutePath())).getToolOptions(ToolType.THREADMONITOR)) != null) {
                String tracePath = traceOptions.getToolPath();
                String javaHome = System.getProperty("java.home");
                if (javaHome != null) {
                    String[] binNames = new String[]{"java", "java.exe"};
                    Path javaBinary = null;
                    int i = 0;
                    while (i < binNames.length) {
                        javaBinary = new Path(String.valueOf(javaHome) + File.separator + "bin" + File.separator + binNames[i]);
                        if (javaBinary.toFile().canExecute()) break;
                        ++i;
                    }
                    try {
                        if (javaBinary.toFile().canExecute()) {
                            String javaPath = javaBinary.makeAbsolute().toOSString();
                            String[] cmdArgs = new String[]{javaPath, "-jar", tracePath};
                            Runtime.getRuntime().exec(cmdArgs);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }
}

