/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.wizards;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.ui.MainMethodSearchEngine;
import com.aicas.jamaica.eclipse.ant_editor.wizards.Messages;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class GeneralSettingsWizardPage
extends WizardPage {
    private IStructuredSelection selection;
    private Label activeDistributionLabel;
    private Label threadmonitorModeLabel;
    private ComboViewer targetChooser;
    private Text fileNameField;
    private Text projectField;
    private Text mainClassField;
    private Text destinationField;
    private Text tracePortField;
    private DialogEntry traceOptGroup;
    private Button createThreadMonitorAppButton;
    private Button createExecLaunchTargetButton;
    private Button threadmonitorModeBlockingButton;
    private Button threadmonitorModeNonBlockingButton;
    private Button noMainButton;
    private Button mainClassBrowse;
    private String fileName;
    private String project;
    private String mainClass;
    private String target;
    private String destination;
    private String tracePort;
    private boolean createExecLaunchTarget;
    private boolean createThreadMonitorApp;
    private boolean threadmonitorModeBlocking;
    private boolean noMainClass;
    private JamaicaVMDistribution distribution;
    private IType[] types = null;
    private final ModifyListener dialogChangedListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            Text eventTextField;
            Object eventSource = e.getSource();
            if (eventSource instanceof Text && (eventTextField = (Text)eventSource).equals(GeneralSettingsWizardPage.this.projectField)) {
                GeneralSettingsWizardPage.this.activeDistributionLabel.setText("");
                GeneralSettingsWizardPage.this.targetChooser.setInput(null);
                String projectName = GeneralSettingsWizardPage.this.projectField.getText();
                IJavaProject jProj = AntEditorPlugin.getJavaProjectByName(projectName);
                IVMInstall vmInstall = null;
                try {
                    if (jProj != null) {
                        vmInstall = JavaRuntime.getVMInstall((IJavaProject)jProj);
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (vmInstall != null) {
                    String vmLoc = vmInstall.getInstallLocation().getAbsolutePath();
                    JamaicaVMDistribution dist = JamaicaVMDistribution.findOrSetup((String)vmLoc);
                    if (dist != null) {
                        GeneralSettingsWizardPage.this.targetChooser.setInput((Object)dist.getAvailableTargets());
                        GeneralSettingsWizardPage.this.targetChooser.setSelection((ISelection)new StructuredSelection((Object)dist.getHostTarget()));
                        GeneralSettingsWizardPage.this.activeDistributionLabel.setText(dist.toString());
                        GeneralSettingsWizardPage.this.distribution = dist;
                    } else {
                        GeneralSettingsWizardPage.this.activeDistributionLabel.setText(vmInstall.getName());
                    }
                }
            }
            GeneralSettingsWizardPage.this.dialogChanged();
        }
    };

    public GeneralSettingsWizardPage(IStructuredSelection selection) {
        super("GeneralSettingsWizardPage");
        this.setTitle(Messages.GeneralSettingsWizardPage_title);
        this.setDescription(Messages.GeneralSettingsWizardPage_description);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite dialogComposite = new Composite(parent, 0);
        GridLayout dialogCompositeLayout = new GridLayout();
        dialogCompositeLayout.numColumns = 3;
        dialogCompositeLayout.makeColumnsEqualWidth = false;
        dialogCompositeLayout.verticalSpacing = 10;
        dialogComposite.setLayout((Layout)dialogCompositeLayout);
        Label fileNameLabel = new Label(dialogComposite, 0);
        fileNameLabel.setText(String.valueOf(Messages.GeneralSettingsWizardPage_File_name) + ':');
        this.fileNameField = new Text(dialogComposite, 2048);
        this.fileNameField.setLayoutData((Object)new GridData(4, -1, true, false, 2, 1));
        this.fileNameField.addModifyListener(this.dialogChangedListener);
        Group projectGroup = new Group(dialogComposite, 0);
        projectGroup.setText(Messages.GeneralSettingsWizardPage_Project_settings);
        projectGroup.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        projectGroup.setLayout((Layout)new GridLayout(3, false));
        Label projectLabel = new Label((Composite)projectGroup, 0);
        projectLabel.setText(String.valueOf(Messages.GeneralSettingsWizardPage_Project) + ':');
        this.projectField = new Text((Composite)projectGroup, 2048);
        this.projectField.setLayoutData((Object)new GridData(4, -1, true, false));
        this.projectField.addModifyListener(this.dialogChangedListener);
        Button projectBrowse = new Button((Composite)projectGroup, 0);
        projectBrowse.setText(Messages.GeneralSettingsWizardPage_Browse______);
        projectBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralSettingsWizardPage.this.handleProjectBrowse();
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        Label distributionLabel = new Label((Composite)projectGroup, 0);
        distributionLabel.setText(String.valueOf(Messages.GeneralSettingsWizardPage_Project_JRE) + ':');
        this.activeDistributionLabel = new Label((Composite)projectGroup, 0);
        this.activeDistributionLabel.setLayoutData((Object)new GridData(4, -1, true, false));
        Group jamaicaGroup = new Group(dialogComposite, 0);
        jamaicaGroup.setText(Messages.GeneralSettingsWizardPage_Jamaica_settings);
        jamaicaGroup.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        jamaicaGroup.setLayout((Layout)new GridLayout(2, false));
        Label targetLabel = new Label((Composite)jamaicaGroup, 0);
        targetLabel.setText(String.valueOf(Messages.GeneralSettingsWizardPage_Target_platform) + ':');
        this.targetChooser = new ComboViewer((Composite)jamaicaGroup, 12);
        this.targetChooser.getControl().setLayoutData((Object)new GridData(4, -1, true, false));
        this.targetChooser.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.targetChooser.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetChooser.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GeneralSettingsWizardPage.this.handleTargetChange();
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        Group applicationGroup = new Group(dialogComposite, 0);
        applicationGroup.setText(Messages.GeneralSettingsWizardPage_Application_settings);
        applicationGroup.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        applicationGroup.setLayout((Layout)new GridLayout(3, false));
        final DialogEntry mainClassEntry = new DialogEntry((Composite)applicationGroup, 0);
        mainClassEntry.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        Label mainClassLabel = new Label((Composite)mainClassEntry, 0);
        mainClassLabel.setText(String.valueOf(Messages.GeneralSettingsWizardPage_Main_class) + ':');
        this.mainClassField = new Text((Composite)mainClassEntry, 2048);
        this.mainClassField.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        this.mainClassField.addModifyListener(this.dialogChangedListener);
        this.mainClassBrowse = new Button((Composite)mainClassEntry, 8);
        this.mainClassBrowse.setText(Messages.GeneralSettingsWizardPage_Browse______);
        this.mainClassBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralSettingsWizardPage.this.handleMainClassBrowse();
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        this.noMainButton = new Button((Composite)applicationGroup, 32);
        final DialogEntry destinationEntry = new DialogEntry((Composite)applicationGroup, 0);
        destinationEntry.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        this.noMainButton.setText(String.valueOf(Messages.GeneralSettingsWizardPage_No_Main_class_wanted) + " " + Messages.GeneralSettingsWizardPage_configures_required_options__);
        this.noMainButton.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        this.noMainButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralSettingsWizardPage.this.noMainClass = GeneralSettingsWizardPage.this.noMainButton.getSelection();
                mainClassEntry.setEnabled(!GeneralSettingsWizardPage.this.noMainClass);
                destinationEntry.setEnabled(GeneralSettingsWizardPage.this.noMainClass);
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        Label destinationLabel = new Label((Composite)destinationEntry, 0);
        destinationLabel.setText("      " + Messages.GeneralSettingsWizardPage_Vm_Name + ':');
        this.destinationField = new Text((Composite)destinationEntry, 2048);
        this.destinationField.setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        this.destinationField.addModifyListener(this.dialogChangedListener);
        destinationEntry.setEnabled(this.noMainButton.getSelection());
        Group optionsGroup = new Group(dialogComposite, 0);
        optionsGroup.setText(Messages.GeneralSettingsWizardPage_Options);
        optionsGroup.setLayout((Layout)new GridLayout(3, false));
        optionsGroup.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        this.createExecLaunchTargetButton = new Button((Composite)optionsGroup, 32);
        this.createExecLaunchTargetButton.setText(Messages.GeneralSettingsWizardPage_Create_launch_target);
        this.createExecLaunchTargetButton.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        this.createExecLaunchTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        new Label((Composite)optionsGroup, 258).setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        this.createThreadMonitorAppButton = new Button((Composite)optionsGroup, 32);
        this.createThreadMonitorAppButton.setLayoutData((Object)new GridData(-1, -1, true, false, 2, 1));
        this.createThreadMonitorAppButton.setText(Messages.GeneralSettingsWizardPage_Enable_JamaicaTrace);
        this.createThreadMonitorAppButton.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
        this.createThreadMonitorAppButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                GeneralSettingsWizardPage.this.handleTraceInterfaceChange();
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        this.traceOptGroup = new DialogEntry((Composite)optionsGroup, 0);
        this.traceOptGroup.setLayoutData(new GridData(4, -1, true, false, 3, 1));
        this.threadmonitorModeLabel = new Label((Composite)this.traceOptGroup, 0);
        this.threadmonitorModeLabel.setText("      Mode:");
        this.threadmonitorModeBlockingButton = new Button((Composite)this.traceOptGroup, 16);
        this.threadmonitorModeBlockingButton.setText("Blocking");
        this.threadmonitorModeBlockingButton.setSelection(true);
        this.threadmonitorModeBlockingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                GeneralSettingsWizardPage.this.dialogChanged();
            }
        });
        this.threadmonitorModeNonBlockingButton = new Button((Composite)this.traceOptGroup, 16);
        this.threadmonitorModeNonBlockingButton.setText("Non-Blocking");
        Label tmPortLabel = new Label((Composite)this.traceOptGroup, 0);
        tmPortLabel.setText("      Port:");
        this.tracePortField = new Text((Composite)this.traceOptGroup, 2048);
        this.tracePortField.setText("2468");
        GridDataFactory.swtDefaults().hint(100, -1).applyTo((Control)this.tracePortField);
        this.tracePortField.addModifyListener(this.dialogChangedListener);
        this.setControl((Control)dialogComposite);
        this.initialize();
        this.handleTargetChange();
        this.handleTraceInterfaceChange();
        this.dialogChanged();
    }

    private void handleTargetChange() {
        if (this.distribution != null && !this.distribution.getHostTarget().equals(((IStructuredSelection)this.targetChooser.getSelection()).getFirstElement())) {
            this.createExecLaunchTargetButton.setSelection(false);
            this.createExecLaunchTargetButton.setEnabled(false);
        } else {
            this.createExecLaunchTargetButton.setEnabled(true);
            this.createExecLaunchTargetButton.setSelection(true);
        }
    }

    private void handleTraceInterfaceChange() {
        boolean tmInterfaceWanted = this.createThreadMonitorAppButton.getSelection();
        this.traceOptGroup.setEnabled(tmInterfaceWanted);
    }

    private void initialize() {
        IStructuredSelection ssel;
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection && (ssel = this.selection).size() > 0) {
            IJavaProject jproj;
            Object obj = ssel.getFirstElement();
            if (obj instanceof IResource) {
                IResource res = (IResource)obj;
                IJavaProject proj = AntEditorPlugin.getJavaProjectByName(res.getProject().getName());
                if (proj != null) {
                    this.projectField.setText(proj.getProject().getName());
                }
            } else if (obj instanceof IJavaElement) {
                IJavaElement javaElement = (IJavaElement)obj;
                IType[] typesToCheck = new IType[]{};
                try {
                    if (javaElement.getElementType() == 5) {
                        ICompilationUnit cUnit = (ICompilationUnit)javaElement;
                        typesToCheck = cUnit.getAllTypes();
                    } else if (javaElement.getElementType() == 7) {
                        IType javaType = (IType)javaElement;
                        typesToCheck = new IType[]{javaType};
                    }
                    IType[] iTypeArray = typesToCheck;
                    int n = typesToCheck.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IType type = iTypeArray[n2];
                        IMethod[] iMethodArray = type.getMethods();
                        int n3 = iMethodArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IMethod method = iMethodArray[n4];
                            if (method.isMainMethod()) {
                                this.mainClassField.setText(type.getFullyQualifiedName('.'));
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException jme) {
                    AntEditorPlugin.log(jme);
                }
                this.projectField.setText(javaElement.getJavaProject().getProject().getName());
            }
            if ((jproj = AntEditorPlugin.getJavaProjectByName(this.projectField.getText())) != null) {
                String vmLoc;
                JamaicaVMDistribution dist;
                IVMInstall vmInstall = null;
                try {
                    vmInstall = JavaRuntime.getVMInstall((IJavaProject)jproj);
                }
                catch (CoreException jme) {
                    // empty catch block
                }
                if (vmInstall != null && (dist = JamaicaVMDistribution.findOrSetup((String)(vmLoc = vmInstall.getInstallLocation().getAbsolutePath()))) != null) {
                    this.distribution = dist;
                    this.activeDistributionLabel.setText(dist.toString());
                    this.targetChooser.setInput((Object)dist.getAvailableTargets());
                    this.targetChooser.setSelection((ISelection)new StructuredSelection((Object)dist.getHostTarget()));
                    this.createExecLaunchTargetButton.setSelection(true);
                }
            }
        }
        this.fileNameField.setText("build_jamaica.xml");
    }

    private void handleProjectBrowse() {
        Object first;
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(Messages.GeneralSettingsWizardPage_Select_a_project);
        dialog.setMessage(String.valueOf(Messages.GeneralSettingsWizardPage_Filter_projects) + ':');
        try {
            dialog.setElements((Object[])JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects());
        }
        catch (JavaModelException jme) {
            AntEditorPlugin.log(jme);
        }
        if (dialog.open() == 0 && (first = dialog.getFirstResult()) instanceof IJavaProject) {
            this.projectField.setText(((IJavaProject)first).getProject().getName());
        }
    }

    private void handleMainClassBrowse() {
        IJavaProject project = AntEditorPlugin.getJavaProjectByName(this.projectField.getText());
        IJavaElement[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    AntEditorPlugin.log(e);
                }
            }
        } else {
            elements = new IJavaElement[]{project};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        final IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        final MainMethodSearchEngine engine = new MainMethodSearchEngine();
        try {
            this.getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    GeneralSettingsWizardPage.this.types = engine.searchMainMethods(monitor, searchScope, true);
                }
            });
        }
        catch (Exception e) {
            AntEditorPlugin.log(e);
        }
        ElementListSelectionDialog elsd = new ElementListSelectionDialog(AntEditorPlugin.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IType) {
                    IType t = (IType)element;
                    return MessageFormat.format(Messages.GeneralSettingsWizardPage_main_class_format, t.getFullyQualifiedName('.'), t.getPath().toString());
                }
                return null;
            }
        });
        elsd.setTitle(Messages.GeneralSettingsWizardPage_Select_a_main_type);
        elsd.setMessage(String.valueOf(Messages.GeneralSettingsWizardPage_Filter_types) + ':');
        elsd.setElements((Object[])this.types);
        if (elsd.open() == 1) {
            return;
        }
        Object[] results = elsd.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.mainClassField.setText(type.getFullyQualifiedName('.'));
            this.projectField.setText(type.getJavaProject().getElementName());
        }
    }

    private void dialogChanged() {
        String ext;
        String curFileName = this.fileNameField.getText();
        String curProject = this.projectField.getText();
        String curTarget = (String)((IStructuredSelection)this.targetChooser.getSelection()).getFirstElement();
        String curMainClass = this.mainClassField.getText();
        String curDestination = this.destinationField.getText();
        String curTracePort = this.tracePortField.getText();
        boolean curCreateThreadMonitorApp = this.createThreadMonitorAppButton.getSelection();
        boolean curThreadMonitorModeBlocking = this.threadmonitorModeBlockingButton.getSelection();
        boolean curCreateExecLaunchTarget = this.createExecLaunchTargetButton.getSelection();
        if (curProject.length() < 1) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_Java_project_name_must_be_specified__);
            return;
        }
        IJavaProject javaProject = AntEditorPlugin.getJavaProjectByName(curProject);
        if (javaProject == null || !javaProject.exists() || (javaProject.getProject().getType() & 6) == 0) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_Java_project_must_exist__);
            return;
        }
        IVMInstall vmInstall = null;
        try {
            vmInstall = JavaRuntime.getVMInstall((IJavaProject)javaProject);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (vmInstall == null || !vmInstall.getVMInstallType().getId().equals("com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType")) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_Java_project_jre_must_be_jamaica__);
            return;
        }
        String vmLocation = vmInstall.getInstallLocation().getAbsolutePath();
        JamaicaVMDistribution curDist = JamaicaVMDistribution.findOrSetup((String)vmLocation);
        if (!javaProject.getProject().isAccessible()) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_Project_must_be_writable__);
            return;
        }
        if (curFileName.length() < 1) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_File_name_must_be_specified__);
            return;
        }
        if (curFileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_File_name_must_be_valid__);
            return;
        }
        int dotLoc = curFileName.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = curFileName.substring(dotLoc + 1)).equalsIgnoreCase("xml")) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_File_extension_must_be_____xml____);
            return;
        }
        if (this.targetChooser.getSelection().isEmpty()) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_No_target_selected__);
            return;
        }
        if (curMainClass.length() < 1 && !this.noMainClass) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_Main_class_must_be_set__);
            return;
        }
        IType curMainClassType = null;
        if (!this.noMainClass && !curMainClass.isEmpty()) {
            String complianceLevel;
            String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
            IStatus status = JavaConventions.validateJavaTypeName((String)curMainClass, (String)sourceLevel, (String)(complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)));
            if (!status.isOK()) {
                this.updateStatus(status.getMessage());
                return;
            }
            try {
                curMainClassType = javaProject.findType(curMainClass);
                if (curMainClassType == null) {
                    this.updateStatus(Messages.GeneralSettingsWizardPage_Main_class_must_exist);
                    return;
                }
            }
            catch (JavaModelException e) {
                this.updateStatus(Messages.GeneralSettingsWizardPage_Error_while_checking_existence_of_main_class);
                return;
            }
        }
        if (curDestination.length() < 1 && this.noMainClass) {
            this.updateStatus(Messages.GeneralSettingsWizardPage_Destination_class_must_be_set__);
            return;
        }
        if (curCreateThreadMonitorApp) {
            try {
                int tracePortNum = Integer.parseInt(curTracePort);
                if (tracePortNum < 0 || tracePortNum > 65535) {
                    this.updateStatus(Messages.GeneralSettingsWizardPage_Trace_port_must_be_number_between);
                    return;
                }
            }
            catch (NumberFormatException nfe) {
                this.updateStatus(Messages.GeneralSettingsWizardPage_Trace_port_must_be_number);
                return;
            }
        }
        this.fileName = curFileName;
        this.project = curProject;
        this.distribution = curDist;
        this.target = curTarget;
        this.tracePort = curTracePort;
        if (curMainClassType != null) {
            this.mainClass = curMainClassType.getFullyQualifiedName();
        }
        this.destination = curDestination;
        this.createExecLaunchTarget = curCreateExecLaunchTarget;
        this.createThreadMonitorApp = curCreateThreadMonitorApp;
        this.threadmonitorModeBlocking = curThreadMonitorModeBlocking;
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getProject() {
        return this.project;
    }

    public JamaicaVMDistribution getDistribution() {
        return this.distribution;
    }

    public String getTarget() {
        return this.target;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public boolean getCreateExecLaunchTarget() {
        return this.createExecLaunchTarget;
    }

    public boolean getCreateThreadMonitorApp() {
        return this.createThreadMonitorApp;
    }

    public boolean getThreadMonitorBlockingMode() {
        return this.threadmonitorModeBlocking;
    }

    public String getTracePort() {
        return this.tracePort;
    }

    public boolean getNoMainClass() {
        return this.noMainClass;
    }

    public String getDestination() {
        return this.destination;
    }

    static class DialogEntry
    extends Composite {
        public DialogEntry(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new GridLayout(5, false));
        }

        public void setEnabled(boolean state) {
            super.setEnabled(state);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setEnabled(state);
                ++n2;
            }
        }
    }
}

