/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class CheckboxList
extends ScrolledComposite {
    private List<String> itemList = new ArrayList<String>();
    private Map<String, Button> itemMap = new HashMap<String, Button>();
    private Composite content;
    private RowLayout rowLayout;

    public CheckboxList(Composite parent, int style) {
        super(parent, style);
        if (style == 512) {
            this.rowLayout = new RowLayout(256);
        } else if (style == 256) {
            this.rowLayout = new RowLayout(512);
        }
        this.rowLayout.pack = false;
        this.rowLayout.fill = true;
        this.rowLayout.center = true;
        this.rowLayout.justify = false;
        this.rowLayout.wrap = true;
        this.rowLayout.spacing = 10;
        this.content = new Composite((Composite)this, 0);
        this.content.setLayout((Layout)this.rowLayout);
        this.setExpandVertical(true);
        this.setExpandHorizontal(true);
        this.setShowFocusedControl(true);
        this.setContent((Control)this.content);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (((CheckboxList)CheckboxList.this).rowLayout.type == 256) {
                    int width = CheckboxList.this.getClientArea().width;
                    Point p = CheckboxList.this.content.computeSize(width, -1);
                    CheckboxList.this.setMinSize(p);
                } else {
                    int height = CheckboxList.this.getClientArea().height;
                    Point p = CheckboxList.this.content.computeSize(-1, height);
                    CheckboxList.this.setMinSize(p);
                }
            }
        });
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemList.size()) {
            this.itemList.add(index, string);
            this.rebuildList();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        for (String item : this.itemList) {
            this.itemMap.get(item).setSelection(false);
        }
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.itemList.clear();
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item != null && !item.isEmpty()) {
                this.itemList.add(item);
            }
            ++n2;
        }
        this.rebuildList();
        this.content.pack();
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        ArrayList<Integer> selected = new ArrayList<Integer>();
        int i = 0;
        while (i < this.itemList.size()) {
            if (this.itemMap.get(this.itemList.get(i)).getSelection()) {
                selected.add(i);
            }
            ++i;
        }
        int[] retval = new int[selected.size()];
        int i2 = 0;
        while (i2 < retval.length) {
            retval[i2] = (Integer)selected.get(i2);
            ++i2;
        }
        return retval;
    }

    public void setEnabled(boolean enabled) {
        for (String item : this.itemList) {
            Button b = this.itemMap.get(item);
            if (b == null) continue;
            b.setEnabled(enabled);
        }
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemList.size();
    }

    public void removeAll() {
        this.checkWidget();
        this.itemList.clear();
        this.rebuildList();
    }

    private void rebuildList() {
        boolean[] selectionState = new boolean[this.itemList.size()];
        int i = 0;
        while (i < this.itemList.size()) {
            Button b = this.itemMap.get(this.itemList.get(i));
            selectionState[i] = b != null ? b.getSelection() : false;
            ++i;
        }
        Control[] controlArray = this.content.getChildren();
        int n = controlArray.length;
        int b = 0;
        while (b < n) {
            Control kid = controlArray[b];
            kid.dispose();
            ++b;
        }
        this.itemMap.clear();
        i = 0;
        while (i < this.itemList.size()) {
            Button b2 = new Button(this.content, 32);
            b2.setText(this.itemList.get(i));
            b2.setSelection(selectionState[i]);
            b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectEvent) {
                    Event event = new Event();
                    event.type = 13;
                    event.item = selectEvent.widget;
                    event.display = selectEvent.display;
                    CheckboxList.this.notifyListeners(13, event);
                }
            });
            b2.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent e) {
                    int keycode = e.keyCode;
                    Point origin = CheckboxList.this.getOrigin();
                    switch (keycode) {
                        case 0x1000001: {
                            CheckboxList.this.setOrigin(origin.x, origin.y - 64);
                            break;
                        }
                        case 0x1000002: {
                            CheckboxList.this.setOrigin(origin.x, origin.y + 64);
                            break;
                        }
                        case 0x1000003: {
                            CheckboxList.this.setOrigin(origin.x - 64, origin.y);
                            break;
                        }
                        case 0x1000004: {
                            CheckboxList.this.setOrigin(origin.x + 64, origin.y);
                        }
                    }
                }
            });
            this.itemMap.put(this.itemList.get(i), b2);
            ++i;
        }
    }

    public void remove(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemList.size()) {
            this.itemList.remove(index);
            Button b = this.itemMap.get(this.itemList.get(index));
            b.dispose();
            this.itemMap.remove(this.itemList.get(index));
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (index >= 0 && index < this.itemList.size()) {
            this.itemMap.get(this.itemList.get(index)).setText(string);
        }
    }

    public void select(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemList.size()) {
            this.itemMap.get(this.itemList.get(index)).setSelection(true);
        }
    }
}

