/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.DOMUtils;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ToolEnvProp {
    private final ToolChunk toolChunk;
    public static final String ATTR_PREFIX = "prefix";
    public static final String TAG_PROPREF = "propertyref";
    private Element optionElement;

    public ToolEnvProp(ToolChunk toolChunk, Element optElement) {
        this.toolChunk = toolChunk;
        this.optionElement = optElement;
    }

    public List<String> getPrefixes() {
        ArrayList<String> retval = new ArrayList<String>();
        NodeList childNodes = this.optionElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode instanceof Element && childNode.getNodeName().equals(TAG_PROPREF)) {
                Element childElement = (Element)childNode;
                String propPrefix = childElement.getAttribute(ATTR_PREFIX);
                retval.add(propPrefix);
            }
            ++i;
        }
        return retval;
    }

    public void addPrefix(String prefix) {
        if (!this.getPrefixes().contains(prefix)) {
            Element newPrefixElement = this.toolChunk.getManager().getProjectFile().getDocument().createElement(TAG_PROPREF);
            newPrefixElement.setAttribute(ATTR_PREFIX, prefix);
            DOMUtils.appendNode(this.optionElement, newPrefixElement);
        }
    }

    public void removePrefix(String prefix) {
        if (this.getPrefixes().contains(prefix)) {
            NodeList proprefs = this.optionElement.getElementsByTagName(TAG_PROPREF);
            int i = 0;
            while (i < proprefs.getLength()) {
                Element e;
                Node n = proprefs.item(i);
                if (n.getParentNode().equals(this.optionElement) && (e = (Element)n).getAttribute(ATTR_PREFIX).equals(prefix)) {
                    DOMUtils.removeNode(e);
                }
                ++i;
            }
        }
    }

    public boolean isChildOfTree() {
        Node parent = this.optionElement.getParentNode();
        return this.toolChunk.getToolNode().isSameNode(parent);
    }

    public boolean addToTree() {
        boolean res = false;
        Node parent = this.optionElement.getParentNode();
        if (parent == null) {
            if (!this.optionElement.getOwnerDocument().equals(this.toolChunk.getToolNode().getOwnerDocument())) {
                this.optionElement = (Element)this.toolChunk.getToolNode().getOwnerDocument().adoptNode(this.optionElement);
            }
            if (!this.toolChunk.envprops.containsValue(this)) {
                res = DOMUtils.appendNode(this.toolChunk.getToolNode(), this.optionElement);
            }
        }
        return res;
    }

    public boolean removeFromTree() {
        return DOMUtils.removeNode(this.optionElement);
    }

    public Element getElement() {
        return this.optionElement;
    }

    public String toString() {
        return "EnvProp: prefixes=" + this.getPrefixes();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result *= 31;
        result = 31 * result + (this.getElement() == null ? 0 : this.getElement().hashCode());
        result = 31 * result + (this.getPrefixes() == null ? 0 : this.getPrefixes().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolEnvProp)) {
            return false;
        }
        ToolEnvProp other = (ToolEnvProp)obj;
        return this.optionElement.equals(other.optionElement);
    }
}

