/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.OptionValidator;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolArgFile;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolEnv;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolEnvProp;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolOption;
import com.aicas.jamaica.eclipse.ant_editor.model.UnknownOptionException;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolChunk
extends InteractiveTargetChunk
implements IModelPartChangedListener {
    private TaskdefTag taskdef;
    Map<String, ToolOption> options;
    Map<String, ToolEnv> envs;
    Map<String, ToolEnvProp> envprops;
    Map<String, ToolArgFile> argfiles;
    private static List<String> nonOptionList = Arrays.asList("env", "envpropertyset");
    private Element toolTag;
    private Element echoTag;
    private IPath pathOfMainClass = Path.EMPTY;
    private Map<String, OptionValidator> optionValidators;

    public ToolChunk(Node targetNode, Element toolTag, ToolChunkManager manager) throws ModelException {
        super(targetNode, manager);
        this.toolTag = toolTag;
        this.options = new LinkedHashMap<String, ToolOption>();
        this.envs = new LinkedHashMap<String, ToolEnv>();
        this.envprops = new LinkedHashMap<String, ToolEnvProp>();
        this.argfiles = new LinkedHashMap<String, ToolArgFile>();
        this.optionValidators = new HashMap<String, OptionValidator>();
        this.getManager().addListener(this);
        this.taskdef = (TaskdefTag)this.getManager().getProjectFile().getTaskdefManager().getTag(toolTag.getTagName());
        this.options.clear();
        this.envs.clear();
        this.envprops.clear();
        if (this.taskdef == null) {
            throw new ModelException(Messages.ToolChunk_No_Ant_task_specified);
        }
        this.setListenerNotificationState(false);
        NodeList childNodes = toolTag.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 1) {
                Element childTag = (Element)childNode;
                String childTagName = childTag.getTagName();
                if (childTagName.toLowerCase().equals("option")) {
                    this.setOption(childTag);
                } else if (childTagName.toLowerCase().equals("env")) {
                    this.setEnv(childTag);
                } else if (childTagName.toLowerCase().equals("envpropertyset")) {
                    this.setEnvPropSet(childTag);
                } else if (childTagName.toLowerCase().equals("argumentfile")) {
                    this.setArgumentFile(childTag);
                } else if (!nonOptionList.contains(childTagName)) {
                    this.setOption(childTag);
                }
            }
            ++i;
        }
        Node sib = toolTag;
        while ((sib = sib.getNextSibling()) != null) {
            if (sib.getNodeType() != 1 || !sib.getNodeName().equals("echo")) continue;
            this.echoTag = (Element)sib;
            break;
        }
        this.setPathOfMainClass();
        this.setListenerNotificationState(true);
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, this.getName()));
    }

    private void setPathOfMainClass() {
        PossiblyEscapedString mainClass = this.getOptionValueResolved("main");
        if (mainClass != null && mainClass.getString().length() > 0) {
            String mainSourceFile = mainClass.getString().replace('.', '/').concat(".java");
            Path mainSourcePath = new Path(mainSourceFile);
            IJavaProject javaProject = this.getManager().getProjectFile().getProject();
            if (javaProject != null) {
                try {
                    IJavaElement mainClassJavaElement = javaProject.findElement((IPath)mainSourcePath);
                    if (mainClassJavaElement != null) {
                        this.pathOfMainClass = mainClassJavaElement.getPath();
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }

    public IPath getPathOfMainClass() {
        return this.pathOfMainClass;
    }

    public void setArgumentFile(String file) {
        if (file == null || file.isEmpty()) {
            return;
        }
        Element newArgFileEle = this.getManager().getProjectFile().getDocument().createElement("argumentfile");
        newArgFileEle.setAttribute("file", file);
        this.setArgumentFile(newArgFileEle);
    }

    protected void setArgumentFile(Element argFileEle) {
        boolean fileIsNew;
        ToolArgFile argFile = new ToolArgFile(this, argFileEle);
        String file = argFile.getFile();
        ToolArgFile oldArgFile = this.argfiles.get(file);
        boolean bl = fileIsNew = oldArgFile == null;
        if (fileIsNew) {
            argFile.addToTree();
            this.argfiles.put(file, argFile);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ARGFILE, file));
        }
    }

    protected void setEnv(Element newEnvEle) {
        ToolEnv newEnv = new ToolEnv(this, newEnvEle);
        String key = newEnv.getKey();
        ToolEnv oldEnv = this.envs.get(key);
        boolean envIsNew = oldEnv == null;
        boolean envHasChanged = false;
        boolean bl = envHasChanged = !envIsNew && !oldEnv.equals(newEnv);
        if (envIsNew || envHasChanged) {
            newEnv.addToTree();
            this.envs.put(key, newEnv);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, envIsNew ? ModelPartChangedEvent.ActionType.ADDED : ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENV, key));
        }
    }

    public void setEnv(String key, String value) {
        if (key == null || key.isEmpty()) {
            return;
        }
        if (value == null) {
            value = "";
        }
        Element newEnvEle = this.getManager().getProjectFile().getDocument().createElement("env");
        newEnvEle.setAttribute("key", key);
        newEnvEle.setAttribute("value", value);
        this.setEnv(newEnvEle);
    }

    protected void setEnvPropSet(Element newEnvPropEle) {
        ToolEnvProp newEnvProp = new ToolEnvProp(this, newEnvPropEle);
        HashSet<ToolEnvProp> envPropList = new HashSet<ToolEnvProp>(this.envprops.values());
        for (ToolEnvProp tep : envPropList) {
            if (!tep.equals(newEnvProp)) continue;
            return;
        }
        newEnvProp.addToTree();
        String header = "<envprop" + (envPropList.size() + 1) + ">";
        this.envprops.put(header, newEnvProp);
        List<String> prefixes = newEnvProp.getPrefixes();
        for (String prefix : prefixes) {
            this.envprops.put(prefix, newEnvProp);
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENVPROP, header));
    }

    public void setEnvPropPrefix(String prefix) {
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        if (this.envprops.containsKey(prefix)) {
            return;
        }
        if (this.envprops.isEmpty()) {
            Element newEnvPropEle = this.getManager().getProjectFile().getDocument().createElement("envpropertyset");
            ToolEnvProp newEnvProp = new ToolEnvProp(this, newEnvPropEle);
            newEnvProp.addToTree();
            newEnvProp.addPrefix(prefix);
            this.envprops.put("<envprop1>", newEnvProp);
            this.envprops.put(prefix, newEnvProp);
        } else {
            ToolEnvProp envProp = this.envprops.get("<envprop1>");
            envProp.addPrefix(prefix);
            this.envprops.put(prefix, envProp);
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENVPROP, prefix));
    }

    public void setOption(String name, PossiblyEscapedString newValue) {
        if (this.options.containsKey(name)) {
            this.setOption(name, newValue, this.options.get(name).getState());
        } else {
            this.setOption(name, newValue, true);
        }
    }

    public void setOption(String name, PossiblyEscapedString newValue, boolean newState) {
        if (this.options.containsKey(name)) {
            this.setOption(name, newValue, newState, this.options.get(name).hasAppendSyntax());
        } else if (this.getToolOptions().isAppendable(name) && !ToolType.PROFILE_ANALYZER.equals((Object)this.getToolType())) {
            this.setOption(name, newValue, newState, true);
        } else {
            this.setOption(name, newValue, newState, false);
        }
    }

    public void setOption(String name, PossiblyEscapedString newValue, boolean newState, boolean append) {
        Element newOptEle;
        OptionValidator optValid;
        if (newValue == null) {
            newValue = PossiblyEscapedString.plain((String)"");
        }
        if (!this.optionValidators.containsKey(name) && (optValid = OptionValidator.getValidator(name, this)) != null) {
            try {
                this.addOptionValidator(name, optValid);
            }
            catch (UnknownOptionException e) {
                AntEditorPlugin.log(e);
            }
        }
        int jamMajVer = -1;
        int jamMinVer = -1;
        if (this.getTaskdef().isBound()) {
            jamMajVer = this.getTaskdef().getDistribution().getVersionMajor();
            jamMinVer = this.getTaskdef().getDistribution().getVersionMinor();
        }
        if (jamMajVer > 6 || jamMajVer == 6 && jamMinVer >= 4) {
            newOptEle = this.getManager().getProjectFile().getDocument().createElement("option");
            newOptEle.setAttribute("name", name);
        } else {
            if (nonOptionList.contains(name)) {
                return;
            }
            newOptEle = this.getManager().getProjectFile().getDocument().createElement(name);
        }
        newOptEle.setAttribute("value", newValue.getString());
        newOptEle.setAttribute("enabled", Boolean.toString(newState));
        if (jamMajVer >= 6) {
            newOptEle.setAttribute("append", Boolean.toString(append));
        }
        if (jamMajVer > 8 || jamMajVer == 8 && jamMinVer >= 5) {
            newOptEle.setAttribute("escape", Boolean.toString(newValue.isEscaped()));
        }
        this.setOption(newOptEle);
    }

    protected void setOption(Element option) {
        boolean optionHasChanged;
        ToolOption newOption = new ToolOption(this, option);
        String name = newOption.getName();
        String newValue = newOption.getValue();
        String oldExePath = this.calcExecutablePath();
        ToolOption oldOption = this.options.get(name);
        if (oldOption != null) {
            oldOption.clearProblems();
        }
        boolean optionIsNew = oldOption == null && !newOption.isChildOfTree();
        boolean optionInit = oldOption == null && newOption.isChildOfTree();
        boolean bl = optionHasChanged = !optionIsNew && !optionInit && !newOption.equals(oldOption);
        if (optionInit || optionIsNew || optionHasChanged) {
            newOption.addToTree();
            this.options.put(name, newOption);
        }
        this.validateOption(name);
        if (optionIsNew || optionHasChanged) {
            this.getManager().getProjectFile().getPropertiesManager().findAndSetNewProperties(newValue);
            String newExePath = this.calcExecutablePath();
            if (newExePath == null || !newExePath.equals(oldExePath) || name.equals("target")) {
                this.updateEchoMessage();
            }
            if (name.equals("main")) {
                this.setPathOfMainClass();
            }
            if (name.equals("target") || name.equals("classpath")) {
                this.revalidate();
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, optionIsNew ? ModelPartChangedEvent.ActionType.ADDED : ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        } else {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        }
    }

    private boolean validateOption(String optionName) {
        ProblemManager probMan = this.getManager().getProjectFile().getProblemManager();
        IToolOptions toolOptions = this.taskdef.getToolOptions();
        ToolOption option = this.options.get(optionName);
        if (option == null) {
            return false;
        }
        option.clearProblems();
        if (option.getState()) {
            if (toolOptions == null) {
                ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/', MessageFormat.format(Messages.ToolChunk_Cannot_validate_options_for_Ant_task___1___, this.taskdef.getName()), 1);
                option.setProblem(newProblem);
            } else if (!toolOptions.getAvailableOptions().contains(optionName)) {
                ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/' + optionName, MessageFormat.format(Messages.ToolChunk_Option___1___is_unknown_for___2___in___3__, optionName, this.taskdef.getToolType().toolname(), this.taskdef.getDistribution()), 1);
                option.setProblem(newProblem);
            } else {
                String valErr2;
                String optionValueResolved;
                String optionValueRaw = option.getValue();
                try {
                    optionValueResolved = this.getManager().getProjectFile().getPropertiesManager().resolveStringWithProperties(optionValueRaw);
                }
                catch (ModelException me) {
                    optionValueResolved = optionValueRaw;
                }
                PossiblyEscapedString optVal_EscResolved = new PossiblyEscapedString(optionValueResolved, option.getEscape());
                ArrayList<String> validationErrors = new ArrayList<String>();
                List<String> seArgs = toolOptions.getOptionEditorArgs(optionName);
                if (seArgs == null) {
                    seArgs = Arrays.asList(new String[0]);
                }
                if (toolOptions.isAppendable(optionName) && seArgs.contains("file")) {
                    String basedir = this.getManager().getProjectFile().getBasedirPath();
                    List seps = toolOptions.getTupleSeparators(optionName);
                    StringBuilder newString = new StringBuilder();
                    List tokens = toolOptions.split(optVal_EscResolved, seps);
                    for (PossiblyEscapedString token : tokens) {
                        String token_unEsc = toolOptions.unescape(token);
                        if (token_unEsc == null || token_unEsc.isEmpty()) continue;
                        if (newString.length() > 0) {
                            newString.append((String)seps.get(0));
                        }
                        if (!new File(token_unEsc).isAbsolute()) {
                            token_unEsc = String.valueOf(basedir) + File.separator + token_unEsc;
                        }
                        newString.append(toolOptions.escape(token_unEsc, seps).getString());
                    }
                    validationErrors.addAll(toolOptions.validate(optionName, new PossiblyEscapedString(newString.toString(), option.getEscape())));
                } else {
                    validationErrors.addAll(toolOptions.validate(optionName, optVal_EscResolved));
                }
                if (validationErrors.isEmpty() && this.optionValidators.containsKey(optionName) && (valErr2 = this.optionValidators.get(optionName).validate(optVal_EscResolved)) != null) {
                    validationErrors.add(valErr2);
                }
                if (!validationErrors.isEmpty()) {
                    for (String valErr2 : validationErrors) {
                        ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/' + optionName, valErr2, 1);
                        option.setProblem(newProblem);
                    }
                }
            }
        }
        return option.isValid();
    }

    public boolean hasAppendSyntax(String name) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        return this.options.get(name).hasAppendSyntax();
    }

    public void setAppendSyntax(String name, boolean appendSyntax) {
        if (this.options.containsKey(name)) {
            boolean hadAppendSyntax = this.options.get(name).hasAppendSyntax();
            this.options.get(name).setAppendSyntax(appendSyntax);
            if (hadAppendSyntax != appendSyntax) {
                this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
            }
        }
    }

    public boolean removeArgumentFile(String file) {
        if (!this.argfiles.containsKey(file)) {
            return false;
        }
        ToolArgFile argfile = this.argfiles.remove(file);
        if (argfile.isChildOfTree()) {
            argfile.removeFromTree();
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ARGFILE, file));
        return true;
    }

    public boolean removeEnv(String key) {
        if (!this.envs.containsKey(key)) {
            return false;
        }
        ToolEnv env = this.envs.remove(key);
        if (env.isChildOfTree()) {
            env.removeFromTree();
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENV, key));
        return true;
    }

    public boolean removeEnvProp(String prefix) {
        ToolEnvProp envProp;
        boolean retval = false;
        if (this.envprops.containsKey(prefix) && (envProp = this.envprops.remove(prefix)) != null) {
            envProp.removePrefix(prefix);
            if (envProp.getPrefixes().isEmpty()) {
                envProp.removeFromTree();
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_ENVPROP, prefix));
            retval = true;
        }
        return retval;
    }

    public boolean removeOption(String name) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        String oldExePath = this.calcExecutablePath();
        ToolOption option = this.options.remove(name);
        if (option.isChildOfTree()) {
            option.removeFromTree();
        }
        for (ProblemManager.Problem prob : option.getProblems()) {
            this.getManager().getProjectFile().getProblemManager().problemSolved(prob);
        }
        String newExePath = this.calcExecutablePath();
        if (newExePath == null || !newExePath.equals(oldExePath) || name.equals("target")) {
            this.updateEchoMessage();
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        return true;
    }

    public PossiblyEscapedString getOptionValueResolved(String optname) {
        PossiblyEscapedString retval = this.getOptionValue(optname);
        if (retval != null) {
            try {
                String resolvedVal = this.getManager().getProjectFile().getPropertiesManager().resolveStringWithProperties(retval.getString());
                retval = new PossiblyEscapedString(resolvedVal, retval.isEscaped());
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        return retval;
    }

    public PossiblyEscapedString getOptionValue(String optname) {
        PossiblyEscapedString retval = null;
        if (this.options.containsKey(optname)) {
            ToolOption to = this.options.get(optname);
            retval = new PossiblyEscapedString(to.getValue(), to.getEscape());
        }
        return retval;
    }

    public boolean getOptionEscape(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getEscape();
        }
        return false;
    }

    public String getEnvValue(String name) {
        if (this.envs.containsKey(name)) {
            return this.envs.get(name).getValue();
        }
        return null;
    }

    public PossiblyEscapedString getTargetValue() {
        PossiblyEscapedString target = null;
        target = this.getOptionValueResolved("target");
        if (this.isBound() && (target == null || !this.getOptionState("target"))) {
            target = new PossiblyEscapedString(this.getDistribution().getHostTarget(), this.getOptionEscape("target"));
        }
        return target;
    }

    public boolean getOptionState(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getState();
        }
        return false;
    }

    public boolean isValidOption(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).isValid();
        }
        return false;
    }

    public List<String> getOptionLastErrors(String optname) {
        ArrayList<String> retval = null;
        if (this.options.containsKey(optname)) {
            retval = new ArrayList<String>();
            List<ProblemManager.Problem> probs = this.options.get(optname).getProblems();
            for (ProblemManager.Problem p : probs) {
                retval.add(p.getMessage());
            }
        }
        return retval;
    }

    private void addOptionValidator(String name, OptionValidator oval) throws UnknownOptionException {
        if (!this.taskdef.getToolOptions().getAvailableOptions().contains(name)) {
            throw new UnknownOptionException(MessageFormat.format(Messages.ToolChunk_Option___1___is_not_configured, name));
        }
        this.optionValidators.put(name, oval);
    }

    public List<String> getConfiguredOptions() {
        return new ArrayList<String>(this.options.keySet());
    }

    public List<String> getConfiguredArgumentFiles() {
        return new ArrayList<String>(this.argfiles.keySet());
    }

    public List<String> getConfiguredEnvs() {
        return new ArrayList<String>(this.envs.keySet());
    }

    public List<String> getConfiguredEnvProps() {
        ArrayList<String> retval = new ArrayList<String>();
        for (String item : this.envprops.keySet()) {
            if (item.startsWith("<envprop") || item.endsWith(">")) continue;
            retval.add(item);
        }
        return retval;
    }

    void setTaskdef(TaskdefTag taskdef) {
        this.taskdef = taskdef;
    }

    TaskdefTag getTaskdef() {
        return this.taskdef;
    }

    public String getTaskdefName() {
        return this.taskdef.getName();
    }

    public void setTaskdefName(String name) throws ModelException {
        TaskdefTag newTaskdef = (TaskdefTag)this.getManager().getProjectFile().getTaskdefManager().getTag(name);
        if (newTaskdef == null) {
            throw new ModelException(String.valueOf(Messages.ToolChunk_Unknown_Ant_task___) + name);
        }
        this.taskdef = newTaskdef;
        Document projectDoc = this.getManager().getProjectFile().getDocument();
        if (!projectDoc.equals(this.toolTag.getOwnerDocument())) {
            this.toolTag = (Element)projectDoc.adoptNode(this.toolTag);
        }
        projectDoc.renameNode(this.toolTag, null, name);
        this.updateEchoMessage();
        this.revalidate();
    }

    void revalidate() {
        boolean changed = false;
        if (!this.getJamaicaAttr().isEmpty()) {
            String curJamAttrValue = this.getJamaicaAttr();
            String taskdefJamDir = "";
            JamaicaVMDistribution dist = this.getTaskdef().getDistribution();
            if (this.getTaskdef().isBound()) {
                taskdefJamDir = dist.getInstallDirectory();
            }
            if (!(taskdefJamDir.isEmpty() || curJamAttrValue.equals(taskdefJamDir) || curJamAttrValue.equals("${jamaica}"))) {
                this.setJamaicaAttr(taskdefJamDir);
                changed = true;
            }
        }
        for (Map.Entry<String, ToolOption> entry : this.options.entrySet()) {
            ToolOption option = entry.getValue();
            this.setOption(option.getName(), new PossiblyEscapedString(option.getValue(), option.getEscape()));
        }
        if (changed) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, this.getName()));
        }
    }

    public IToolOptions getToolOptions() {
        return this.taskdef.getToolOptions();
    }

    public Node getToolNode() {
        return this.toolTag;
    }

    public ToolType getToolType() {
        return this.taskdef.getToolType();
    }

    public boolean isBound() {
        return this.taskdef.isBound();
    }

    public boolean buildsForHost() {
        boolean result = false;
        if (this.isBound()) {
            String curTarget = this.getToolOptions().unescape(this.getTargetValue());
            result = this.getDistribution().getHostTarget().equals(curTarget);
        }
        return result;
    }

    public JamaicaVMDistribution getDistribution() {
        return this.taskdef.getDistribution();
    }

    public String calcExecutableName() {
        String retval = null;
        if (ToolType.isJamaica((ToolType)this.getToolType())) {
            PossiblyEscapedString destination = this.getOptionValueResolved("destination");
            String destVal_unEsc = this.getToolOptions().unescape(destination);
            if (this.getOptionState("destination") && destVal_unEsc != null && destVal_unEsc.length() > 0) {
                String exeExt = AntEditorPlugin.getExeExtension();
                if (!destVal_unEsc.endsWith(exeExt)) {
                    destVal_unEsc = String.valueOf(destVal_unEsc) + exeExt;
                }
                retval = destVal_unEsc;
            } else {
                PossiblyEscapedString main = this.getOptionValueResolved("main");
                String mainVal_unEsc = this.getToolOptions().unescape(main);
                if (this.getOptionState("main") && mainVal_unEsc != null && mainVal_unEsc.length() > 0) {
                    if (this.isBound() && (this.getDistribution().getVersionMajor() == 6 && this.getDistribution().getVersionMinor() >= 3 || this.getDistribution().getVersionMajor() > 6)) {
                        mainVal_unEsc = AntEditorPlugin.getSimpleClassName(mainVal_unEsc);
                    }
                    retval = String.valueOf(mainVal_unEsc) + AntEditorPlugin.getExeExtension();
                }
            }
        } else if (ToolType.JARACCELERATOR.equals((Object)this.getToolType())) {
            PossiblyEscapedString dest = this.getOptionValueResolved("destination");
            String dest_unEsc = this.getToolOptions().unescape(dest);
            if (this.getOptionState("destination") && dest_unEsc != null && dest_unEsc.length() > 0) {
                retval = dest_unEsc;
            } else {
                PossiblyEscapedString source = this.getOptionValueResolved("source");
                String source_unEsc = this.getToolOptions().unescape(source);
                if (this.getOptionState("source") && source_unEsc != null && source_unEsc.length() > 0) {
                    String jarName = source_unEsc.substring(0, source_unEsc.length() - 4);
                    jarName = String.valueOf(jarName) + "-accelerated.jar";
                    String projectBasedir = this.getManager().getProjectFile().getBasedirPath();
                    if (projectBasedir != null && projectBasedir.length() > 0) {
                        if (!(projectBasedir = new Path(projectBasedir).toOSString()).endsWith(File.separator)) {
                            projectBasedir = String.valueOf(projectBasedir) + File.separator;
                        }
                        jarName = jarName.replace(projectBasedir, "");
                    }
                    retval = jarName;
                }
            }
        } else if (ToolType.PROFILE_ANALYZER.equals((Object)this.getToolType())) {
            PossiblyEscapedString opt = this.getOptionValueResolved("optionsFile");
            String opt_unEsc = this.getToolOptions().unescape(opt);
            if (this.getOptionState("optionsFile") && opt_unEsc != null && opt_unEsc.length() > 0) {
                retval = opt_unEsc;
            } else {
                PossiblyEscapedString defopt = this.getToolOptions().getDefaultValue("optionsFile", null);
                String defopt_unEsc = this.getToolOptions().unescape(defopt);
                retval = defopt_unEsc != null && defopt_unEsc.length() > 0 ? defopt_unEsc : "profiled.opt";
            }
        }
        return retval;
    }

    public String calcExecutablePath() {
        String execPath = null;
        String execName = this.calcExecutableName();
        if (execName != null) {
            File execFile = new File(execName);
            execPath = !execFile.isAbsolute() ? LauncherPlugin.normalize((String)(String.valueOf(this.getManager().getProjectFile().getBasedirPath()) + File.separator + execName)) : LauncherPlugin.normalize((String)execName);
        }
        return execPath;
    }

    public String getJamaicaAttr() {
        return ((Element)this.getToolNode()).getAttribute("jamaica");
    }

    public void setJamaicaAttr(String jamaicaAttr) {
        if (((Element)this.getToolNode()).hasAttribute("jamaica")) {
            this.toolTag.setAttribute("jamaica", jamaicaAttr);
        }
    }

    public String getEchoMessage() {
        String echoMsg = null;
        if (this.echoTag != null) {
            echoMsg = this.echoTag.getTextContent();
        }
        return echoMsg;
    }

    public void setEchoMessage(String echoMsg) {
        if (this.echoTag != null) {
            this.echoTag.setTextContent(echoMsg);
        } else {
            Element newEchoTag = this.getManager().getProjectFile().getDocument().createElement("echo");
            newEchoTag.setTextContent(echoMsg);
            this.getNode().appendChild(newEchoTag);
            this.echoTag = newEchoTag;
        }
    }

    public String createEchoMessage(String execPath, boolean isHost) {
        String newLine = "\n";
        String echoStr = String.valueOf(newLine) + "      ";
        echoStr = String.valueOf(echoStr) + Messages.ToolChunk_The_executable_has_been_created_successfully__;
        if (ToolType.JARACCELERATOR.equals((Object)this.getToolType())) {
            echoStr = echoStr.replace("executable", "accelerated JAR file");
        } else if (ToolType.PROFILE_ANALYZER.equals((Object)this.getToolType())) {
            echoStr = echoStr.replace("executable", "options file");
        }
        echoStr = String.valueOf(echoStr) + newLine + "        ";
        echoStr = String.valueOf(echoStr) + execPath;
        if (ToolType.isJamaica((ToolType)this.getToolType())) {
            echoStr = String.valueOf(echoStr) + newLine + "      ";
            echoStr = isHost ? String.valueOf(echoStr) + Messages.ToolChunk_You_can_launch_it_using_the___Overview___page_in_this_editor__ : String.valueOf(echoStr) + Messages.ToolChunk_Please_transfer_it_to_your_target_device_manually__;
        }
        echoStr = String.valueOf(echoStr) + newLine + "    ";
        return echoStr;
    }

    public void updateEchoMessage() {
        if (this.echoTag != null) {
            String echoStr = this.createEchoMessage(this.calcExecutablePath(), this.buildsForHost());
            this.setEchoMessage(echoStr);
        }
    }

    public void promoteSettingEditorDirty(String optionName) {
        ModelPartChangedEvent mpce = new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION_DIRTY, optionName);
        this.fireModelPartChanged(mpce);
    }

    @Override
    public void modelPartChanged(ModelPartChangedEvent mpce) {
        if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.TASKDEF && mpce.getAction() != ModelPartChangedEvent.ActionType.REMOVED && mpce.getAction() != ModelPartChangedEvent.ActionType.READ_COMPLETE && this.taskdef.getName().equals(mpce.getElementName())) {
            try {
                this.setTaskdefName(mpce.getElementName());
            }
            catch (ModelException e) {
                AntEditorPlugin.log(e);
            }
        } else if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.TASKDEF && mpce.getAction() == ModelPartChangedEvent.ActionType.READ_COMPLETE && this.taskdef.getName().equals(mpce.getElementName())) {
            this.revalidate();
        } else if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.ANT_PROPERTY && (mpce.getAction() == ModelPartChangedEvent.ActionType.ADDED || mpce.getAction() == ModelPartChangedEvent.ActionType.CHANGED)) {
            this.revalidate();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeListener(this);
    }
}

