/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.Tag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelPartManager<T extends Tag>
implements IModelPartChangedListener {
    protected Map<String, T> tags;
    private Set<IModelPartChangedListener> listeners;
    private ProjectFile projectFile;

    public ModelPartManager(ProjectFile parent) {
        this.projectFile = parent;
        this.tags = new LinkedHashMap<String, T>();
        this.listeners = new LinkedHashSet<IModelPartChangedListener>();
        parent.addListener(this);
    }

    public List<String> getNames() {
        return new ArrayList<String>(this.tags.keySet());
    }

    public ProjectFile getProjectFile() {
        return this.projectFile;
    }

    public boolean containsChunk(String name) {
        return name == null ? false : this.tags.containsKey(name);
    }

    public T getTag(String name) {
        return (T)(name == null ? null : (Tag)this.tags.get(name));
    }

    void setTag(String name, T chunk) {
        this.setTag(name, chunk, false);
    }

    void setTag(String name, T chunk, boolean forceAppend) {
        if (name == null) {
            throw new NullPointerException(Messages.ModelPartManager_Unnamed_chunks_cannot_be_managed);
        }
        this.tags.put(name, chunk);
        if (chunk instanceof InteractiveTargetChunk) {
            ((InteractiveTargetChunk)chunk).addListener(this);
        }
        if (!((Tag)chunk).isChildOfTree()) {
            if (forceAppend) {
                this.projectFile.appendTag((Tag)chunk);
            } else {
                this.projectFile.insertTag((Tag)chunk, this);
            }
        }
    }

    boolean removeChunk(String name) {
        if (name == null || !this.tags.containsKey(name)) {
            return false;
        }
        Tag chunk = (Tag)this.tags.get(name);
        if (chunk instanceof InteractiveTargetChunk) {
            ((InteractiveTargetChunk)chunk).removeListener(this);
        }
        this.tags.remove(name);
        this.projectFile.removeTag(chunk);
        chunk.dispose();
        return true;
    }

    void doClear() {
        if (this.tags != null) {
            for (Tag t : this.tags.values()) {
                t.dispose();
            }
        }
        this.tags = new LinkedHashMap<String, T>(this.tags.size());
    }

    @Override
    public void modelPartChanged(ModelPartChangedEvent event) {
        this.fireModelPartChanged(event);
    }

    public void addListener(IModelPartChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IModelPartChangedListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireModelPartChanged(ModelPartChangedEvent event) {
        IModelPartChangedListener[] listenerArray = this.listeners.toArray(new IModelPartChangedListener[0]);
        Object lastHop = event.getLastHop();
        IModelPartChangedListener[] iModelPartChangedListenerArray = listenerArray;
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelPartChangedListener listener = iModelPartChangedListenerArray[n2];
            event.setLastHop(this);
            if (!listener.equals(lastHop)) {
                listener.modelPartChanged(event);
            }
            ++n2;
        }
    }
}

