/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecChunk
extends InteractiveTargetChunk
implements IModelPartChangedListener {
    private Element execNode;
    private Element availableNode;
    private Element antcallNode;
    private String executable;
    private List<Element> args = new ArrayList<Element>();
    private String resolveexecutable;
    private String tempToolChunkName;
    private ToolChunk toolChunkRef;

    public String getExecutable() {
        if (this.toolChunkRef != null && this.toolChunkRef.isBound()) {
            return this.toolChunkRef.calcExecutableName();
        }
        return this.executable;
    }

    public List<String> getArgs() {
        ArrayList<String> res = new ArrayList<String>();
        if (this.args != null) {
            int i = 0;
            while (i < this.args.size()) {
                Element curArg = this.args.get(i);
                if (!curArg.getAttribute("value").isEmpty()) {
                    res.add(curArg.getAttribute("value"));
                } else if (!curArg.getAttribute("line").isEmpty()) {
                    String[] tokens;
                    String[] stringArray = tokens = curArg.getAttribute("line").split(" ");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        if (token != null && !token.isEmpty()) {
                            res.add(token);
                        }
                        ++n2;
                    }
                } else if (!curArg.getAttribute("file").isEmpty()) {
                    String fileAttr = curArg.getAttribute("file");
                    String baseDirPath = this.getManager().getProjectFile().getBasedirPath();
                    Path filePath = new Path(fileAttr);
                    if (!filePath.isAbsolute()) {
                        filePath = new Path(String.valueOf(baseDirPath) + '/' + fileAttr);
                    }
                    res.add(filePath.toOSString());
                }
                ++i;
            }
        }
        return res;
    }

    public String getToolChunkName() {
        return this.toolChunkRef == null ? null : this.toolChunkRef.getName();
    }

    public void setToolChunkName(String newToolChunkName) throws ModelException {
        String oldToolChunkName = this.getToolChunkName();
        ToolChunkManager tcm = this.getManager().getProjectFile().getToolChunkManager();
        if (tcm.containsChunk(newToolChunkName)) {
            if (!ToolType.isJamaica((ToolType)tcm.getTag(newToolChunkName).getToolType())) {
                throw new ModelException(MessageFormat.format(Messages.ExecChunk_Ant_target___1___is_not_a_Jamaica_tool_target, newToolChunkName));
            }
        } else {
            throw new ModelException(MessageFormat.format(Messages.ExecChunk_Ant_target___1___does_not_exist, newToolChunkName));
        }
        this.toolChunkRef = tcm.getTag(newToolChunkName);
        if (oldToolChunkName == null || !oldToolChunkName.equals(newToolChunkName)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, "tool_chunk"));
        }
    }

    public void setExecutable(String executable) {
        boolean changed;
        if (executable == null) {
            executable = "";
        }
        boolean bl = changed = !executable.equals(this.executable);
        if (changed) {
            this.executable = executable;
            if (this.availableNode != null) {
                this.availableNode.setAttribute("file", executable);
            }
            this.execNode.setAttribute("executable", executable);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, "executable"));
        }
    }

    public void setArgs(List<String> newArgs) {
        boolean changed;
        ArrayList<Element> newEleList = new ArrayList<Element>();
        int i = 0;
        while (i < newArgs.size()) {
            String curStrArg = newArgs.get(i);
            Element newEle = this.getManager().getProjectFile().getDocument().createElement("arg");
            newEle.setAttribute("value", ExecChunk.getWritableString(curStrArg));
            newEleList.add(newEle);
            ++i;
        }
        boolean bl = changed = this.args == null || !this.getArgs().equals(newArgs);
        if (changed) {
            while (this.execNode.getFirstChild() != null) {
                this.execNode.removeChild(this.execNode.getFirstChild());
            }
            for (Element e : newEleList) {
                this.execNode.appendChild(e);
            }
            this.args = newEleList;
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, "args"));
        }
    }

    public ExecChunk(Node node, Element execNode, ExecChunkManager manager) throws ModelException {
        super(node, manager);
        ToolChunkManager tcm;
        this.execNode = execNode;
        this.toolChunkRef = null;
        this.executable = execNode.getAttribute("executable");
        if (this.executable == null) {
            this.executable = "";
        }
        this.resolveexecutable = execNode.getAttribute("resolveexecutable");
        NodeList avails = ((Element)node).getElementsByTagName("available");
        this.availableNode = (Element)avails.item(0);
        NodeList antcalls = ((Element)node).getElementsByTagName("antcall");
        this.antcallNode = (Element)antcalls.item(0);
        this.tempToolChunkName = this.antcallNode == null ? null : this.antcallNode.getAttribute("target");
        if (this.tempToolChunkName != null && this.tempToolChunkName.length() > 0 && (tcm = this.getManager().getProjectFile().getToolChunkManager()).containsChunk(this.tempToolChunkName)) {
            if (ToolType.isJamaica((ToolType)tcm.getTag(this.tempToolChunkName).getToolType())) {
                this.toolChunkRef = tcm.getTag(this.tempToolChunkName);
            } else {
                this.tempToolChunkName = null;
            }
        }
        this.getManager().addListener(this);
        NodeList execArgs = execNode.getChildNodes();
        int i = 0;
        while (i < execArgs.getLength()) {
            Element curArg;
            if (execArgs.item(i).getNodeType() == 1 && (curArg = (Element)execArgs.item(i)).getTagName().equals("arg")) {
                if (!(curArg.getAttribute("value").isEmpty() && curArg.getAttribute("line").isEmpty() && curArg.getAttribute("file").isEmpty())) {
                    this.args.add(curArg);
                } else if (!curArg.getAttribute("path").isEmpty() || !curArg.getAttribute("pathref").isEmpty()) {
                    this.getManager().getProjectFile().getProblemManager().reportProblem(String.valueOf(this.getName()) + '/', Messages.ExecChunk___path___and___pathref___arguments_are_not_yet_supported, 1);
                }
            }
            ++i;
        }
        if (this.tempToolChunkName == null || this.toolChunkRef != null) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, this.getName()));
        }
    }

    @Override
    public void modelPartChanged(ModelPartChangedEvent event) {
        ToolChunkManager tcm = this.getManager().getProjectFile().getToolChunkManager();
        if (event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.PROJECT) && event.getAction().equals((Object)ModelPartChangedEvent.ActionType.READ_COMPLETE)) {
            this.setExecutable(this.getExecutable());
        }
        if (this.toolChunkRef == null && event.getAction() == ModelPartChangedEvent.ActionType.READ_COMPLETE && tcm.containsChunk(this.tempToolChunkName) && ToolType.isJamaica((ToolType)tcm.getTag(this.tempToolChunkName).getToolType())) {
            this.toolChunkRef = tcm.getTag(this.tempToolChunkName);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.EXEC_CHUNK, this.getName()));
        } else if (event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION) && (event.getAction().equals((Object)ModelPartChangedEvent.ActionType.ADDED) || event.getAction().equals((Object)ModelPartChangedEvent.ActionType.CHANGED) || event.getAction().equals((Object)ModelPartChangedEvent.ActionType.REMOVED)) && event.getSource().equals(this.toolChunkRef)) {
            if (event.getElementName().equals("main") || event.getElementName().equals("destination")) {
                this.setExecutable(this.getExecutable());
            }
        } else if (event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TOOL_CHUNK) && event.getAction().equals((Object)ModelPartChangedEvent.ActionType.REMOVED) && event.getElementName().equals(this.getToolChunkName())) {
            this.getManager().getProjectFile().getExecChunkManager().removeExecChunk(this.getName());
        } else if (event.getPart().equals((Object)ModelPartChangedEvent.ModelPartType.TOOL_CHUNK) && event.getAction().equals((Object)ModelPartChangedEvent.ActionType.CHANGED) && event.getElementName().equals(this.getToolChunkName())) {
            this.setExecutable(this.getExecutable());
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeListener(this);
    }
}

