/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.OverviewTargetGroup;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.PossiblyEscapedString;
import com.aicas.jamaica.eclipse.core.ToolType;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class OverviewBuildTargetGroup
extends OverviewTargetGroup {
    public OverviewBuildTargetGroup(Composite parent, int style, ToolChunk toolChunk, JamaicaAntEditor jae) {
        super(parent, style, toolChunk, jae);
        this.idLabel.setImage(JamaicaAntEditor.getResourceManager().createImage(JamaicaAntEditor.PluginImage.IMG_OVERVIEW_PAGE_BUILD_TARGET.getImgDesc()));
        this.cloneButton.setText("Clone");
        this.cloneButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                String antTargetName = OverviewBuildTargetGroup.this.antTarget.getName();
                InputDialog id = new InputDialog(OverviewBuildTargetGroup.this.getShell(), Messages.OverviewPage_Clone_target, Messages.OverviewPage_Name_of_cloned_Ant_target, String.valueOf(antTargetName) + "_clone", null);
                if (id.open() == 0) {
                    String newChunkName = id.getValue();
                    try {
                        OverviewBuildTargetGroup.this.projData.getToolChunkManager().cloneToolChunk(antTargetName, newChunkName);
                    }
                    catch (ModelException me) {
                        AntEditorPlugin.log(me);
                        ErrorDialog.openError((Shell)OverviewBuildTargetGroup.this.getShell(), (String)Messages.OverviewPage_Cloning_failed, (String)Messages.OverviewPage_Could_not_clone_Ant_target, (IStatus)new Status(4, "com.aicas.jamaica.eclipse.ant_editor", 1, Messages.OverviewPage___see_details__, (Throwable)me));
                    }
                }
            }
        });
        if (ToolType.PROFILE_ANALYZER.equals((Object)toolChunk.getToolType())) {
            this.appLabel.setText("Option file:");
            this.auxLabel.setText("Log file:");
        } else {
            this.auxLabel.setText("Platform:");
        }
        this.auxButton.setText("Edit");
        this.auxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OverviewBuildTargetGroup.this.editor.setActivePage("com.aicas.jamaica.eclipse.ant_editor.editors.OptionsPage_" + OverviewBuildTargetGroup.this.antTarget.getName());
            }
        });
        ToolChunk tc = (ToolChunk)this.antTarget;
        ToolType tt = tc.getToolType();
        if (ToolType.isJamaica((ToolType)tt)) {
            this.invokeButton.setText("Build");
        } else if (ToolType.JARACCELERATOR.equals((Object)tt)) {
            this.invokeButton.setText("Accelerate");
        } else {
            this.invokeButton.setText("Start");
        }
        this.invokeButton.setToolTipText("Run the " + tt.toolname() + " with the currently set options.");
        this.updateUI();
    }

    public void updateUI() {
        ToolChunk buildTarget = (ToolChunk)this.antTarget;
        IToolOptions toolOpts = buildTarget.getToolOptions();
        this.setText(buildTarget.getName());
        this.appNameText.setText(buildTarget.calcExecutableName() != null ? buildTarget.calcExecutableName() : "<undefined>");
        if (ToolType.PROFILE_ANALYZER.equals((Object)buildTarget.getToolType())) {
            PossiblyEscapedString logOpt;
            String log = "";
            if (buildTarget.getOptionState("analysisResults")) {
                logOpt = buildTarget.getOptionValueResolved("analysisResults");
                log = toolOpts.unescape(logOpt);
            }
            if (log == null || log.length() < 1) {
                logOpt = buildTarget.getToolOptions().getDefaultValue("analysisResults", null);
                log = toolOpts.unescape(logOpt);
            }
            if (log == null || log.length() < 1) {
                log = "analysisResults.log";
            }
            this.auxText.setText(log);
        } else {
            this.auxText.setText(buildTarget.getTargetValue() != null ? buildTarget.getTargetValue().getString() : "<undefined>");
        }
        if (!buildTarget.isBound()) {
            LocalResourceManager resMan = JamaicaAntEditor.getResourceManager();
            this.statusLabel.setBackground(resMan.createColor(new RGB(255, 186, 186)));
            this.statusLabel.setImage(resMan.createImage(JamaicaAntEditor.PluginImage.IMG_OPTION_INVALID.getImgDesc()));
            this.statusLabel.setText("Ant-task not found");
            this.statusLabel.setToolTipText("Check the Problems View of Eclipse to find out what's wrong!");
        } else {
            this.statusLabel.setBackground(null);
            this.statusLabel.setImage(null);
            this.statusLabel.setText("");
            this.statusLabel.setToolTipText("");
        }
    }
}

