/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import java.text.MessageFormat;
import org.eclipse.jdt.internal.debug.ui.launcher.NameValuePairDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class ToolEnvironmentDialog
extends TitleAreaDialog {
    private ToolChunk toolchunk;
    private TableViewer envTableViewer;
    private TableViewer envPropTableViewer;

    public ToolEnvironmentDialog(Shell parentShell, ToolChunk chunk) {
        super(parentShell);
        this.toolchunk = chunk;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ToolEnvironmentDialog_window_title);
        newShell.setSize(700, 500);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.ToolEnvironmentDialog_OK_button, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea2 = new Composite(parent, 0);
        this.setTitle(Messages.ToolEnvironmentDialog_title);
        this.setMessage(MessageFormat.format(Messages.ToolEnvironmentDialog_message, this.toolchunk.getName(), this.toolchunk.getToolType().toolname()));
        dialogArea2.setLayout((Layout)new GridLayout(1, false));
        dialogArea2.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm groupSash = new SashForm(dialogArea2, 65792);
        groupSash.SASH_WIDTH = 10;
        groupSash.setLayoutData((Object)new GridData(4, 4, true, true));
        Group envGroup = new Group((Composite)groupSash, 16);
        envGroup.setLayout((Layout)new GridLayout(2, true));
        envGroup.setText(Messages.ToolEnvironmentDialog_Environment_variables);
        envGroup.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent travEvent) {
                if (travEvent.detail == 128) {
                    travEvent.doit = false;
                    ToolEnvironmentDialog.this.envTableViewer.getTable().setFocus();
                }
            }
        });
        this.envTableViewer = ViewerFactory.getToolEnvViewer((Composite)envGroup, this.toolchunk);
        this.envTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.envTableViewer.getTable().setToolTipText("Define environment variables that will be passed to the " + this.toolchunk.getToolType().toolname() + ".");
        this.envTableViewer.getCellEditors()[1].addListener(new ICellEditorListener(){

            public void applyEditorValue() {
                ToolEnvironmentDialog.this.refreshEnvTable();
            }

            public void cancelEditor() {
            }

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }
        });
        this.refreshEnvTable();
        Button addEnvButton = new Button((Composite)envGroup, 8);
        addEnvButton.setText("&Add");
        addEnvButton.setToolTipText("Add a new environment variable.");
        addEnvButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addEnvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                NameValuePairDialog id = new NameValuePairDialog(ToolEnvironmentDialog.this.getShell(), "Add new environment variable", new String[]{"Name:", "Value:"}, new String[]{"", ""});
                if (id.open() == 0) {
                    String propName = id.getNameValuePair()[0];
                    String propValue = id.getNameValuePair()[1];
                    ToolEnvironmentDialog.this.toolchunk.setEnv(propName, propValue);
                    ToolEnvironmentDialog.this.refreshEnvTable();
                }
            }
        });
        Button removeEnvButton = new Button((Composite)envGroup, 8);
        removeEnvButton.setText("&Remove");
        removeEnvButton.setToolTipText("Remove the selected environment variables.");
        removeEnvButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeEnvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IStructuredSelection iss = (IStructuredSelection)ToolEnvironmentDialog.this.envTableViewer.getSelection();
                for (Object propName : iss.toList()) {
                    ToolEnvironmentDialog.this.toolchunk.removeEnv((String)propName);
                    ToolEnvironmentDialog.this.refreshEnvTable();
                }
            }
        });
        Group envpropGroup = new Group((Composite)groupSash, 0);
        envpropGroup.setLayout((Layout)new GridLayout(2, true));
        envpropGroup.setText(Messages.ToolEnvironmentDialog_Environment_property_set);
        this.envPropTableViewer = ViewerFactory.getToolEnvPropViewer((Composite)envpropGroup, this.toolchunk);
        this.envPropTableViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.envPropTableViewer.getTable().setToolTipText("Define environment property prefixes.\n\nEvery Ant property that begins with one of the defined prefixes will be passed as environment variable to the " + this.toolchunk.getToolType().toolname() + ".");
        this.refreshEnvPropTable();
        Button addEnvPropButton = new Button((Composite)envpropGroup, 8);
        addEnvPropButton.setText("A&dd");
        addEnvPropButton.setToolTipText("Add a new environment property prefix.");
        addEnvPropButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        addEnvPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                InputDialog id = new InputDialog(ToolEnvironmentDialog.this.getShell(), "Add new environment property prefix", "Prefix:", "", null);
                if (id.open() == 0) {
                    ToolEnvironmentDialog.this.toolchunk.setEnvPropPrefix(id.getValue());
                    ToolEnvironmentDialog.this.refreshEnvPropTable();
                }
            }
        });
        Button removeEnvPropButton = new Button((Composite)envpropGroup, 8);
        removeEnvPropButton.setText("Re&move");
        removeEnvPropButton.setToolTipText("Remove the selected environment property prefixes.");
        removeEnvPropButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        removeEnvPropButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                IStructuredSelection iss = (IStructuredSelection)ToolEnvironmentDialog.this.envPropTableViewer.getSelection();
                for (Object propName : iss.toList()) {
                    ToolEnvironmentDialog.this.toolchunk.removeEnvProp((String)propName);
                    ToolEnvironmentDialog.this.refreshEnvPropTable();
                }
            }
        });
        groupSash.setWeights(new int[]{60, 40});
        return dialogArea2;
    }

    private void refreshEnvTable() {
        this.envTableViewer.setInput(this.toolchunk.getConfiguredEnvs());
        TableColumn[] tableColumnArray = this.envTableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    private void refreshEnvPropTable() {
        this.envPropTableViewer.setInput(this.toolchunk.getConfiguredEnvProps());
        TableColumn[] tableColumnArray = this.envPropTableViewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    protected void okPressed() {
        super.okPressed();
    }
}

