/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.core;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ToolType {
    JAMAICA("com.aicas.jamaica.tools.ant.JamaicaTask", "jamaicabuilder", "Jamaica Builder Tool"),
    JAMAICA_INTERNAL("com.aicas.jamaica.tools.ant.InternalJamaicaTask", "jamaicabuilder_jdk", "Jamaica Builder Tool (internal)"),
    JARACCELERATOR("com.aicas.jamaica.tools.ant.JarAcceleratorTask", "jamaicajaraccelerator", "Jamaica JAR Accelerator Tool"),
    JAMAICAH("com.aicas.jamaica.tools.ant.JamaicahTask", "jamaicah", "Jamaica Header Tool"),
    JAMAICAH_INTERNAL("com.aicas.jamaica.tools.ant.InternalJamaicahTask", "jamaicah_jdk", "Jamaica Header Tool (internal)"),
    JAMAICAVM("com.aicas.jamaica.tools.ant.JamaicaVMTask", "jamaicavm", "JamaicaVM"),
    JAMAICAVM_MULTICORE(null, "jamaicavm_multicore", "JamaicaVM Multicore Extension"),
    JAMAICAC("com.aicas.jamaica.tools.ant.JamaicacTask", "jamaicac", "Jamaica Compiler Tool"),
    THREADMONITOR("com.aicas.jamaica.tools.ant.ThreadMonitorTask", "threadmonitor", "ThreadMonitor"),
    DFA("com.aicas.jamaica.tools.ant.VeriFluxTask", "veriflux", "VeriFlux DFA"),
    DFAAIT(null, null, "VeriFlux aiT"),
    JIT(null, null, "JamaicaVM JIT Extension"),
    INVALID(null, null, null);

    private String classname;
    private String tagname;
    private String toolname;

    public static String showTools() {
        return "JAMAICA (associated tool: Jamaica Builder Tool)\nJAMAICAH (associated tool: Jamaica Header Tool)\nJAMAICAC (associated tool: Jamaica Compiler Tool)\nJARACCELERATOR (associated tool: Jamaica JAR Accelerator Tool)\nJAMAICAVM (associated tool: JamaicaVM)\nJAMAICAVM_MULTICORE (associated tool: JamaicaVM Multicore Extension)\nTHREADMONITOR (associated tool: ThreadMonitor)\nJIT (associated tool: JamaicaVM JIT Extension)\nDFA (associated tool: VeriFlux DFA)\nDFAAIT (associated tool: VeriFlux aiT)";
    }

    private ToolType(String classname, String tagname, String toolname) {
        this.classname = classname;
        this.tagname = tagname;
        this.toolname = toolname;
    }

    public String classname() {
        return this.classname;
    }

    public String tagname() {
        return this.tagname(null);
    }

    public String toolname() {
        return this.toolname;
    }

    public static ToolType valueOfTagname(String tagname) {
        if (tagname != null) {
            ToolType[] toolTypeArray = ToolType.values();
            int n = toolTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolType tool = toolTypeArray[n2];
                if (tagname.equals(tool.tagname())) {
                    return tool;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ToolType valueOfClassname(String classname) {
        if (classname != null) {
            ToolType[] toolTypeArray = ToolType.values();
            int n = toolTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolType tool = toolTypeArray[n2];
                if (classname.equals(tool.classname())) {
                    return tool;
                }
                ++n2;
            }
        }
        return null;
    }

    public static ToolType valueOfToolname(String toolname) {
        if (toolname != null) {
            ToolType[] toolTypeArray = ToolType.values();
            int n = toolTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ToolType tool = toolTypeArray[n2];
                if (toolname.equals(tool.toolname())) {
                    return tool;
                }
                ++n2;
            }
        }
        return null;
    }

    public String toString() {
        String retval = null;
        retval = this.classname() != null ? this.classname().substring(this.classname().lastIndexOf(46) + 1) : this.toolname();
        return retval;
    }

    public static boolean isInternalType(ToolType type) {
        return type == JAMAICA_INTERNAL || type == JAMAICAH_INTERNAL;
    }

    public static boolean isJamaica(ToolType type) {
        return type == JAMAICA || type == JAMAICA_INTERNAL;
    }

    public static boolean isJamaicah(ToolType type) {
        return type == JAMAICAH || type == JAMAICAH_INTERNAL;
    }

    public String tagname(AbstractJamaicaDistribution distro) {
        String retval = this.tagname;
        if (distro != null && distro.getType().equals((Object)AbstractJamaicaDistribution.DistroType.VM) && distro.getVersionMajor() < 6) {
            if (this.equals((Object)JAMAICA)) {
                retval = "jamaica";
            }
            if (this.equals((Object)JAMAICA_INTERNAL)) {
                retval = "jamaica_jdk";
            }
        }
        return retval;
    }
}

