/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.core;

import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJamaicaDistribution {
    public static final String ROOT_JAMAICA_CONF = "etc" + File.separator + "jamaica.conf";
    public static final String BUILD_INFO = "doc" + File.separator + "build.info";
    public static final String TARGET_DIRECTORY = "target" + File.separator;
    public static final String DEVELOPER_BUILD_TRIGGER = "jconfigure.status";
    public String name;
    protected DistroType distroType = null;
    protected String jamaicaVersion = null;
    protected int majorVersion = -1;
    protected int minorVersion = -1;
    protected int releaseVersion = -1;
    protected boolean isDeveloperBuild = false;
    protected List<String> availableTargets;
    protected String hostTarget;
    protected String installDirectory;
    protected Map<VMType, String> availableVMs;
    protected Map<ToolType, IToolOptions> availableTools;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T extends AbstractJamaicaDistribution> T findOrSetup(String path, StringBuilder errDesc, Map<String, T> distros, Class<T> clazz) {
        Map<String, T> map = distros;
        synchronized (map) {
            if (!distros.containsKey(path)) {
                AbstractJamaicaDistribution newDist = null;
                try {
                    Constructor<T> cons = clazz.getConstructor(String.class, IProgressMonitor.class);
                    newDist = (AbstractJamaicaDistribution)cons.newInstance(path, new NullProgressMonitor());
                }
                catch (InvocationTargetException ite) {
                    if (errDesc != null) {
                        errDesc.append(ite.getTargetException().getMessage());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (newDist != null) {
                    distros.put(path, newDist);
                }
            }
            return (T)((AbstractJamaicaDistribution)distros.get(path));
        }
    }

    protected String getVersionFromBuildInfo(String jamaicaHome) throws FileNotFoundException, IOException {
        String version = null;
        BufferedReader infoFileReader = new BufferedReader(new FileReader(String.valueOf(jamaicaHome) + File.separator + BUILD_INFO));
        String line = null;
        while ((line = infoFileReader.readLine()) != null) {
            if (!line.contains("Version") || line.indexOf(58) < 0) continue;
            int colonPos = line.indexOf(58);
            version = line.substring(colonPos + 1).trim();
            break;
        }
        infoFileReader.close();
        return version;
    }

    protected String getVersionFromMakefile(String jamaicaHome) throws IOException {
        String versionKeyword = "JAMAICA_VERSION = ";
        String releaseKeyword = "JAMAICA_RELEASE = ";
        String version = null;
        File makefile = new File(String.valueOf(jamaicaHome) + File.separator + "Makefile");
        BufferedReader reader = new BufferedReader(new FileReader(makefile));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (line.startsWith("JAMAICA_VERSION = ")) {
                version = line.substring("JAMAICA_VERSION = ".length()).trim();
                continue;
            }
            if (!line.startsWith("JAMAICA_RELEASE = ")) continue;
            version = String.valueOf(version) + '-' + line.substring("JAMAICA_RELEASE = ".length()).trim();
            break;
        }
        reader.close();
        return version;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getVersionFromBinary(VMType vmtype, String versionOption) {
        StringBuilder result;
        block9: {
            Scanner scanner;
            block10: {
                String vmPath;
                result = null;
                scanner = null;
                try {
                    vmPath = this.getVM(vmtype);
                    if (vmPath == null) {
                        if (scanner == null) return null;
                        scanner.close();
                        return null;
                    }
                }
                catch (IOException iOException) {
                    if (scanner != null) {
                        scanner.close();
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    if (scanner == null) throw throwable;
                    scanner.close();
                    throw throwable;
                }
                {
                    ProcessBuilder pb = new ProcessBuilder(vmPath, versionOption);
                    pb = pb.redirectErrorStream(true);
                    Process p = pb.start();
                    if (p == null) break block10;
                    InputStream is = p.getInputStream();
                    result = new StringBuilder();
                    scanner = new Scanner(is);
                    while (scanner.hasNextLine()) {
                        result.append(scanner.nextLine());
                    }
                }
            }
            if (scanner != null) {
                scanner.close();
            }
        }
        if (result == null) return null;
        String string = result.toString();
        return string;
    }

    protected abstract void tryToRegisterVM(VMType var1, String var2);

    protected abstract Exception tryToRegisterTool(ToolType var1);

    protected boolean fileExists(String filePath, boolean isDir) {
        if (filePath != null) {
            if (isDir) {
                return new File(filePath).isDirectory();
            }
            return new File(filePath).isFile();
        }
        return false;
    }

    public DistroType getType() {
        return this.distroType;
    }

    public List<String> getAvailableTargets() {
        return this.availableTargets;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getInstallDirectory() {
        return this.installDirectory;
    }

    public String getVersion() {
        return this.jamaicaVersion;
    }

    public int getVersionMajor() {
        return this.majorVersion;
    }

    public int getVersionMinor() {
        return this.minorVersion;
    }

    public int getVersionRelease() {
        return this.releaseVersion;
    }

    protected void parseVersionSegments() {
        if (!"Unknown".equalsIgnoreCase(this.jamaicaVersion)) {
            this.majorVersion = Integer.parseInt(this.jamaicaVersion.substring(0, this.jamaicaVersion.indexOf(46)));
            int verIdx = this.jamaicaVersion.indexOf(46) + 1;
            while (verIdx < this.jamaicaVersion.length() && Character.isDigit(this.jamaicaVersion.charAt(verIdx))) {
                ++verIdx;
            }
            if (!this.jamaicaVersion.substring(this.jamaicaVersion.indexOf(46) + 1, verIdx).isEmpty()) {
                this.minorVersion = Integer.parseInt(this.jamaicaVersion.substring(this.jamaicaVersion.indexOf(46) + 1, verIdx));
            }
            if (verIdx < this.jamaicaVersion.length() && this.jamaicaVersion.charAt(verIdx) == '.') {
                int verIdx2 = verIdx + 1;
                while (verIdx2 < this.jamaicaVersion.length() && Character.isDigit(this.jamaicaVersion.charAt(verIdx2))) {
                    ++verIdx2;
                }
                if (!this.jamaicaVersion.substring(verIdx + 1, verIdx2).isEmpty()) {
                    this.releaseVersion = Integer.parseInt(this.jamaicaVersion.substring(verIdx + 1, verIdx2));
                }
            }
        } else {
            this.releaseVersion = -1;
            this.minorVersion = -1;
            this.majorVersion = -1;
        }
        if (this.getVersionMajor() == -1 || this.getVersionMinor() == -1) {
            throw new IllegalArgumentException("Not a valid Jamaica distribution: Unable to determine VM version");
        }
    }

    public boolean isDeveloperBuild() {
        return this.isDeveloperBuild;
    }

    public String getHostTarget() {
        return this.hostTarget;
    }

    public String getVM(VMType type) {
        return this.availableVMs.get((Object)type);
    }

    public abstract String getTargetBinDirectory(String var1);

    public abstract String getClassesDirectory(String var1);

    public abstract String getBuildInfoFile();

    public abstract boolean isWorkingBuild();

    public abstract String getClassesJar(String var1);

    public IToolOptions getToolOptions(ToolType tool) {
        return this.availableTools.get((Object)tool);
    }

    public List<ToolType> getAvailableTools() {
        return new ArrayList<ToolType>(this.availableTools.keySet());
    }

    public String toString() {
        return String.valueOf(MessageFormat.format("{0} {1}", this.name, this.jamaicaVersion)) + (this.isDeveloperBuild ? " DEV" : "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistroType {
        VM,
        CAR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VMType {
        VM_DEFAULT("Precompiled", "jamaicavm_bin", "Heavily-used classes are compiled, multicore if supported by the Jamaica configuration"),
        VM_SLIM("Interpreted", "jamaicavm(32|_slim)_bin", "Without compiled classes"),
        VM_SLIM_MC("Interpreted Multicore", "jamaicavmm(32|_slim)_bin", "Without compiled classes, supports multicore"),
        VM_PROFILING("Profiling", "jamaicavmp(32|_slim)_bin", "For creating Jamaica profiles"),
        VM_PROFILING_MC("Profiling Multicore", "jamaicavmpm(32|_slim)_bin", "For creating Jamaica profiles, supports multicore"),
        VM_DEBUG_INTERFACE("Debug Interface", "jamaicavmdi(32|_slim)_bin", "Contains the JVMTI interface for remote debugging"),
        VM_DEBUG_INTERFACE_MC("Debug Interface Multicore", "jamaicavmdim(32|_slim)_bin", "Contains the JVMTI interface for remote debugging, supports multicore"),
        VM_DEBUG("Debugging", "jamaicavmdb(32|_slim)_bin", "For debugging Jamaica itself"),
        VM_DEBUG_MC("Debugging Multicore", "jamaicavmdbm(32|_slim)_bin", "For debugging Jamaica itself, supports multicore"),
        XLET_EMU_DEFAULT("Interpreted", "emulator_bin", "Without compiled classes"),
        XLET_EMU_DEBUG("Debugging", "emulator_debug_bin", "Contains the JVMTI interface for remote debugging"),
        XLET_EMU_DEBUG_PROFILED("Debugging Profiled", "emulator_debug_profiled_bin", "Heavily-used classes are compiled, contains the JVMTI interface for remote debugging"),
        ALTERNATE("Alternate", "", "Use this for arbitrary VM executables");

        private final String desc;
        private final String regex;
        private final String tooltip;
        private static final String EXE_EXT;

        static {
            EXE_EXT = Platform.getOS().equals("win32") ? ".exe" : "";
        }

        private VMType(String desc, String regex, String tooltip) {
            this.desc = desc;
            this.regex = regex;
            this.tooltip = tooltip;
        }

        public String getDescription() {
            return this.desc;
        }

        public Pattern getPattern() {
            return Pattern.compile(String.valueOf(this.regex) + Pattern.quote(EXE_EXT));
        }

        public String getTooltipText() {
            return this.tooltip;
        }
    }
}

