/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.actions;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.actions.ActionsMessages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.progress.UIJob;

public class AddJamaicaClassesDelegate
extends ActionDelegate {
    private static final String labelFormat = Platform.getOS().equals("macosx") ? "{0} [{1}]" : "{0}\t[{1}]";
    private IAction theAction;
    private IJavaProject selectedJavaProject;
    private DistributionMenuCreator dmc;

    public void init(IAction action) {
        this.theAction = action;
        this.dmc = new DistributionMenuCreator();
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this.dmc);
        this.theAction.setMenuCreator((IMenuCreator)this.dmc);
    }

    public void dispose() {
        JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this.dmc);
        this.dmc.dispose();
        super.dispose();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object first;
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IJavaProject) {
            this.selectedJavaProject = (IJavaProject)first;
            return;
        }
        this.selectedJavaProject = null;
    }

    private class AddJamaicaClassesAction
    extends Action {
        private AbstractJamaicaDistribution dist;

        public AddJamaicaClassesAction(AbstractJamaicaDistribution dist) {
            this.dist = dist;
            this.setText(MessageFormat.format(labelFormat, dist.toString(), dist.getInstallDirectory()));
        }

        public void run() {
            if (AddJamaicaClassesDelegate.this.selectedJavaProject != null) {
                try {
                    IClasspathEntry[] oldClasspath = AddJamaicaClassesDelegate.this.selectedJavaProject.getRawClasspath();
                    IFolder linkFolder = AddJamaicaClassesDelegate.this.selectedJavaProject.getProject().getFolder("/jamaica_link_" + Integer.toHexString(this.dist.getClassesDirectory(this.dist.getHostTarget()).hashCode()));
                    linkFolder.createLink((IPath)new Path(this.dist.getClassesDirectory(this.dist.getHostTarget())), 128, (IProgressMonitor)new NullProgressMonitor());
                    IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + 1];
                    IClasspathEntry jamaicaClasses = JavaCore.newLibraryEntry((IPath)linkFolder.getLocation(), null, null);
                    int insertIdx = newClasspath.length - 1;
                    int i = 0;
                    while (i < oldClasspath.length) {
                        if (oldClasspath[i].getEntryKind() == 5) {
                            insertIdx = i;
                            break;
                        }
                        ++i;
                    }
                    int oldIdx = 0;
                    int newIdx = 0;
                    while (newIdx < newClasspath.length) {
                        if (newIdx == insertIdx) {
                            newClasspath[newIdx++] = jamaicaClasses;
                            continue;
                        }
                        newClasspath[newIdx++] = oldClasspath[oldIdx++];
                    }
                    AddJamaicaClassesDelegate.this.selectedJavaProject.setRawClasspath(newClasspath, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (JavaModelException e) {
                    LauncherPlugin.log(e);
                }
                catch (CoreException ce) {
                    LauncherPlugin.log(ce);
                }
            }
        }
    }

    private class DistributionMenuCreator
    implements IMenuCreator,
    IVMInstallChangedListener {
        private Menu theMenu;
        private List<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        private MenuItem emptyItem;

        private DistributionMenuCreator() {
        }

        public void dispose() {
            if (this.theMenu != null) {
                this.cleanMenu();
                this.theMenu.dispose();
                this.theMenu = null;
            }
        }

        private void setupMenu(Menu menu) {
            boolean empty = true;
            for (AbstractJamaicaDistribution abstractJamaicaDistribution : JamaicaVMDistribution.distributions.values()) {
                if (!abstractJamaicaDistribution.isDeveloperBuild()) continue;
                ActionContributionItem aci = new ActionContributionItem((IAction)new AddJamaicaClassesAction(abstractJamaicaDistribution));
                aci.fill(menu, -1);
                this.items.add(aci);
                empty = false;
            }
            if (empty) {
                this.emptyItem = new MenuItem(menu, 0);
                this.emptyItem.setText(ActionsMessages.AddJamaicaClassesDelegate_No_suitable_developer_build_found);
                this.emptyItem.setEnabled(false);
            }
        }

        private void cleanMenu() {
            if (this.emptyItem != null) {
                this.emptyItem.dispose();
                this.emptyItem = null;
            }
            for (ActionContributionItem aci : this.items) {
                aci.dispose();
            }
            this.items.clear();
        }

        public Menu getMenu(Control parent) {
            return null;
        }

        public Menu getMenu(Menu parent) {
            this.dispose();
            this.theMenu = new Menu(parent);
            this.setupMenu(this.theMenu);
            return this.theMenu;
        }

        private void distributionsChanged() {
            if (this.theMenu != null) {
                new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        DistributionMenuCreator.this.cleanMenu();
                        DistributionMenuCreator.this.setupMenu(DistributionMenuCreator.this.theMenu);
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        }

        public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        }

        public void vmChanged(PropertyChangeEvent event) {
            this.distributionsChanged();
        }

        public void vmAdded(IVMInstall vm) {
            this.distributionsChanged();
        }

        public void vmRemoved(IVMInstall vm) {
            this.distributionsChanged();
        }
    }
}

