/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertyTag;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesManager
extends ModelPartManager<PropertyTag> {
    protected ArrayList<PropertyTag> envProps = new ArrayList();

    public PropertiesManager(ProjectFile parent) {
        super(parent);
    }

    @Override
    void doClear() {
        this.envProps.clear();
        super.doClear();
    }

    public int getEnvironmentPropertyRank(PropertyTag envProp) {
        int retval = envProp == null ? this.envProps.size() + 1 : (!envProp.isEnvironmentProperty() ? -1 : (this.envProps.contains(envProp) ? this.envProps.indexOf(envProp) + 1 : this.envProps.size() + 1));
        return retval;
    }

    public void setEnvironmentProperty(PropertyTag envProp) {
        if (envProp.isEnvironmentProperty()) {
            this.envProps.add(envProp);
        }
    }

    public String getPropertyValue(String propName) {
        String retVal = null;
        if ("jamaica".equals(propName)) {
            retVal = this.getProjectFile().getProjectJRELocation();
        } else {
            boolean foundEnvProp = false;
            String[] propNameTokens = propName.split("[.]");
            if (propNameTokens.length == 2 && !this.envProps.isEmpty()) {
                int i = 0;
                while (!foundEnvProp && this.envProps.size() > i) {
                    PropertyTag envProp = this.envProps.get(i);
                    if (envProp.getValue().equals(propNameTokens[0])) {
                        retVal = System.getenv(propNameTokens[1]);
                        foundEnvProp = true;
                    }
                    ++i;
                }
            }
            if (!foundEnvProp && retVal == null) {
                retVal = this.containsChunk(propName) ? ((PropertyTag)this.getTag(propName)).getValue() : null;
            }
        }
        return retVal;
    }

    public String getPropertyValueResolved(String name) throws ModelException {
        return this.resolveStringWithProperties(this.getPropertyValue(name));
    }

    public void setPropertyValue(String name, String value) {
        PropertyTag prop;
        if (name == null || name.equals("")) {
            return;
        }
        if (value == null) {
            value = "";
        }
        if (name.matches("<.*>") && !name.matches("<environment\\d*>")) {
            return;
        }
        if (name.matches("<environment>")) {
            name = "<environment" + this.getEnvironmentPropertyRank(null) + ">";
        }
        if ((prop = (PropertyTag)this.getTag(name)) == null) {
            Document doc = this.getProjectFile().getDocument();
            Element ele = doc.createElement("property");
            if (name.matches("<environment\\d*>")) {
                ele.setAttribute("environment", value);
            } else {
                ele.setAttribute("name", name);
                ele.setAttribute("value", value);
            }
            try {
                prop = new PropertyTag(ele, this);
                this.setTag(name, prop);
                this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.ADDED, ModelPartChangedEvent.ModelPartType.ANT_PROPERTY, name));
            }
            catch (ModelException me) {
                AntEditorPlugin.log(me);
            }
        } else {
            boolean changed;
            boolean bl = changed = !prop.getValue().equals(value);
            if (changed) {
                prop.setValue(value);
                this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.ANT_PROPERTY, name));
            }
        }
    }

    @Override
    void setTag(String name, PropertyTag chunk) {
        if (!name.equals("jamaica")) {
            super.setTag(name, chunk);
        }
    }

    public void removeProperty(String name) {
        PropertyTag prop = (PropertyTag)this.getTag(name);
        if (this.removeChunk(name)) {
            if (prop.isEnvironmentProperty()) {
                int delIndex = this.envProps.indexOf(prop);
                this.envProps.remove(prop);
                int i = delIndex;
                while (i < this.envProps.size()) {
                    this.tags.remove("<environment" + (i + 2) + ">");
                    this.tags.put(this.envProps.get(i).getName(), this.envProps.get(i));
                    ++i;
                }
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.ANT_PROPERTY, name));
        }
    }

    public String resolveStringWithProperties(String value) throws ModelException {
        if (value == null) {
            return null;
        }
        StringBuffer resolved = new StringBuffer();
        int start = -1;
        int end = -1;
        start = value.indexOf("${", start + 1);
        while (start > -1) {
            resolved.append(value.substring(end + 1, start));
            end = value.indexOf("}", start);
            if (end > -1) {
                String propName = value.substring(start + 2, end);
                String propValue = this.getPropertyValueResolved(propName);
                if (propValue != null) {
                    resolved.append(propValue);
                } else {
                    resolved.append("${" + propName + "}");
                }
                start = value.indexOf("${", end);
                continue;
            }
            throw new ModelException(Messages.PropertiesManager_Malformed_input___missing_rbrace);
        }
        resolved.append(value.substring(end + 1));
        return resolved.toString();
    }

    public static List<String> extractProperties(String value) {
        String val = value;
        ArrayList<String> props = new ArrayList<String>();
        int idx = -1;
        while ((idx = val.indexOf("${", idx + 1)) > -1) {
            int endIdx = val.indexOf(125, idx + 2);
            if (endIdx <= -1) continue;
            props.add(val.substring(idx + 2, endIdx));
        }
        return props;
    }

    public void findAndSetNewProperties(String value) {
        List<String> propList = PropertiesManager.extractProperties(value);
        if (propList.size() > 0) {
            for (String prop : propList) {
                if (this.getPropertyValue(prop) != null) continue;
                this.setPropertyValue(prop, "");
            }
        }
    }
}

