/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class OptionSelectionDialog
extends TitleAreaDialog {
    private static final int OFFSET_NORMAL = 6;
    private static final int CONTROL_WIDTH = 350;
    private static final int CONTROL_HEIGHT = 375;
    private ToolChunk model;
    private FilteredTree optionsTree;
    private Button showNormalBox;
    private Button showExtendedBox;
    private Button initialDefaultBox;
    private Button initialSpecifyBox;
    private Text descText;
    private Text initialValueText;

    public OptionSelectionDialog(Shell parentShell, ToolChunk chunk) {
        super(parentShell);
        this.model = chunk;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.OptionSelectionDialog_window_title);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.OptionSelectionDialog_Add_selected_options, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea2 = new Composite(parent, 0);
        this.setTitle(Messages.OptionSelectionDialog_title);
        this.setMessage(MessageFormat.format(Messages.OptionSelectionDialog_message, this.model.getName(), this.model.getToolType().toolname()));
        dialogArea2.setLayout((Layout)new GridLayout(1, false));
        dialogArea2.setLayoutData((Object)new GridData(4, 4, true, true));
        Group filterGroup = new Group(dialogArea2, 16);
        filterGroup.setLayout((Layout)new GridLayout(1, false));
        filterGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        filterGroup.setText(Messages.OptionSelectionDialog_Search_options___use____or____as_wildcards__);
        SashForm groupSash = new SashForm((Composite)filterGroup, 65792);
        groupSash.SASH_WIDTH = 15;
        groupSash.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftBlock = new Composite((Composite)groupSash, 0);
        leftBlock.setLayout((Layout)new FormLayout());
        Composite rightBlock = new Composite((Composite)groupSash, 0);
        rightBlock.setLayout((Layout)new FormLayout());
        this.optionsTree = new FilteredTree(leftBlock, 2818, new PatternFilter(){

            public boolean isElementVisible(Viewer viewer, Object element) {
                String desc = OptionSelectionDialog.this.model.getToolOptions().getDescription((String)element, OptionSelectionDialog.this.model.getTargetValue());
                return super.isElementVisible(viewer, element) || this.wordMatches(desc);
            }
        }, true);
        TreeViewer v = this.optionsTree.getViewer();
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final IToolOptions toolOptions;
            {
                this.toolOptions = OptionSelectionDialog.this.model.getToolOptions();
            }

            public String getText(Object element) {
                String elementString = element.toString();
                String argument = this.toolOptions.getArgument(elementString);
                if (argument != null) {
                    return MessageFormat.format("{0} = {1}", elementString, argument);
                }
                return elementString;
            }
        });
        v.setContentProvider((IContentProvider)new OptionTreeContentProvider());
        v.setInput((Object)this.model);
        this.optionsTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                OptionSelectionDialog.this.setErrorMessage(null);
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    OptionSelectionDialog.this.descText.setText("");
                } else {
                    String selectedItem = (String)selection.getFirstElement();
                    String description = OptionSelectionDialog.this.model.getToolOptions().getDescription(selectedItem, OptionSelectionDialog.this.model.getTargetValue());
                    if (description == null && OptionSelectionDialog.this.model.getToolOptions().getAvailableGroups().contains(selectedItem)) {
                        description = Messages.OptionSelectionDialog___no_description_available_for_categories__;
                    }
                    OptionSelectionDialog.this.descText.setText(description == null ? Messages.OptionSelectionDialog___no_description_found__ : description);
                    boolean canSpecifyInitialValue = selection.toArray().length == 1;
                    OptionSelectionDialog.this.initialSpecifyBox.setEnabled(canSpecifyInitialValue);
                    OptionSelectionDialog.this.initialValueText.setEnabled(canSpecifyInitialValue);
                    if (!canSpecifyInitialValue) {
                        OptionSelectionDialog.this.initialDefaultBox.setSelection(true);
                        OptionSelectionDialog.this.initialSpecifyBox.setSelection(false);
                    }
                }
            }
        });
        v.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                OptionSelectionDialog.this.okPressed();
            }
        });
        this.optionsTree.setInitialText(Messages.OptionSelectionDialog_enter_search_phrase);
        Composite filterCheckboxes = new Composite(leftBlock, 0);
        FormData optionsTreeData = new FormData(350, 375);
        optionsTreeData.left = new FormAttachment(0, 6);
        optionsTreeData.top = new FormAttachment(0, 6);
        optionsTreeData.bottom = new FormAttachment((Control)filterCheckboxes, -6);
        optionsTreeData.right = new FormAttachment(100, 0);
        this.optionsTree.setLayoutData((Object)optionsTreeData);
        FormData filterCheckboxesData = new FormData();
        filterCheckboxesData.left = new FormAttachment(0, 6);
        filterCheckboxesData.bottom = new FormAttachment(100, -6);
        filterCheckboxes.setLayoutData((Object)filterCheckboxesData);
        filterCheckboxes.setLayout((Layout)new GridLayout(1, false));
        Label showOptionsLabel = new Label(filterCheckboxes, 0);
        showOptionsLabel.setText(Messages.OptionSelectionDialog_Show_options_marked__);
        this.showNormalBox = new Button(filterCheckboxes, 32);
        this.showNormalBox.setText(Messages.OptionSelectionDialog_normal);
        this.showNormalBox.setSelection(true);
        this.showNormalBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionSelectionDialog.this.updateTree();
            }
        });
        this.showExtendedBox = new Button(filterCheckboxes, 32);
        this.showExtendedBox.setText(Messages.OptionSelectionDialog_extended);
        this.showExtendedBox.setSelection(true);
        this.showExtendedBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                OptionSelectionDialog.this.updateTree();
            }
        });
        Label descLabel = new Label(rightBlock, 0);
        descLabel.setText(Messages.OptionSelectionDialog_Description__);
        FormData descLabelData = new FormData();
        descLabelData.left = new FormAttachment(0, 0);
        descLabelData.top = new FormAttachment(0, 12);
        descLabelData.right = new FormAttachment(100, -6);
        descLabel.setLayoutData((Object)descLabelData);
        this.descText = new Text(rightBlock, 2890);
        FormData descTextData = new FormData();
        descTextData.left = new FormAttachment(0, 0);
        descTextData.top = new FormAttachment((Control)descLabel, 6);
        descTextData.right = new FormAttachment(100, -6);
        descTextData.bottom = new FormAttachment(100, -6);
        this.descText.setLayoutData((Object)descTextData);
        Group initialValueGroup = new Group(dialogArea2, 0);
        initialValueGroup.setLayout((Layout)new GridLayout(2, false));
        initialValueGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        initialValueGroup.setText(Messages.OptionSelectionDialog_Initial_value);
        this.initialDefaultBox = new Button((Composite)initialValueGroup, 16);
        this.initialDefaultBox.setText(Messages.OptionSelectionDialog_Use_default_value);
        GridData initialDefaultData = new GridData();
        initialDefaultData.horizontalSpan = 2;
        this.initialDefaultBox.setLayoutData((Object)initialDefaultData);
        this.initialDefaultBox.setSelection(true);
        this.initialSpecifyBox = new Button((Composite)initialValueGroup, 16);
        this.initialSpecifyBox.setText(Messages.OptionSelectionDialog_Specify__);
        this.initialValueText = new Text((Composite)initialValueGroup, 2052);
        this.initialValueText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initialValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OptionSelectionDialog.this.initialDefaultBox.setSelection(false);
                OptionSelectionDialog.this.initialSpecifyBox.setSelection(true);
            }
        });
        this.updateTree();
        return dialogArea2;
    }

    protected void okPressed() {
        Object selectionObj;
        IStructuredSelection selection = (IStructuredSelection)this.optionsTree.getViewer().getSelection();
        IToolOptions toolOptions = this.model.getToolOptions();
        if (selection.isEmpty()) {
            this.setErrorMessage(Messages.OptionSelectionDialog_Nothing_selected__);
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            selectionObj = objectArray[n2];
            if (toolOptions.getAvailableGroups().contains(selectionObj)) {
                this.setErrorMessage(Messages.OptionSelectionDialog_Cannot_add_whole_categories__);
                return;
            }
            ++n2;
        }
        objectArray = selection.toArray();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            selectionObj = objectArray[n2];
            String option = (String)selectionObj;
            String initialValue = "";
            if (this.initialSpecifyBox.getSelection()) {
                initialValue = this.initialValueText.getText().trim();
            } else if (toolOptions.isAppendable(option)) {
                initialValue = "";
            } else {
                initialValue = toolOptions.getDefaultValue(option, this.model.getTargetValue());
                if (initialValue != null) {
                    if (initialValue.equals("true")) {
                        initialValue = "false";
                    } else if (initialValue.equals("false")) {
                        initialValue = "true";
                    }
                }
            }
            this.model.setOption(option, initialValue);
            ++n2;
        }
        super.okPressed();
    }

    private void updateTree() {
        assert (this.optionsTree != null && this.optionsTree.getViewer() != null && this.model != null);
        this.optionsTree.setRedraw(false);
        TreeViewer v = this.optionsTree.getViewer();
        ((OptionTreeContentProvider)v.getContentProvider()).setVisibility(this.showNormalBox.getSelection(), this.showExtendedBox.getSelection());
        v.refresh();
        v.expandAll();
        this.optionsTree.setRedraw(true);
    }

    static class OptionTreeContentProvider
    implements ITreeContentProvider {
        private Map<String, List<String>> options;
        private ToolChunk chunk;
        private boolean showNormal = true;
        private boolean showExtended = true;

        OptionTreeContentProvider() {
        }

        public void setVisibility(boolean showNormal, boolean showExtended) {
            boolean changed;
            boolean bl = changed = this.showNormal != showNormal || this.showExtended != showExtended;
            if (changed) {
                this.showNormal = showNormal;
                this.showExtended = showExtended;
                this.updateOptions();
            }
        }

        private void updateOptions() {
            this.options = new LinkedHashMap<String, List<String>>();
            IToolOptions toolOptions = this.chunk.getToolOptions();
            ArrayList optionsToDisplay = new ArrayList();
            optionsToDisplay.addAll(toolOptions.getAvailableOptions());
            optionsToDisplay.removeAll(this.chunk.getConfiguredOptions());
            ArrayList<String> hiddenOptions = new ArrayList<String>();
            for (String optionName : optionsToDisplay) {
                String optionType = toolOptions.getType(optionName);
                if ("normal".equals(optionType) && !this.showNormal || "extended".equals(optionType) && !this.showExtended || "internal".equals(optionType)) {
                    hiddenOptions.add(optionName);
                    continue;
                }
                String groupName = toolOptions.getGroup(optionName);
                if (!this.options.containsKey(groupName)) {
                    this.options.put(groupName, new ArrayList());
                }
                this.options.get(groupName).add(optionName);
            }
            optionsToDisplay.removeAll(hiddenOptions);
        }

        public Object[] getChildren(Object parentElement) {
            if (this.options.containsKey(parentElement)) {
                return this.options.get(parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (this.chunk.getToolOptions().getAvailableOptions().contains(element)) {
                return this.chunk.getToolOptions().getGroup((String)element);
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.options.containsKey(element);
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof ToolChunk) {
                return ((ToolChunk)inputElement).getToolOptions().getAvailableGroups().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof ToolChunk) {
                this.chunk = (ToolChunk)newInput;
                this.updateOptions();
            }
        }

        public void dispose() {
            this.options = null;
            this.chunk = null;
        }
    }
}

