/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.dialogs;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.AbstractAddTargetDialog;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ProjectFile;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.ui.MainMethodSearchEngine;
import com.aicas.jamaica.eclipse.ant_editor.ui.ViewerFactory;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class AddBuilderTargetDialog
extends AbstractAddTargetDialog {
    private TableViewer jamaicaTasksViewer;
    private ComboViewer targetViewer;
    private Text mainClassText;

    public AddBuilderTargetDialog(Shell parentShell, ProjectFile model) {
        super(parentShell, model);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.AddBuilderTargetDialog_window_title);
    }

    protected void createTargetSpecificArea(Composite parent) {
        this.setTitle(Messages.AddBuilderTargetDialog_title);
        this.setMessage(Messages.AddBuilderTargetDialog_message);
        Group builderTargetGroup = new Group(parent, 0);
        builderTargetGroup.setText(Messages.AddBuilderTargetDialog_Jamaica_settings);
        builderTargetGroup.setLayout((Layout)new GridLayout(3, false));
        builderTargetGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        Label taskLabel = new Label((Composite)builderTargetGroup, 0);
        taskLabel.setText(String.valueOf(Messages.AddBuilderTargetDialog_Task) + ':');
        this.jamaicaTasksViewer = ViewerFactory.getTaskdefViewer((Composite)builderTargetGroup, this.model.getTaskdefManager(), ToolType.JAMAICA, ToolType.JAMAICA_INTERNAL);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = 50;
        this.jamaicaTasksViewer.getTable().setLayoutData((Object)gd);
        this.jamaicaTasksViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AddBuilderTargetDialog.this.handleTaskViewerSelection();
            }
        });
        new Label((Composite)builderTargetGroup, 0);
        Label targetLabel = new Label((Composite)builderTargetGroup, 0);
        targetLabel.setText(String.valueOf(Messages.AddBuilderTargetDialog_Target_platform) + ':');
        this.targetViewer = new ComboViewer((Composite)builderTargetGroup, 2060);
        this.targetViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.targetViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.targetViewer.getCombo().setLayoutData((Object)new GridData(4, -1, true, false));
        new Label((Composite)builderTargetGroup, 0);
        Label mainLabel = new Label((Composite)builderTargetGroup, 0);
        mainLabel.setText(String.valueOf(Messages.AddBuilderTargetDialog_Main_class) + ':');
        this.mainClassText = new Text((Composite)builderTargetGroup, 2048);
        this.mainClassText.setLayoutData((Object)new GridData(4, -1, true, false));
        Button mainClassBrowseButton = new Button((Composite)builderTargetGroup, 8);
        mainClassBrowseButton.setText(Messages.AddBuilderTargetDialog_Browse______);
        mainClassBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddBuilderTargetDialog.this.handleMainClassBrowse();
            }
        });
        this.jamaicaTasksViewer.getTable().select(0);
        this.handleTaskViewerSelection();
    }

    private void handleTaskViewerSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.jamaicaTasksViewer.getSelection();
        if (!selection.isEmpty()) {
            String taskdefName = (String)selection.getFirstElement();
            JamaicaVMDistribution dist = this.model.getTaskdefManager().getDistribution(taskdefName);
            if (dist != null) {
                this.targetViewer.setInput((Object)dist.getAvailableTargets());
                this.targetViewer.setSelection((ISelection)new StructuredSelection((Object)dist.getHostTarget()));
            }
        }
    }

    protected void okPressed() {
        String complianceLevel;
        IJavaProject javaProject = AntEditorPlugin.getJavaProjectByName(this.model.getFile().getProject().getName());
        String name = this.nameText.getText().trim();
        if ("".equals(name)) {
            this.setErrorMessage(Messages.AddBuilderTargetDialog_Please_specify_a_name__);
            return;
        }
        if (this.targetNameUsed(name)) {
            this.setErrorMessage("Target name is already used");
            return;
        }
        String depends = this.dependsText.getText().trim();
        if ("".equals(depends)) {
            depends = null;
        }
        String taskdefName = null;
        IStructuredSelection jamaicaTaskSelection = (IStructuredSelection)this.jamaicaTasksViewer.getSelection();
        if (!jamaicaTaskSelection.isEmpty()) {
            taskdefName = (String)jamaicaTaskSelection.getFirstElement();
            TaskdefTag task = (TaskdefTag)this.model.getTaskdefManager().getTag(taskdefName);
            if (!task.isBound()) {
                this.setErrorMessage(Messages.AddBuilderTargetDialog_Select_task_that_is_bound_to_VM);
                return;
            }
        } else {
            this.setErrorMessage(Messages.AddBuilderTargetDialog_please_create_new_jamaica_task);
            return;
        }
        String target = null;
        IStructuredSelection targetSelection = (IStructuredSelection)this.targetViewer.getSelection();
        if (!targetSelection.isEmpty()) {
            target = (String)targetSelection.getFirstElement();
        }
        String mainClass = this.mainClassText.getText().trim();
        IType mainClassType = null;
        if ("".equals(mainClass)) {
            this.setErrorMessage(Messages.AddBuilderTargetDialog_Please_specify_a_main_class_name__);
            return;
        }
        String sourceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.source", true);
        IStatus status = JavaConventions.validateJavaTypeName((String)mainClass, (String)sourceLevel, (String)(complianceLevel = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true)));
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            return;
        }
        try {
            mainClassType = javaProject.findType(mainClass);
            if (mainClassType == null) {
                this.setErrorMessage("Main class must exist.");
                return;
            }
        }
        catch (JavaModelException e) {
            this.setErrorMessage("Error while checking the existence of the main class.");
            return;
        }
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put("target", target);
        options.put("main", mainClassType.getFullyQualifiedName());
        AntEditorPlugin.StringClasspathDescriber scd = AntEditorPlugin.getClasspath(this.model.getFile().getProject().getName());
        ArrayList<String> cpItems = new ArrayList<String>();
        cpItems.add(scd.outputLocation);
        cpItems.addAll(scd.libraryLocations);
        String separators = this.model.getTaskdefManager().getToolOptions(taskdefName).getSeparators("classpath");
        options.put("classpath", AntEditorPlugin.join(cpItems.toArray(), separators));
        String tmpDefault = this.model.getTaskdefManager().getToolOptions(taskdefName).getDefaultValue("tmpdir", target);
        options.put("tmpdir", tmpDefault != null ? tmpDefault : "tmp");
        options.put("interpret", "true");
        try {
            this.model.getToolChunkManager().addToolChunk(name, depends, taskdefName, options);
        }
        catch (ModelException me) {
            AntEditorPlugin.log(me);
            this.setErrorMessage(MessageFormat.format(Messages.AddBuilderTargetDialog_Could_not_add_new_Ant_target___1_____2, name, me.getMessage()));
            return;
        }
        super.okPressed();
    }

    private void handleMainClassBrowse() {
        IJavaProject project = AntEditorPlugin.getJavaProjectByName(this.model.getFile().getProject().getName());
        IJavaElement[] elements = null;
        if (project == null || !project.exists()) {
            IJavaModel model = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
            if (model != null) {
                try {
                    elements = model.getJavaProjects();
                }
                catch (JavaModelException e) {
                    AntEditorPlugin.log(e);
                }
            }
        } else {
            elements = new IJavaElement[]{project};
        }
        if (elements == null) {
            elements = new IJavaElement[]{};
        }
        int constraints = 1;
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)constraints);
        MainMethodSearchEngine engine = new MainMethodSearchEngine();
        Object[] types = engine.searchMainMethods((IProgressMonitor)new NullProgressMonitor(), searchScope, true);
        ElementListSelectionDialog elsd = new ElementListSelectionDialog(AntEditorPlugin.getShell(), (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IType) {
                    IType t = (IType)element;
                    return MessageFormat.format(Messages.AddBuilderTargetDialog_main_type_format, t.getFullyQualifiedName('.'), t.getPath().toString());
                }
                return null;
            }
        });
        elsd.setTitle(Messages.AddBuilderTargetDialog_Select_a_main_type);
        elsd.setMessage(String.valueOf(Messages.AddBuilderTargetDialog_Filter_types) + ':');
        elsd.setElements(types);
        if (elsd.open() == 1) {
            return;
        }
        Object[] results = elsd.getResult();
        IType type = (IType)results[0];
        if (type != null) {
            this.mainClassText.setText(type.getFullyQualifiedName('.'));
        }
    }
}

