/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.ui;

import com.aicas.jamaica.eclipse.ant_editor.ui.Messages;
import java.text.MessageFormat;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ModelPropertyEditor {
    protected static final String DISPLAY_MARKUP = "<form> <p> <b> {0}: </b> {1} {2} </p> </form>";
    private FormText formText;
    protected String name;
    protected boolean changeable;

    public ModelPropertyEditor(String name, Composite parent, FormToolkit toolkit, boolean changeable, Object layoutData) {
        this.name = name;
        this.formText = toolkit.createFormText(parent, false);
        if (layoutData != null) {
            this.formText.setLayoutData(layoutData);
        }
        this.changeable = changeable;
        if (changeable) {
            this.formText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ModelPropertyEditor.this.changeClicked();
                }
            });
        }
    }

    public void changeClicked() {
    }

    public abstract void updateUI();

    protected void updateFormText(String text) {
        this.formText.setText(MessageFormat.format(DISPLAY_MARKUP, this.name, text, this.changeable ? "(<a href=\"#change\"> " + Messages.ModelPropertyEditor_change + " </a>)" : ""), true, false);
    }
}

