/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.InteractiveTargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.Messages;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TaskdefTag;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunkManager;
import com.aicas.jamaica.eclipse.ant_editor.model.UnknownOptionException;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolChunk
extends InteractiveTargetChunk
implements IModelPartChangedListener {
    private TaskdefTag taskdef;
    private Map<String, Setting> options;
    private String maxMemory;
    private static List<String> nonOptionList = Arrays.asList("env", "envpropertyset");
    private Element toolNode;
    private Element echoTag;
    private IPath pathOfMainClass = Path.EMPTY;
    private Map<String, UIValidator> uiValidators;

    public ToolChunk(Node node, Element toolNode, ToolChunkManager manager) throws ModelException {
        super(node, manager);
        this.toolNode = toolNode;
        this.options = new LinkedHashMap<String, Setting>();
        this.uiValidators = new HashMap<String, UIValidator>();
        this.getManager().addListener(this);
        this.taskdef = (TaskdefTag)this.getManager().getProjectFile().getTaskdefManager().getTag(toolNode.getTagName());
        this.options.clear();
        if (this.taskdef == null) {
            throw new ModelException(Messages.ToolChunk_No_Ant_task_specified);
        }
        this.setListenerNotificationState(false);
        this.setMaxMemory(toolNode.getAttribute("maxmemory"));
        NodeList optionNodes = toolNode.getChildNodes();
        int i = 0;
        while (i < optionNodes.getLength()) {
            Node curOpt = optionNodes.item(i);
            if (curOpt.getNodeType() == 1) {
                Element curOptEle = (Element)curOpt;
                String curOptName = curOptEle.getTagName();
                Setting newSetting = new Setting(curOptEle);
                if (curOptName.toLowerCase().equals("option")) {
                    this.options.put(newSetting.getName(), newSetting);
                } else if (!nonOptionList.contains(curOptName)) {
                    this.options.put(curOptName, newSetting);
                }
            }
            ++i;
        }
        Node sib = toolNode;
        while ((sib = sib.getNextSibling()) != null) {
            if (sib.getNodeType() != 1 || !sib.getNodeName().equals("echo")) continue;
            this.echoTag = (Element)sib;
            break;
        }
        this.setPathOfMainClass();
        this.setListenerNotificationState(true);
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.READ_COMPLETE, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, this.getName()));
    }

    private void setPathOfMainClass() {
        String mainClass = this.getOptionValueResolved("main");
        if (mainClass != null && !mainClass.isEmpty()) {
            String mainSourceFile = mainClass.replace('.', '/').concat(".java");
            Path mainSourcePath = new Path(mainSourceFile);
            IJavaProject javaProject = this.getManager().getProjectFile().getProject();
            if (javaProject != null) {
                try {
                    IJavaElement mainClassJavaElement = javaProject.findElement((IPath)mainSourcePath);
                    if (mainClassJavaElement != null) {
                        this.pathOfMainClass = mainClassJavaElement.getPath();
                    }
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }

    public IPath getPathOfMainClass() {
        return this.pathOfMainClass;
    }

    public void setOption(String name, String newValue) {
        if (this.options.containsKey(name)) {
            this.setOption(name, newValue, this.options.get(name).getState());
        } else {
            this.setOption(name, newValue, true);
        }
    }

    public void setOption(String name, String newValue, boolean newState) {
        if (this.options.containsKey(name)) {
            this.setOption(name, newValue, newState, this.options.get(name).hasAppendSyntax());
        } else if (this.getToolOptions().isAppendable(name)) {
            this.setOption(name, newValue, newState, true);
        } else {
            this.setOption(name, newValue, newState, false);
        }
    }

    public void setOption(String name, String newValue, boolean newState, boolean append) {
        Element newOptEle;
        Setting oldSetting;
        if (newValue == null) {
            newValue = "";
        }
        boolean optionIsNew = (oldSetting = this.options.get(name)) == null;
        boolean optionHasChanged = false;
        if (oldSetting != null && !oldSetting.isInitialized()) {
            this.validateOption(oldSetting);
        }
        Setting newSetting = null;
        int jamMajVer = -1;
        int jamMinVer = -1;
        if (this.getTaskdef().isBound()) {
            jamMajVer = this.getTaskdef().getDistribution().getVersionMajor();
            jamMinVer = this.getTaskdef().getDistribution().getVersionMinor();
        }
        if (jamMajVer > 6 || jamMajVer == 6 && jamMinVer >= 4) {
            newOptEle = this.getManager().getProjectFile().getDocument().createElement("option");
            newOptEle.setAttribute("name", name);
        } else {
            if (nonOptionList.contains(name)) {
                return;
            }
            newOptEle = this.getManager().getProjectFile().getDocument().createElement(name);
        }
        newOptEle.setAttribute("value", newValue);
        newOptEle.setAttribute("enabled", Boolean.toString(newState));
        if (jamMajVer >= 6) {
            newOptEle.setAttribute("append", Boolean.toString(append));
        }
        newSetting = new Setting(newOptEle);
        this.validateOption(newSetting);
        boolean bl = optionHasChanged = !optionIsNew && !oldSetting.equals(newSetting);
        if (optionIsNew || optionHasChanged) {
            newSetting.addToTree();
            this.options.put(name, newSetting);
            this.getManager().getProjectFile().getPropertiesManager().findAndSetNewProperties(newValue);
            if (name.equals("main") || name.equals("destination") || name.equals("target")) {
                this.updateEchoMessage();
                if (name.equals("main")) {
                    this.setPathOfMainClass();
                }
            }
            if (name.equals("target") || name.equals("classpath")) {
                this.revalidate();
            }
            this.fireModelPartChanged(new ModelPartChangedEvent(this, optionIsNew ? ModelPartChangedEvent.ActionType.ADDED : ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        }
    }

    private boolean validateOption(Setting option) {
        ProblemManager probMan = this.getManager().getProjectFile().getProblemManager();
        IToolOptions jamaicaOptions = this.taskdef.getToolOptions();
        Setting oldSetting = this.options.get(option.getName());
        ProblemManager.Problem oldProblem = null;
        if (oldSetting != null) {
            oldProblem = oldSetting.getProblem();
        }
        if (jamaicaOptions == null) {
            option.setValid(false);
            ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/', MessageFormat.format(Messages.ToolChunk_Cannot_validate_options_for_Ant_task___1___, this.taskdef.getName()), 1, oldProblem);
            option.setProblem(newProblem);
        } else {
            String optionName = option.getName();
            if (!jamaicaOptions.getAvailableOptions().contains(optionName)) {
                option.setValid(false);
                ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/' + optionName, MessageFormat.format(Messages.ToolChunk_Option___1___is_unknown_for___2___in___3__, optionName, this.taskdef.getToolType().toolname(), this.taskdef.getDistribution()), 1, oldProblem);
                option.setProblem(newProblem);
            } else {
                String optionValueResolved;
                String optionValueRaw = option.getValue();
                try {
                    optionValueResolved = this.getManager().getProjectFile().getPropertiesManager().resolveStringWithProperties(optionValueRaw);
                }
                catch (ModelException me) {
                    optionValueResolved = optionValueRaw;
                }
                String validationError = null;
                List seArgs = jamaicaOptions.getOptionEditorArgs(optionName);
                if (seArgs == null) {
                    seArgs = Collections.EMPTY_LIST;
                }
                if (jamaicaOptions.isAppendable(optionName) && seArgs.contains("file")) {
                    String[] tokens;
                    String basedir = this.getManager().getProjectFile().getBasedirPath();
                    String seps = jamaicaOptions.getSeparators(optionName);
                    StringBuilder newString = new StringBuilder();
                    String[] stringArray = tokens = optionValueResolved.split("[" + Pattern.quote(seps) + "]");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String token = stringArray[n2];
                        if (token != null && !token.isEmpty()) {
                            if (newString.length() > 0) {
                                newString.append(seps.charAt(0));
                            }
                            if (!new File(token).isAbsolute()) {
                                token = String.valueOf(basedir) + File.separator + token;
                            }
                            newString.append(token);
                        }
                        ++n2;
                    }
                    validationError = jamaicaOptions.validate(optionName, newString.toString());
                } else {
                    validationError = jamaicaOptions.validate(optionName, optionValueResolved);
                }
                if (validationError == null && this.uiValidators.containsKey(optionName)) {
                    validationError = this.uiValidators.get(optionName).validateForUI(optionValueResolved);
                }
                if (validationError != null) {
                    option.setValid(false);
                    ProblemManager.Problem newProblem = probMan.reportProblem(String.valueOf(this.getName()) + '/' + optionName, validationError, 1, oldProblem);
                    option.setProblem(newProblem);
                } else {
                    option.setValid(true);
                    if (oldProblem != null) {
                        probMan.problemSolved(oldProblem);
                    }
                }
            }
        }
        return option.isValid();
    }

    public boolean hasAppendSyntax(String name) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        return this.options.get(name).hasAppendSyntax();
    }

    public void setAppendSyntax(String name, boolean appendSyntax) {
        if (this.options.containsKey(name)) {
            boolean hadAppendSyntax = this.options.get(name).hasAppendSyntax();
            this.options.get(name).setAppendSyntax(appendSyntax);
            if (hadAppendSyntax != appendSyntax) {
                this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
            }
        }
    }

    public boolean removeOption(String name) {
        if (!this.options.containsKey(name)) {
            return false;
        }
        Setting s = this.options.remove(name);
        if (s.isChildOfTree()) {
            s.removeFromTree();
        }
        if (s.getProblem() != null) {
            this.getManager().getProjectFile().getProblemManager().problemSolved(s.getProblem());
        }
        if (name.equals("main") || name.equals("destination") || name.equals("target")) {
            this.updateEchoMessage();
        }
        this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.REMOVED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION, name));
        return true;
    }

    public String getOptionValueResolved(String name) {
        String value = this.getOptionValue(name);
        try {
            value = this.getManager().getProjectFile().getPropertiesManager().resolveStringWithProperties(value);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return value;
    }

    public String getOptionValue(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getValue();
        }
        return null;
    }

    public String getTargetValue() {
        String target = null;
        target = this.getOptionValueResolved("target");
        if (this.isBound() && (target == null || !this.getOptionState("target"))) {
            target = this.getDistribution().getHostTarget();
        }
        return target;
    }

    public boolean getOptionState(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getState();
        }
        return false;
    }

    public boolean isValidOption(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).isValid();
        }
        return false;
    }

    public String getOptionLastError(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name).getProblem() == null ? null : this.options.get(name).getProblem().getMessage();
        }
        return null;
    }

    public void addUIValidator(String name, UIValidator uiv) throws UnknownOptionException {
        if (this.taskdef.getToolOptions().getAvailableOptions().contains(name)) {
            this.uiValidators.put(name, uiv);
            if (this.options.containsKey(name)) {
                this.setOption(name, this.getOptionValue(name));
            }
        } else {
            throw new UnknownOptionException(MessageFormat.format(Messages.ToolChunk_Option___1___is_not_configured, name));
        }
    }

    public List<String> getConfiguredOptions() {
        return new ArrayList<String>(this.options.keySet());
    }

    void setTaskdef(TaskdefTag taskdef) {
        this.taskdef = taskdef;
    }

    TaskdefTag getTaskdef() {
        return this.taskdef;
    }

    public String getTaskdefName() {
        return this.taskdef.getName();
    }

    public void setTaskdefName(String name) throws ModelException {
        TaskdefTag newTaskdef = (TaskdefTag)this.getManager().getProjectFile().getTaskdefManager().getTag(name);
        if (newTaskdef == null) {
            throw new ModelException(String.valueOf(Messages.ToolChunk_Unknown_Ant_task___) + name);
        }
        this.taskdef = newTaskdef;
        Document projectDoc = this.getManager().getProjectFile().getDocument();
        if (!projectDoc.equals(this.toolNode.getOwnerDocument())) {
            this.toolNode = (Element)projectDoc.adoptNode(this.toolNode);
        }
        projectDoc.renameNode(this.toolNode, null, name);
        this.updateEchoMessage();
        this.revalidate();
    }

    void revalidate() {
        boolean changed = false;
        if (!this.getJamaicaAttr().isEmpty()) {
            String curJamAttrValue = this.getJamaicaAttr();
            String taskdefJamDir = "";
            JamaicaVMDistribution dist = this.getTaskdef().getDistribution();
            if (this.getTaskdef().isBound()) {
                taskdefJamDir = dist.getInstallDirectory();
            }
            if (!(taskdefJamDir.isEmpty() || curJamAttrValue.equals(taskdefJamDir) || curJamAttrValue.equals("${jamaica}"))) {
                this.setJamaicaAttr(taskdefJamDir);
                changed = true;
            }
        }
        for (Map.Entry<String, Setting> entry : this.options.entrySet()) {
            Setting option = entry.getValue();
            this.setOption(option.getName(), option.getValue());
        }
        if (changed) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK, this.getName()));
        }
    }

    public IToolOptions getToolOptions() {
        return this.taskdef.getToolOptions();
    }

    public Node getToolNode() {
        return this.toolNode;
    }

    public ToolType getToolType() {
        return this.taskdef.getToolType();
    }

    public boolean isBound() {
        return this.taskdef.isBound();
    }

    public boolean buildsForHost() {
        boolean result = false;
        if (this.isBound()) {
            result = this.getDistribution().getHostTarget().equals(this.getTargetValue());
        }
        return result;
    }

    public JamaicaVMDistribution getDistribution() {
        return this.taskdef.getDistribution();
    }

    public String calcExecutableName() {
        if (!ToolType.isJamaica((ToolType)this.getToolType())) {
            return null;
        }
        String destination = null;
        String main = null;
        destination = this.getOptionValueResolved("destination");
        if (destination != null && this.getOptionState("destination")) {
            String exeExt = AntEditorPlugin.getExeExtension();
            if (!destination.endsWith(exeExt)) {
                destination = String.valueOf(destination) + exeExt;
            }
            return destination;
        }
        main = this.getOptionValueResolved("main");
        if (main != null && this.getOptionState("main")) {
            if (this.isBound() && (this.getDistribution().getVersionMajor() == 6 && this.getDistribution().getVersionMinor() >= 3 || this.getDistribution().getVersionMajor() > 6)) {
                main = AntEditorPlugin.getSimpleClassName(main);
            }
            return String.valueOf(main) + AntEditorPlugin.getExeExtension();
        }
        return null;
    }

    public String calcExecutablePath() {
        String execPath = null;
        String execName = this.calcExecutableName();
        if (execName != null) {
            File execFile = new File(execName);
            execPath = !execFile.isAbsolute() ? LauncherPlugin.normalize((String)(String.valueOf(this.getManager().getProjectFile().getBasedirPath()) + File.separator + execName)) : LauncherPlugin.normalize((String)execName);
        }
        return execPath;
    }

    public String getJamaicaAttr() {
        return ((Element)this.getToolNode()).getAttribute("jamaica");
    }

    public void setJamaicaAttr(String jamaicaAttr) {
        if (((Element)this.getToolNode()).hasAttribute("jamaica")) {
            this.toolNode.setAttribute("jamaica", jamaicaAttr);
        }
    }

    public String getEchoMessage() {
        String echoMsg = null;
        if (this.echoTag != null) {
            echoMsg = this.echoTag.getTextContent();
        }
        return echoMsg;
    }

    public void setEchoMessage(String echoMsg) {
        if (this.echoTag != null) {
            this.echoTag.setTextContent(echoMsg);
        } else {
            Element newEchoTag = this.getManager().getProjectFile().getDocument().createElement("echo");
            newEchoTag.setTextContent(echoMsg);
            this.getNode().appendChild(newEchoTag);
            this.echoTag = newEchoTag;
        }
    }

    public static String createEchoMessage(String execPath, boolean isHost) {
        String newLine = "\n";
        String echoStr = String.valueOf(newLine) + "      ";
        echoStr = String.valueOf(echoStr) + Messages.ToolChunk_The_executable_has_been_created_successfully__;
        echoStr = String.valueOf(echoStr) + newLine + "        ";
        echoStr = String.valueOf(echoStr) + execPath;
        echoStr = String.valueOf(echoStr) + newLine + "      ";
        echoStr = isHost ? String.valueOf(echoStr) + Messages.ToolChunk_You_can_launch_it_using_the___Overview___page_in_this_editor__ : String.valueOf(echoStr) + Messages.ToolChunk_Please_transfer_it_to_your_target_device_manually__;
        echoStr = String.valueOf(echoStr) + newLine + "    ";
        return echoStr;
    }

    public void updateEchoMessage() {
        if (this.echoTag != null) {
            String echoStr = ToolChunk.createEchoMessage(this.calcExecutablePath(), this.buildsForHost());
            this.setEchoMessage(echoStr);
        }
    }

    public String getMaxMemory() {
        return this.maxMemory;
    }

    public void setMaxMemory(String maxMemory) {
        this.maxMemory = maxMemory;
    }

    public void promoteSettingEditorDirty(String optionName) {
        ModelPartChangedEvent mpce = new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TOOL_CHUNK_OPTION_DIRTY, optionName);
        this.fireModelPartChanged(mpce);
    }

    @Override
    public void modelPartChanged(ModelPartChangedEvent mpce) {
        if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.TASKDEF && mpce.getAction() != ModelPartChangedEvent.ActionType.REMOVED && this.taskdef.getName().equals(mpce.getElementName())) {
            try {
                this.setTaskdefName(mpce.getElementName());
            }
            catch (ModelException modelException) {}
        } else if (mpce.getPart() == ModelPartChangedEvent.ModelPartType.ANT_PROPERTY && (mpce.getAction() == ModelPartChangedEvent.ActionType.ADDED || mpce.getAction() == ModelPartChangedEvent.ActionType.CHANGED)) {
            this.revalidate();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeListener(this);
    }

    private class Setting {
        static final String ENABLED = "enabled";
        static final String APPEND = "append";
        static final String VALUE = "value";
        static final String NAME = "name";
        private Element optionElement;
        private boolean valid;
        private ProblemManager.Problem problem;

        public Setting(Element optElement) {
            this.optionElement = optElement;
        }

        public String getValue() {
            return this.optionElement.getAttribute(VALUE);
        }

        public void setValue(String value) {
            this.optionElement.setAttribute(VALUE, value);
        }

        public boolean getState() {
            boolean res = this.optionElement.getAttribute(ENABLED).isEmpty() ? true : Boolean.parseBoolean(this.optionElement.getAttribute(ENABLED));
            return res;
        }

        public void setState(boolean state) {
            this.optionElement.setAttribute(ENABLED, Boolean.toString(state));
        }

        public boolean hasAppendSyntax() {
            return Boolean.parseBoolean(this.optionElement.getAttribute(APPEND));
        }

        public void setAppendSyntax(boolean appendSyntax) {
            this.optionElement.setAttribute(APPEND, Boolean.toString(appendSyntax));
        }

        public boolean isValid() {
            return this.valid;
        }

        public boolean isInitialized() {
            return this.valid || this.problem != null;
        }

        public boolean isChildOfTree() {
            Node parent = this.optionElement.getParentNode();
            return ToolChunk.this.getToolNode().isSameNode(parent);
        }

        public boolean addToTree() {
            boolean res = false;
            Node parent = this.optionElement.getParentNode();
            if (parent == null) {
                if (!this.optionElement.getOwnerDocument().equals(ToolChunk.this.getToolNode().getOwnerDocument())) {
                    this.optionElement = (Element)ToolChunk.this.getToolNode().getOwnerDocument().adoptNode(this.optionElement);
                }
                String optName = this.getName();
                if (ToolChunk.this.options.containsKey(optName)) {
                    Element oldOpt = ((Setting)ToolChunk.this.options.get(optName)).getElement();
                    oldOpt.getParentNode().replaceChild(this.optionElement, oldOpt);
                    res = true;
                } else {
                    Node last;
                    for (last = ToolChunk.this.getToolNode().getLastChild(); last != null; last = last.getPreviousSibling()) {
                        if (last.getNodeType() == 8 || last.getNodeType() == 3) {
                            if (last.getPreviousSibling() == null) break;
                            continue;
                        }
                        last = last.getNextSibling();
                        break;
                    }
                    this.optionElement = (Element)ToolChunk.this.getToolNode().insertBefore(this.optionElement, last);
                    res = true;
                }
            }
            return res;
        }

        public boolean removeFromTree() {
            boolean res = false;
            Node parent = this.optionElement.getParentNode();
            if (parent != null) {
                Node prevSib = this.optionElement.getPreviousSibling();
                if (prevSib != null && prevSib.getNodeType() == 3) {
                    parent.removeChild(prevSib);
                }
                this.optionElement = (Element)parent.removeChild(this.optionElement);
                res = true;
            }
            return res;
        }

        public void setValid(boolean valid) {
            this.valid = valid;
        }

        public ProblemManager.Problem getProblem() {
            return this.problem;
        }

        public void setProblem(ProblemManager.Problem problem) {
            this.problem = problem;
        }

        public String getName() {
            String optionName = "";
            optionName = this.getElement().getTagName().toLowerCase().equals("option") ? this.getElement().getAttribute(NAME) : this.getElement().getTagName();
            return optionName;
        }

        public Element getElement() {
            return this.optionElement;
        }

        public String toString() {
            return "Option:name=" + this.getName() + ":value=" + this.getValue() + ":state=" + this.getState() + ":append=" + this.hasAppendSyntax() + ":valid=" + this.isValid() + ":problem=" + this.getProblem();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
            result = 31 * result + (this.getValue() == null ? 0 : this.getValue().hashCode());
            result = 31 * result + (this.getState() ? 1231 : 1237);
            result = 31 * result + (this.hasAppendSyntax() ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Setting)) {
                return false;
            }
            Setting other = (Setting)obj;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (!this.optionElement.getTagName().equals(other.optionElement.getTagName())) {
                return false;
            }
            if (!this.getValue().equals(other.getValue())) {
                return false;
            }
            if (this.optionElement.hasAttribute(ENABLED) != other.optionElement.hasAttribute(ENABLED)) {
                return false;
            }
            if (this.getState() != other.getState()) {
                return false;
            }
            if (this.optionElement.hasAttribute(APPEND) != other.optionElement.hasAttribute(APPEND)) {
                return false;
            }
            if (this.hasAppendSyntax() != other.hasAppendSyntax()) {
                return false;
            }
            return this.isValid() == other.isValid();
        }
    }

    public static abstract class UIValidator {
        public abstract String validateForUI(String var1);
    }
}

