/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.model;

import com.aicas.jamaica.eclipse.ant_editor.model.ExecChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.IModelPartChangedListener;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelException;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartChangedEvent;
import com.aicas.jamaica.eclipse.ant_editor.model.ModelPartManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ProblemManager;
import com.aicas.jamaica.eclipse.ant_editor.model.TargetChunk;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import java.util.LinkedHashSet;
import java.util.Set;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InteractiveTargetChunk
extends TargetChunk {
    private boolean active = true;
    private Object activeLock = new Object();
    protected ModelPartChangedEvent.ModelPartType partType = null;
    private Set<ProblemManager.Problem> problems;
    private Set<IModelPartChangedListener> listeners = new LinkedHashSet<IModelPartChangedListener>();

    public InteractiveTargetChunk(Node node, ModelPartManager<?> parent) throws ModelException {
        super(node, parent);
        this.problems = new LinkedHashSet<ProblemManager.Problem>();
        this.partType = this instanceof ToolChunk ? ModelPartChangedEvent.ModelPartType.TOOL_CHUNK : (this instanceof ExecChunk ? ModelPartChangedEvent.ModelPartType.EXEC_CHUNK : ModelPartChangedEvent.ModelPartType.TARGET_CHUNK);
    }

    public boolean addProblem(ProblemManager.Problem prob) {
        boolean added = this.problems.add(prob);
        if (added) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, this.partType, "PROBLEM-ADDED"));
        }
        return added;
    }

    public boolean removeProblem(ProblemManager.Problem prob) {
        boolean removed = this.problems.remove(prob);
        if (removed) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, this.partType, "PROBLEM-REMOVED"));
        }
        return removed;
    }

    public void clearProblems() {
        if (!this.problems.isEmpty()) {
            for (ProblemManager.Problem p : this.problems) {
                this.getManager().getProjectFile().getProblemManager().problemSolved(p);
            }
            this.problems.clear();
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, this.partType, "PROBLEM-CLEARED"));
        }
    }

    public void addListener(IModelPartChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IModelPartChangedListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelPartChanged(ModelPartChangedEvent event) {
        Object object = this.activeLock;
        synchronized (object) {
            if (!this.active) {
                return;
            }
        }
        IModelPartChangedListener[] listenerArray = this.listeners.toArray(new IModelPartChangedListener[0]);
        Object lastHop = event.getLastHop();
        IModelPartChangedListener[] iModelPartChangedListenerArray = listenerArray;
        int n = listenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelPartChangedListener listener = iModelPartChangedListenerArray[n2];
            event.setLastHop(this);
            if (!listener.equals(lastHop)) {
                listener.modelPartChanged(event);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setListenerNotificationState(boolean enabled) {
        Object object = this.activeLock;
        synchronized (object) {
            this.active = enabled;
        }
    }

    @Override
    public void setDepends(String depends) {
        String oldDepends = this.getDepends();
        if (!oldDepends.equals(depends)) {
            super.setDepends(depends);
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TARGET_CHUNK, "depends"));
        }
    }

    @Override
    public void setIfAttribute(String ifAttribute) {
        String oldIf = this.getIfAttribute();
        super.setIfAttribute(ifAttribute);
        if (oldIf == null || !oldIf.equals(ifAttribute)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TARGET_CHUNK, "if"));
        }
    }

    @Override
    public void setUnless(String unless) {
        String oldUnless = this.getUnless();
        super.setUnless(unless);
        if (oldUnless == null || !oldUnless.equals(unless)) {
            this.fireModelPartChanged(new ModelPartChangedEvent(this, ModelPartChangedEvent.ActionType.CHANGED, ModelPartChangedEvent.ModelPartType.TARGET_CHUNK, "unless"));
        }
    }
}

