/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.editors.se;

import com.aicas.jamaica.eclipse.ant_editor.AntEditorPlugin;
import com.aicas.jamaica.eclipse.ant_editor.dialogs.InfoPopUp;
import com.aicas.jamaica.eclipse.ant_editor.editors.JamaicaAntEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.AgentlibSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.BooleanSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.ListSelectionSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.Messages;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.StringListSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.editors.se.StringSettingEditor;
import com.aicas.jamaica.eclipse.ant_editor.model.PropertiesManager;
import com.aicas.jamaica.eclipse.ant_editor.model.ToolChunk;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class AbstractSettingEditor {
    private Composite parentComposite;
    private Composite dialogArea;
    protected Group optionControls;
    private ToolBar optionToolbar;
    private ToolItem enabledButton;
    private ToolItem appendButton;
    private ToolItem loadDefaultButton;
    private ToolItem showPropertiesButton;
    private ToolItem showDescriptionButton;
    private ToolItem removeButton;
    protected ControlDecoration invalidDecorator;
    private String oldValue;
    private boolean oldEnabledState;
    private boolean oldAppendState;
    private FormToolkit theToolkit;
    protected LocalResourceManager jaeResMan = JamaicaAntEditor.getResourceManager();
    private boolean controlsCreated = false;
    protected String associatedOption;
    protected ToolChunk model;
    protected PropertiesManager propertiesManager;
    public static final int CONTROL_WIDTH = 300;
    public static final int LIST_HEIGHT = 80;
    public static final int OFFSET_SMALL = 0;
    public static final int OFFSET_NORMAL = 1;
    public static final int OFFSET_BIG = 2;
    protected Font groupFont = JamaicaAntEditor.getResourceManager().createFont(JamaicaAntEditor.FONT_GROUP);

    protected AbstractSettingEditor(String optionName, ToolChunk chunk) {
        this.associatedOption = optionName;
        this.model = chunk;
        this.propertiesManager = this.model.getManager().getProjectFile().getPropertiesManager();
        this.oldValue = this.getValue();
        this.oldEnabledState = this.getState();
        this.oldAppendState = this.hasAppendSyntax();
    }

    public void createControls(Composite parent, FormToolkit toolkit) {
        this.parentComposite = parent;
        this.theToolkit = toolkit;
        this.dialogArea = new Composite(this.parentComposite, 0);
        this.dialogArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        GridLayout optionFrameGridLayout = new GridLayout(3, false);
        optionFrameGridLayout.verticalSpacing = 15;
        optionFrameGridLayout.marginHeight = 0;
        optionFrameGridLayout.marginWidth = 0;
        this.dialogArea.setLayout((Layout)optionFrameGridLayout);
        this.optionToolbar = new ToolBar(this.dialogArea, 0);
        this.optionToolbar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.optionControls = new Group(this.dialogArea, 0);
        this.optionControls.setText("Option value");
        this.optionControls.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.dialogArea.setTabList(new Control[]{this.optionToolbar, this.optionControls});
        this.createInputArea((Composite)this.optionControls, this.theToolkit);
        if (this.invalidDecorator != null) {
            this.invalidDecorator.setImage(this.jaeResMan.createImage(JamaicaAntEditor.PluginImage.IMG_OPTION_INVALID.getImgDesc()));
        }
        this.enabledButton = new ToolItem(this.optionToolbar, 8);
        this.setEnabledButton(this.getState());
        this.enabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                boolean newEnabledState = !AbstractSettingEditor.this.getState();
                AbstractSettingEditor.this.setState(newEnabledState);
                AbstractSettingEditor.this.setEnabledButton(newEnabledState);
            }
        });
        this.enabledButton.setToolTipText(Messages.AbstractSettingEditor_use_button_tooltip);
        if (this.model.getToolOptions().getDefaultValue(this.associatedOption, this.model.getTargetValue()) != null) {
            if (this.model.getToolOptions().isAppendable(this.associatedOption) && this.model.getDistribution() != null && this.model.getDistribution().getVersionMajor() >= 6) {
                this.appendButton = new ToolItem(this.optionToolbar, 32);
                this.appendButton.setText("Append");
                this.appendButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_APPEND.getImgDesc()));
                this.appendButton.setToolTipText(Messages.AbstractSettingEditor_append_button_tooltip);
                this.appendButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractSettingEditor.this.setAppendSyntax(AbstractSettingEditor.this.appendButton.getSelection());
                    }
                });
            }
            this.loadDefaultButton = new ToolItem(this.optionToolbar, 8);
            this.loadDefaultButton.setText("Reset");
            this.loadDefaultButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_RESET.getImgDesc()));
            this.loadDefaultButton.setToolTipText(Messages.AbstractSettingEditor_default_button_tooltip);
            this.loadDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    AbstractSettingEditor.this.setValue(AbstractSettingEditor.this.model.getToolOptions().getDefaultValue(AbstractSettingEditor.this.associatedOption, AbstractSettingEditor.this.model.getTargetValue()));
                }
            });
        }
        this.showPropertiesButton = new ToolItem(this.optionToolbar, 8);
        this.showPropertiesButton.setText("Properties");
        this.showPropertiesButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_PROP_EDIT.getImgDesc()));
        this.showPropertiesButton.setEnabled(PropertiesManager.extractProperties(this.getValue()).size() > 0);
        this.showPropertiesButton.setToolTipText(Messages.AbstractSettingEditor_properties_button_tooltip);
        this.showPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoPopUp.showPropertyEditor(AbstractSettingEditor.this.dialogArea.getShell(), AbstractSettingEditor.this.model, AbstractSettingEditor.this.associatedOption);
            }
        });
        this.showDescriptionButton = new ToolItem(this.optionToolbar, 8);
        this.showDescriptionButton.setText("Help");
        this.showDescriptionButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_HELP.getImgDesc()));
        this.showDescriptionButton.setToolTipText(Messages.AbstractSettingEditor_help_button_tooltip);
        this.showDescriptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSettingEditor.this.model.isBound()) {
                    InfoPopUp.showOptionHelp(AbstractSettingEditor.this.dialogArea.getShell(), AbstractSettingEditor.this.model, AbstractSettingEditor.this.associatedOption);
                }
            }
        });
        this.removeButton = new ToolItem(this.optionToolbar, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_REMOVE.getImgDesc()));
        this.removeButton.setToolTipText(Messages.AbstractSettingEditor_remove_button_tooltip);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openQuestion((Shell)AntEditorPlugin.getShell(), (String)Messages.AbstractSettingEditor_Remove_option, (String)MessageFormat.format(Messages.AbstractSettingEditor_Do_you_want_to_remove_the_option___1____, AbstractSettingEditor.this.associatedOption))) {
                    try {
                        boolean wasRemoved = AbstractSettingEditor.this.model.removeOption(AbstractSettingEditor.this.associatedOption);
                        if (wasRemoved) {
                            AbstractSettingEditor.this.parentComposite.getShell().close();
                        }
                    }
                    catch (Exception ex) {
                        AntEditorPlugin.log(ex);
                    }
                }
            }
        });
        this.optionToolbar.pack();
        this.optionControls.pack();
        this.dialogArea.pack();
        this.controlsCreated = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                AbstractSettingEditor.this.grabFocus();
            }
        });
    }

    protected void setEnabledButton(boolean selected) {
        if (selected) {
            this.enabledButton.setText("Enabled");
            this.enabledButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_ENABLED.getImgDesc()));
        } else {
            this.enabledButton.setText("Disabled");
            this.enabledButton.setImage(this.jaeResMan.createImageWithDefault(JamaicaAntEditor.PluginImage.IMG_OPTION_DISABLED.getImgDesc()));
        }
    }

    protected abstract void createInputArea(Composite var1, FormToolkit var2);

    protected void setState(boolean newState) {
        this.model.setOption(this.associatedOption, this.model.getOptionValue(this.associatedOption), newState);
    }

    public void resetValue() {
        this.model.setOption(this.associatedOption, this.oldValue, this.oldEnabledState, this.oldAppendState);
    }

    protected void setValue(String newValue) {
        this.model.setOption(this.associatedOption, newValue);
    }

    protected void setAppendSyntax(boolean newAppendSyntax) {
        this.model.setAppendSyntax(this.associatedOption, newAppendSyntax);
    }

    protected String getValue() {
        return this.model.getOptionValue(this.associatedOption);
    }

    protected String getValueResolved() {
        return this.model.getOptionValueResolved(this.associatedOption);
    }

    protected boolean getState() {
        return this.model.getOptionState(this.associatedOption);
    }

    protected boolean hasAppendSyntax() {
        return this.model.hasAppendSyntax(this.associatedOption);
    }

    protected boolean isValid() {
        return this.model.isValidOption(this.associatedOption);
    }

    protected String getLastError() {
        return this.model.getOptionLastError(this.associatedOption);
    }

    public void dispose() {
        if (!this.controlsCreated) {
            throw new IllegalStateException(Messages.AbstractSettingEditor_Controls_have_not_been_created_yet);
        }
        this.dialogArea.dispose();
    }

    public void updateUI() {
        if (!this.controlsCreated) {
            return;
        }
        this.enabledButton.setSelection(this.getState());
        this.showPropertiesButton.setEnabled(PropertiesManager.extractProperties(this.getValue()).size() > 0);
        if (this.appendButton != null) {
            this.appendButton.setSelection(this.hasAppendSyntax());
        }
        if (this.invalidDecorator != null) {
            if (!this.isValid()) {
                if (this.getLastError() != null) {
                    this.invalidDecorator.setDescriptionText(this.getLastError());
                } else {
                    this.invalidDecorator.setDescriptionText("Invalid for unknown reasons. Please notify support@aicas.de about this.");
                }
                GridData gd = (GridData)this.invalidDecorator.getControl().getLayoutData();
                gd.horizontalIndent = 10;
                this.dialogArea.layout(true, true);
                this.invalidDecorator.show();
            } else {
                GridData gd = (GridData)this.invalidDecorator.getControl().getLayoutData();
                gd.horizontalIndent = 0;
                this.dialogArea.layout(true, true);
                this.invalidDecorator.hide();
            }
        }
    }

    public void grabFocus() {
        if (!this.controlsCreated) {
            throw new IllegalStateException(Messages.AbstractSettingEditor_Controls_have_not_been_created_yet);
        }
    }

    public static AbstractSettingEditor newSettingEditor(String optionName, ToolChunk chunk, Composite parent, FormToolkit toolkit) {
        AbstractSettingEditor ase = null;
        try {
            IToolOptions.EditorType editorType = chunk.getToolOptions().getOptionEditorType(optionName);
            if (editorType == null) {
                editorType = IToolOptions.EditorType.STRING;
            }
            switch (editorType) {
                case AGENTLIB: {
                    ase = new AgentlibSettingEditor(optionName, chunk);
                    break;
                }
                case BOOLEAN: {
                    ase = new BooleanSettingEditor(optionName, chunk);
                    break;
                }
                case LIST_SELECTION: {
                    ase = new ListSelectionSettingEditor(optionName, chunk);
                    break;
                }
                case STRING_LIST: {
                    ase = new StringListSettingEditor(optionName, chunk);
                    break;
                }
                case STRING: {
                    ase = new StringSettingEditor(optionName, chunk);
                    break;
                }
                default: {
                    ase = new StringSettingEditor(optionName, chunk);
                    break;
                }
            }
        }
        catch (Exception e) {
            AntEditorPlugin.log(e);
        }
        ase.createControls(parent, toolkit);
        return ase;
    }
}

