/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ant_editor.contentdescriber;

import com.aicas.jamaica.eclipse.ant_editor.model.VersionTag;
import com.aicas.jamaica.eclipse.core.ToolType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public class JamaicaBuildFileContentDescriber
implements ITextContentDescriber {
    public static final String JAMAICA_BUILD_FILE_CONTENT_TYPE_ID = "com.aicas.jamaica.eclipse.ant_editor.JamaicaBuildFileContentType";
    private static final Pattern jamaicaTaskdefPattern = Pattern.compile(".*<taskdef.*classname=\"(\\w[\\.\\w]*)\".*/>.*");
    private static final Pattern jamaicaAntEditorTagPattern = Pattern.compile(".*<!--[ ]*" + VersionTag.VERSION_TAG_PATTERN.pattern() + "[ ]*-->.*");

    public int describe(Reader contentReader, IContentDescription contentDescription) throws IOException {
        return JamaicaBuildFileContentDescriber.isJamaicaAntEditorXML(contentReader) ? 2 : 0;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        InputStreamReader ir = new InputStreamReader(contents);
        return this.describe(ir, description);
    }

    public QualifiedName[] getSupportedOptions() {
        return new QualifiedName[0];
    }

    public static boolean isJamaicaAntEditorXML(File file) {
        boolean retval = false;
        InputStreamReader reader = null;
        try {
            try {
                reader = new InputStreamReader(new FileInputStream(file));
                retval = JamaicaBuildFileContentDescriber.isJamaicaAntEditorXML(reader);
            }
            catch (IOException iOException) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        return retval;
    }

    public static boolean isJamaicaAntEditorXML(Reader fileReader) throws IOException {
        BufferedReader bufferedContentReader = new BufferedReader(fileReader);
        String xmlLine = null;
        StringBuilder xmlContent = new StringBuilder();
        while ((xmlLine = bufferedContentReader.readLine()) != null) {
            xmlContent.append(xmlLine);
        }
        Matcher jamaicaTaskdefMatcher = jamaicaTaskdefPattern.matcher(xmlContent.toString());
        String taskdefClassName = null;
        boolean hasJamaicaTaskdef = jamaicaTaskdefMatcher.matches() && (taskdefClassName = jamaicaTaskdefMatcher.group(1)) != null && ToolType.valueOfClassname((String)taskdefClassName) != null;
        Matcher jamaicaAntEditorTagMatcher = jamaicaAntEditorTagPattern.matcher(xmlContent.toString());
        boolean hasJamaicaAntEditorTag = jamaicaAntEditorTagMatcher.matches();
        return hasJamaicaTaskdef && hasJamaicaAntEditorTag;
    }
}

