/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.vm;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaVMType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.vm.JamaicaVM;
import com.aicas.jamaica.eclipse.launcher.vm.LaunchingMessages;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.LibraryLocation;

public class JamaicaVMType
extends AbstractJamaicaVMType {
    public static final String JAMAICAVM_TYPE_ID = "com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMType";
    public static final String JAMAICAVM_INSTALL_ID_PREFIX = "com.aicas.jamaica.eclipse.launcher.vm.JamaicaVMInstall_";
    protected static final List<Integer> SUPPORTED_MAJOR_VERSIONS = Arrays.asList(3, 6, 8);

    protected IVMInstall doCreateVMInstall(String id) {
        return new JamaicaVM((IVMInstallType)this, id);
    }

    public File detectInstallLocation() {
        return null;
    }

    public LibraryLocation[] getDefaultLibraryLocations(File installLocation) {
        ArrayList<LibraryLocation> defaultLibLocations = new ArrayList<LibraryLocation>();
        String path = LauncherPlugin.normalize(installLocation.getAbsolutePath());
        if (this.isValidJamaicaDistribution(path)) {
            String[] foundExtensions;
            String[] foundAdditionals;
            String foundRtJarPath;
            Path source = Path.EMPTY;
            Path packageRoot = Path.ROOT;
            Path rtJAR = Path.EMPTY;
            JamaicaVMDistribution dist = JamaicaVMDistribution.findOrSetup(path);
            URL javadocURL = null;
            try {
                File javadocDir = new File(String.valueOf(dist.getInstallDirectory()) + File.separator + "doc" + File.separator + "jamaica_api");
                if (javadocDir.exists()) {
                    javadocURL = javadocDir.toURI().toURL();
                }
            }
            catch (MalformedURLException mue) {
                LauncherPlugin.log(mue);
            }
            if ((foundRtJarPath = dist.getClassesJar(dist.getHostTarget())) != null) {
                rtJAR = new Path(foundRtJarPath);
                defaultLibLocations.add(new LibraryLocation((IPath)rtJAR, (IPath)source, (IPath)packageRoot, javadocURL));
            }
            String[] stringArray = foundAdditionals = dist.getAdditionalLibraryJARS(dist.getHostTarget());
            int n = foundAdditionals.length;
            int n2 = 0;
            while (n2 < n) {
                String additionalLib = stringArray[n2];
                Path addipath = new Path(additionalLib);
                defaultLibLocations.add(new LibraryLocation((IPath)addipath, (IPath)source, (IPath)packageRoot, javadocURL));
                ++n2;
            }
            String[] stringArray2 = foundExtensions = dist.getExtensionLibraryJARS(dist.getHostTarget());
            int n3 = foundExtensions.length;
            n = 0;
            while (n < n3) {
                String extensionLib = stringArray2[n];
                Path extpath = new Path(extensionLib);
                defaultLibLocations.add(new LibraryLocation((IPath)extpath, (IPath)source, (IPath)packageRoot, null));
                ++n;
            }
        }
        return defaultLibLocations.toArray(new LibraryLocation[0]);
    }

    public String getName() {
        return LaunchingMessages.common_JamaicaVM;
    }

    public IStatus validateInstallLocation(File installLocation) {
        StringBuilder errorDesc;
        Status status = null;
        String path = LauncherPlugin.normalize(installLocation.getAbsolutePath());
        if (!this.isValidJamaicaDistribution(path, errorDesc = new StringBuilder())) {
            if (errorDesc.toString().isEmpty()) {
                errorDesc.append(MessageFormat.format(LaunchingMessages.JamaicaVMType___1__is_not_a_valid_Jamaica_distribution, path));
            }
            status = new Status(4, "com.aicas.jamaica.eclipse.launcher", -1, errorDesc.toString(), null);
        } else {
            status = errorDesc.toString().isEmpty() ? new Status(0, "com.aicas.jamaica.eclipse.launcher", 0, LaunchingMessages.JamaicaVMType_Ok, null) : new Status(1, "com.aicas.jamaica.eclipse.launcher", 0, errorDesc.toString(), null);
        }
        return status;
    }

    public boolean isValidJamaicaDistribution(String path) {
        return this.isValidJamaicaDistribution(path, null);
    }

    public boolean isValidJamaicaDistribution(String path, StringBuilder errorDesc) {
        boolean valid = false;
        JamaicaVMDistribution dist = null;
        if (LauncherPlugin.getDefault() != null && (dist = JamaicaVMDistribution.findOrSetup(path, errorDesc)) != null) {
            int majorVersion;
            valid = dist.isWorkingBuild();
            if (errorDesc != null && errorDesc.toString().isEmpty() && !SUPPORTED_MAJOR_VERSIONS.contains(majorVersion = dist.getVersionMajor())) {
                String errMsg = "Unknown VM major version '" + majorVersion + "'.";
                if (majorVersion > SUPPORTED_MAJOR_VERSIONS.get(SUPPORTED_MAJOR_VERSIONS.size() - 1)) {
                    errMsg = errMsg.concat(" Check for plugin update.");
                }
                errorDesc.append(errMsg);
            }
        }
        return valid;
    }
}

