/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher.wizards;

import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.wizards.AcceleratedJarExportWizardPage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class AcceleratedJarExportWizard
extends Wizard
implements IExportWizard {
    private IStructuredSelection selection;
    private AcceleratedJarExportWizardPage jarAccSetPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        this.setWindowTitle("Accelerated JAR Export");
    }

    public void addPages() {
        this.jarAccSetPage = new AcceleratedJarExportWizardPage(this.selection);
        this.addPage((IWizardPage)this.jarAccSetPage);
    }

    public boolean canFinish() {
        boolean finish = super.canFinish();
        return finish;
    }

    public boolean performFinish() {
        String jarFilename = this.jarAccSetPage.getJarFile();
        if (jarFilename != null && !jarFilename.isEmpty()) {
            Path jarPath = new Path(jarFilename);
            if (!jarPath.isAbsolute()) {
                IPath wspath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                jarPath = wspath.append((IPath)jarPath);
            }
            jarFilename = jarPath.toOSString();
        }
        String jarAccelFilename = null;
        JamaicaVMDistribution distro = this.jarAccSetPage.getDistribution();
        IToolOptions toolOpts = distro.getToolOptions(ToolType.JARACCELERATOR);
        if (toolOpts != null) {
            jarAccelFilename = toolOpts.getToolPath();
        }
        String target = this.jarAccSetPage.getTarget();
        ArrayList<String> jobArgs = new ArrayList<String>();
        jobArgs.add(jarAccelFilename);
        jobArgs.add("-target=" + target);
        jobArgs.add(jarFilename);
        AcceleratorJob job = new AcceleratorJob("Running JAR Accelerator " + distro.getVersion(), jobArgs.toArray(new String[0]));
        job.schedule();
        return true;
    }

    static class AcceleratorJob
    extends Job {
        private String jarFilename;
        private String[] jobArgs;

        AcceleratorJob(String jobname, String[] jobArgs) {
            super(jobname);
            this.jobArgs = jobArgs;
            if (jobArgs.length > 1) {
                this.jarFilename = jobArgs[jobArgs.length - 1];
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            AcceleratorJobException accJobExcep;
            StringBuffer procErrStr;
            int accelExitcode;
            Status result;
            block19: {
                result = null;
                accelExitcode = 0;
                Process proc = null;
                StringBuffer procOutStr = new StringBuffer();
                procErrStr = new StringBuffer();
                try {
                    try {
                        int packageCounter = 1;
                        JarFile jarFile = null;
                        jarFile = new JarFile(this.jarFilename);
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry entry = jarEntries.nextElement();
                            if (!entry.isDirectory()) continue;
                            ++packageCounter;
                        }
                        jarFile.close();
                        monitor.beginTask("Accelerating " + this.jarFilename, packageCounter * 2);
                        proc = Runtime.getRuntime().exec(this.jobArgs);
                        class StreamReader
                        extends Thread {
                            private InputStream is;
                            private StringBuffer sb;
                            private IProgressMonitor mon;
                            private Exception failure = null;

                            public StreamReader(InputStream is, StringBuffer sb, IProgressMonitor m) {
                                this.is = is;
                                this.sb = sb;
                                this.mon = m;
                            }

                            public Exception getFailure() {
                                return this.failure;
                            }

                            public void run() {
                                block15: {
                                    BufferedReader b = new BufferedReader(new InputStreamReader(this.is));
                                    String line = null;
                                    try {
                                        try {
                                            while ((line = b.readLine()) != null) {
                                                this.sb.append(String.valueOf(line) + System.lineSeparator());
                                                if (this.mon == null) continue;
                                                this.mon.worked(1);
                                            }
                                        }
                                        catch (IOException e) {
                                            this.failure = e;
                                            LauncherPlugin.log(e);
                                            if (b == null) break block15;
                                            try {
                                                b.close();
                                            }
                                            catch (IOException e2) {
                                                if (this.failure == null) {
                                                    this.failure = e2;
                                                }
                                                LauncherPlugin.log(e2);
                                            }
                                        }
                                    }
                                    finally {
                                        if (b != null) {
                                            try {
                                                b.close();
                                            }
                                            catch (IOException e) {
                                                if (this.failure == null) {
                                                    this.failure = e;
                                                }
                                                LauncherPlugin.log(e);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        StreamReader stdOutReader = new StreamReader(proc.getInputStream(), procOutStr, monitor);
                        StreamReader stdErrReader = new StreamReader(proc.getErrorStream(), procErrStr, null);
                        stdOutReader.start();
                        stdErrReader.start();
                        boolean procAlive = true;
                        while (!monitor.isCanceled() && procAlive && stdOutReader.getFailure() == null && stdErrReader.getFailure() == null) {
                            try {
                                accelExitcode = proc.exitValue();
                                procAlive = false;
                            }
                            catch (IllegalThreadStateException e) {
                                Thread.sleep(250L);
                            }
                        }
                        if (monitor.isCanceled()) {
                            result = new Status(8, "com.aicas.jamaica.eclipse.launcher", "JAR Accelerator has been cancelled.");
                        } else {
                            if (stdOutReader.getFailure() != null) {
                                throw stdOutReader.getFailure();
                            }
                            if (stdErrReader.getFailure() != null) {
                                throw stdErrReader.getFailure();
                            }
                        }
                    }
                    catch (Exception e) {
                        String msg = "The execution of the JAR Accelerator resulted in an exception.";
                        accJobExcep = new AcceleratorJobException(e);
                        result = new Status(4, "com.aicas.jamaica.eclipse.launcher", msg, (Throwable)accJobExcep);
                        if (proc != null) {
                            proc.destroy();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (proc != null) {
                        proc.destroy();
                    }
                    throw throwable;
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            if (result == null) {
                if (accelExitcode == 0) {
                    result = new Status(0, "com.aicas.jamaica.eclipse.launcher", "Successfully accelerated the selected JAR.");
                } else {
                    String msg = "JAR Accelerator terminated with exitcode: " + accelExitcode;
                    String detailMsg = procErrStr.toString().isEmpty() ? "<no output on stderr>" : procErrStr.toString();
                    accJobExcep = new AcceleratorJobException(detailMsg);
                    result = new Status(4, "com.aicas.jamaica.eclipse.launcher", msg, (Throwable)accJobExcep);
                }
            }
            monitor.done();
            return result;
        }

        class AcceleratorJobException
        extends RuntimeException {
            private static final long serialVersionUID = -807363713926516950L;

            public AcceleratorJobException(String msg) {
                super(msg);
            }

            public AcceleratorJobException(Exception e) {
                super(e);
            }
        }
    }
}

