/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.launcher;

import com.aicas.jamaica.eclipse.core.AbstractJamaicaDistribution;
import com.aicas.jamaica.eclipse.core.IToolOptions;
import com.aicas.jamaica.eclipse.core.ToolType;
import com.aicas.jamaica.eclipse.launcher.JamaicaVMDistribution;
import com.aicas.jamaica.eclipse.launcher.LauncherPlugin;
import com.aicas.jamaica.eclipse.launcher.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JarExportedOptions
implements IToolOptions {
    private String toolClasspath;
    private String toolPath;
    private JamaicaVMDistribution distribution;
    private Class<?> exportedOptionsClass;
    private Class<?> jamaicaOptionClass;
    private Class<?> rangeClass;
    private Class<?> booleanRangeClass;
    private Class<?> listRangeClass;
    private Class<?> stringRangeFromListClass;
    private Class<?> stringRangeFileClass;
    private Class<?> stringRangeDirectoryClass;
    private Class<?> stringRangeSomeFromListClass;
    private Class<?> optionNameClass;
    private Class<? extends Enum<?>> groupClass;
    private Map<String, String> optionTypeToConstantMapping;
    private Method range_acceptsError;
    private Method range_iterator;
    private Method listRange_getSeparators;
    private Method stringRangeFromList_getAcceptableValues;
    private Method jamaicaOption_getOptionName;
    private Method jamaicaOption_getGroup;
    private Method jamaicaOption_getType;
    private Method jamaicaOption_getRange;
    private Method jamaicaOption_getDescr;
    private Method jamaicaOption_getOptionsArgs;
    private Method optionName_getName;
    private Method group_title;
    private Method enum_name;
    private Map<String, IntermediateOption> options;
    private List<String> optionNames;
    private List<String> groupNames;
    private Map<String, Properties> defaultValues;

    public String getArgument(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).argument : null;
    }

    public String getDefaultValue(String optionName, String targetName) {
        if (!this.options.containsKey(optionName)) {
            return null;
        }
        if (optionName.equals("target")) {
            return this.distribution.getHostTarget();
        }
        String t = targetName == null ? this.distribution.getHostTarget() : targetName;
        return this.defaultValues.containsKey(t) ? this.defaultValues.get(t).getProperty(optionName) : null;
    }

    public String getDescription(String optionName, String targetName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).description : null;
    }

    public String getGroup(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).group : null;
    }

    public List<String> getAvailableGroups() {
        return this.groupNames;
    }

    public List<String> getAvailableOptions() {
        return this.optionNames;
    }

    public String getSeparators(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).separators : null;
    }

    public List<String> getOptionEditorArgs(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).settingEditorArgs : null;
    }

    public IToolOptions.EditorType getOptionEditorType(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).settingEditor : null;
    }

    public String getType(String optionName) {
        return this.options.containsKey(optionName) ? this.options.get((Object)optionName).type : null;
    }

    public boolean isAppendable(String optionName) {
        return this.options.containsKey(optionName) ? this.listRangeClass.isInstance(this.options.get((Object)optionName).range) : false;
    }

    public void init(AbstractJamaicaDistribution abstractDist, ToolType tool) {
        block30: {
            if (!(abstractDist instanceof JamaicaVMDistribution)) {
                throw new IllegalArgumentException("Unsupported distribution type: " + abstractDist);
            }
            this.distribution = (JamaicaVMDistribution)abstractDist;
            if (!(ToolType.isJamaica((ToolType)tool) || ToolType.isJamaicah((ToolType)tool) || ToolType.JARACCELERATOR.equals((Object)tool) || ToolType.THREADMONITOR.equals((Object)tool))) {
                throw new IllegalArgumentException(String.valueOf(Messages.JarExportedOptions_Unsupported_tool_type) + ": " + tool);
            }
            String mainBin = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "bin" + File.separator;
            String mainLib = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "lib" + File.separator;
            String exeExt = "";
            String scriptExt = "";
            if (Platform.getOS().equals("win32")) {
                exeExt = ".exe";
                scriptExt = ".cmd";
            }
            switch (tool) {
                case JAMAICA: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicabuilder_bin" + exeExt;
                    break;
                }
                case JAMAICA_INTERNAL: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicabuilder_interpreted" + scriptExt;
                    break;
                }
                case JAMAICAH: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicah_bin" + exeExt;
                    break;
                }
                case JAMAICAH_INTERNAL: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicah_interpreted" + scriptExt;
                    break;
                }
                case JARACCELERATOR: {
                    this.toolPath = String.valueOf(mainBin) + "jamaicajaraccelerator_bin" + exeExt;
                    break;
                }
                case THREADMONITOR: {
                    this.toolPath = String.valueOf(mainLib) + "JamaicaTrace.jar";
                    if (new File(this.toolPath).isFile()) break;
                    this.toolPath = String.valueOf(mainLib) + "ThreadMonitor.jar";
                }
            }
            String string = this.toolPath = new File(this.toolPath).isFile() ? this.toolPath : null;
            if (this.toolPath == null) {
                throw new IllegalStateException("Executable not found for tool: " + tool.toolname());
            }
            boolean isInternal = ToolType.isInternalType((ToolType)tool);
            try {
                if (ToolType.isJamaica((ToolType)tool) || ToolType.isJamaicah((ToolType)tool) || ToolType.JARACCELERATOR.equals((Object)tool)) {
                    Collection<Object> loadedOptions;
                    if (isInternal) {
                        String classesDir = String.valueOf(this.distribution.getClassesDirectory(this.distribution.getHostTarget())) + File.separator;
                        if (classesDir != null) {
                            this.toolClasspath = LauncherPlugin.normalize(classesDir);
                        }
                    } else {
                        this.toolClasspath = LauncherPlugin.normalize(String.valueOf(mainLib) + "JamaicaTools.jar");
                        if (!new File(this.toolClasspath).exists()) {
                            String hostLibJarPath = String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "target" + File.separator + this.distribution.getHostTarget() + File.separator + "lib" + File.separator + "JamaicaTools.jar";
                            this.toolClasspath = LauncherPlugin.normalize(hostLibJarPath);
                        }
                    }
                    URLClassLoader toolClassloader = new URLClassLoader(new URL[]{new File(this.toolClasspath).toURI().toURL()});
                    this.jamaicaOptionClass = toolClassloader.loadClass("com.aicas.jamaica.options.JamaicaOption");
                    this.rangeClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.Range");
                    this.booleanRangeClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.BooleanRange");
                    this.listRangeClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.ListRange");
                    this.stringRangeFromListClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.StringRangeFromList");
                    this.stringRangeFileClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.StringRangeFile");
                    this.stringRangeDirectoryClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.StringRangeDirectory");
                    this.stringRangeSomeFromListClass = toolClassloader.loadClass("com.aicas.jamaica.options.range.StringRangeSomeFromList");
                    this.optionNameClass = toolClassloader.loadClass("com.aicas.jamaica.options.OptionName");
                    this.groupClass = toolClassloader.loadClass("com.aicas.jamaica.options.Group");
                    this.optionTypeToConstantMapping = new HashMap<String, String>(3);
                    this.optionTypeToConstantMapping.put("NORMAL", "normal");
                    this.optionTypeToConstantMapping.put("EXTENDED", "extended");
                    this.optionTypeToConstantMapping.put("INTERNAL", "internal");
                    this.range_acceptsError = this.rangeClass.getMethod("acceptsError", String.class);
                    this.range_iterator = this.rangeClass.getMethod("iterator", new Class[0]);
                    this.listRange_getSeparators = this.listRangeClass.getMethod("getSeparators", new Class[0]);
                    this.stringRangeFromList_getAcceptableValues = this.stringRangeFromListClass.getMethod("getAcceptableValues", new Class[0]);
                    this.jamaicaOption_getOptionName = this.jamaicaOptionClass.getMethod("getOptionName", new Class[0]);
                    this.jamaicaOption_getGroup = this.jamaicaOptionClass.getMethod("getGroup", new Class[0]);
                    this.jamaicaOption_getType = this.jamaicaOptionClass.getMethod("getType", new Class[0]);
                    this.jamaicaOption_getRange = this.jamaicaOptionClass.getMethod("getRange", new Class[0]);
                    this.jamaicaOption_getDescr = this.jamaicaOptionClass.getMethod("getDescr", new Class[0]);
                    this.jamaicaOption_getOptionsArgs = this.jamaicaOptionClass.getMethod("getOptionsArgs", new Class[0]);
                    this.optionName_getName = this.optionNameClass.getMethod("getName", new Class[0]);
                    this.group_title = this.groupClass.getMethod("title", new Class[0]);
                    this.enum_name = Enum.class.getMethod("name", new Class[0]);
                    this.options = new LinkedHashMap<String, IntermediateOption>();
                    if (isInternal) {
                        Class<?> toolClass = toolClassloader.loadClass(tool == ToolType.JAMAICA_INTERNAL ? "jamaica.Builder" : "jamaica.Jamaicah");
                        Object[] objectArray = (Object[])toolClass.getMethod("getPrivateOptionsStatic", new Class[0]).invoke(null, new Object[0]);
                        loadedOptions = Arrays.asList(objectArray);
                    } else {
                        String toolpart = tool.classname();
                        toolpart = toolpart.substring(toolpart.lastIndexOf(46) + 1);
                        toolpart = toolpart.replace("Task", "");
                        String string2 = "com.aicas.jamaica.options.Exported" + toolpart + "Options";
                        this.exportedOptionsClass = toolClassloader.loadClass(string2);
                        Map exportedOptions = (Map)this.exportedOptionsClass.getMethod("getOptions", new Class[0]).invoke(null, new Object[0]);
                        loadedOptions = exportedOptions.values();
                    }
                    this.optionNames = new ArrayList<String>();
                    this.groupNames = new ArrayList<String>();
                    HashSet<String> usedGroupNames = new HashSet<String>();
                    for (Object e : loadedOptions) {
                        IntermediateOption option = new IntermediateOption();
                        option.init(e);
                        this.optionNames.add(option.optionName);
                        this.options.put(option.optionName, option);
                        usedGroupNames.add(option.group);
                    }
                    String string3 = !isInternal ? String.valueOf(tool.name()) + '_' : String.valueOf(tool.name().substring(0, tool.name().indexOf(95))) + '_';
                    Enum<?>[] enumArray = this.groupClass.getEnumConstants();
                    int n = enumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Enum<?> enumConst = enumArray[n2];
                        String title = (String)this.group_title.invoke(enumConst, new Object[0]);
                        String enumConstName = (String)this.enum_name.invoke(enumConst, new Object[0]);
                        if (usedGroupNames.contains(title) && enumConstName.startsWith(string3)) {
                            this.groupNames.add(title);
                        }
                        ++n2;
                    }
                    this.defaultValues = new LinkedHashMap<String, Properties>();
                    if (tool != ToolType.JAMAICA) break block30;
                    for (String curTarget : this.distribution.getAvailableTargets()) {
                        Properties curTargetProperties = new Properties();
                        try {
                            FileInputStream fis = new FileInputStream(String.valueOf(this.distribution.getInstallDirectory()) + File.separator + "target" + File.separator + curTarget + File.separator + "etc" + File.separator + "jamaica.conf");
                            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                            String line = null;
                            do {
                                if ((line = br.readLine()) == null || line.startsWith("#")) continue;
                                int dot = line.indexOf(46);
                                int equal = line.indexOf(61);
                                if (equal <= 0) continue;
                                String curPropValue = line.substring(equal + 1).trim();
                                if (dot < 0 || dot > equal) {
                                    curTargetProperties.put(line.substring(0, equal).trim(), curPropValue);
                                    continue;
                                }
                                curTargetProperties.put(line.substring(0, dot).trim(), curPropValue);
                            } while (line != null);
                        }
                        catch (Exception e) {
                            LauncherPlugin.log(e);
                        }
                        this.defaultValues.put(curTarget, curTargetProperties);
                    }
                    break block30;
                }
                if (ToolType.THREADMONITOR.equals((Object)tool)) {
                    this.toolClasspath = this.toolPath;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public String validate(String optionName, String value) {
        if (!this.options.containsKey(optionName)) {
            return Messages.JarExportedOptions_Unknown_option;
        }
        String valRes = null;
        if ("target".equals(optionName)) {
            if (!this.distribution.getAvailableTargets().contains(value)) {
                valRes = "Platform '" + value + "' is not supported by this Jamaica distribution!";
            }
        } else {
            try {
                valRes = (String)this.range_acceptsError.invoke(this.options.get((Object)optionName).range, value);
            }
            catch (Exception e) {
                LauncherPlugin.log(e);
                valRes = Messages.JarExportedOptions_Validation_failed;
            }
        }
        return valRes;
    }

    public String getToolClasspath() {
        return this.toolClasspath;
    }

    public String getToolPath() {
        return this.toolPath;
    }

    private class IntermediateOption {
        private final Pattern texttt = Pattern.compile("\\\\texttt\\{([^\\}]*)\\}");
        private final Pattern nolinkurl = Pattern.compile("\\\\nolinkurl\\{([^\\}]*)\\}");
        private final Pattern replaceable = Pattern.compile("\\\\replaceable\\{([^\\}]*)\\}");
        private final Pattern system = Pattern.compile("\\\\system\\{([^\\}]*)\\}");
        private final Pattern subsection = Pattern.compile("\\\\subsection\\{([^\\}]*)\\}");
        private final Pattern subsubsection = Pattern.compile("\\\\subsubsection\\{([^\\}]*)\\}");
        private final Pattern emph = Pattern.compile("\\\\emph\\{([^\\}]*)\\}");
        private final Pattern index = Pattern.compile("\\\\index\\{([^\\}]*)\\}");
        private final Pattern begin = Pattern.compile("\\\\begin\\{[^\\}]*\\}");
        private final Pattern end = Pattern.compile("\\\\end\\{[^\\}]*\\}");
        private final Pattern jamaica = Pattern.compile("\\\\(Jamaica)[\\\\]?");
        String optionName;
        String group;
        String type;
        Object range;
        String separators;
        IToolOptions.EditorType settingEditor;
        List<String> settingEditorArgs;
        String description;
        String argument;

        private IntermediateOption() {
        }

        void init(Object exportedOption) throws Exception {
            this.optionName = ((String)JarExportedOptions.this.optionName_getName.invoke(JarExportedOptions.this.jamaicaOption_getOptionName.invoke(exportedOption, new Object[0]), new Object[0])).substring(1);
            this.group = (String)JarExportedOptions.this.group_title.invoke(JarExportedOptions.this.jamaicaOption_getGroup.invoke(exportedOption, new Object[0]), new Object[0]);
            this.type = (String)JarExportedOptions.this.optionTypeToConstantMapping.get(JarExportedOptions.this.enum_name.invoke(JarExportedOptions.this.jamaicaOption_getType.invoke(exportedOption, new Object[0]), new Object[0]));
            this.range = JarExportedOptions.this.jamaicaOption_getRange.invoke(exportedOption, new Object[0]);
            this.determineSeparators();
            this.determineSettingEditor();
            this.determineSettingEditorArgs();
            this.description = (String)JarExportedOptions.this.jamaicaOption_getDescr.invoke(exportedOption, new Object[0]);
            this.argument = (String)JarExportedOptions.this.jamaicaOption_getOptionsArgs.invoke(exportedOption, new Object[0]);
            if (this.argument != null && this.argument.length() == 0) {
                this.argument = null;
            }
            this.purgeMarkup();
        }

        void determineSeparators() throws Exception {
            this.separators = JarExportedOptions.this.listRangeClass.isInstance(this.range) ? (String)JarExportedOptions.this.listRange_getSeparators.invoke(this.range, new Object[0]) : (JarExportedOptions.this.stringRangeSomeFromListClass.isInstance(this.range) ? " " : null);
        }

        void determineSettingEditor() {
            this.settingEditor = this.optionName.equals("agentlib") ? IToolOptions.EditorType.AGENTLIB : (this.optionName.equals("target") ? IToolOptions.EditorType.LIST_SELECTION : (JarExportedOptions.this.booleanRangeClass.isInstance(this.range) ? IToolOptions.EditorType.BOOLEAN : (JarExportedOptions.this.listRangeClass.isInstance(this.range) ? IToolOptions.EditorType.STRING_LIST : (JarExportedOptions.this.stringRangeFromListClass.isInstance(this.range) ? IToolOptions.EditorType.LIST_SELECTION : IToolOptions.EditorType.STRING))));
        }

        void determineSettingEditorArgs() throws Exception {
            if (this.optionName.equals("useProfile")) {
                this.settingEditorArgs = Arrays.asList("file");
            } else if (this.optionName.equals("target")) {
                this.settingEditorArgs = JarExportedOptions.this.distribution.getAvailableTargets();
            } else if (JarExportedOptions.this.stringRangeFileClass.isInstance(this.range)) {
                this.settingEditorArgs = Arrays.asList("file");
            } else if (JarExportedOptions.this.stringRangeDirectoryClass.isInstance(this.range)) {
                this.settingEditorArgs = Arrays.asList("directory");
            } else if (JarExportedOptions.this.listRangeClass.isInstance(this.range)) {
                boolean isFile = false;
                boolean isDirectory = false;
                Iterator iter = (Iterator)JarExportedOptions.this.range_iterator.invoke(this.range, new Object[0]);
                while (iter.hasNext()) {
                    Object subRange = iter.next();
                    if (JarExportedOptions.this.stringRangeFileClass.isInstance(subRange)) {
                        isFile = true;
                        continue;
                    }
                    if (!JarExportedOptions.this.stringRangeDirectoryClass.isInstance(subRange)) continue;
                    isDirectory = true;
                }
                ArrayList<String> listRangeArgs = new ArrayList<String>();
                if (isFile) {
                    listRangeArgs.add("file");
                }
                if (isDirectory) {
                    listRangeArgs.add("directory");
                }
                this.settingEditorArgs = listRangeArgs;
            } else if (JarExportedOptions.this.stringRangeFromListClass.isInstance(this.range)) {
                ArrayList<String> listSelectionRangeArgs = new ArrayList<String>();
                if (JarExportedOptions.this.stringRangeSomeFromListClass.isInstance(this.range)) {
                    listSelectionRangeArgs.add("multi");
                }
                listSelectionRangeArgs.addAll((Set)JarExportedOptions.this.stringRangeFromList_getAcceptableValues.invoke(this.range, new Object[0]));
                this.settingEditorArgs = listSelectionRangeArgs;
            } else {
                this.settingEditorArgs = null;
            }
        }

        void purgeMarkup() {
            StringBuffer buffer;
            Matcher matcher;
            if (this.description == null) {
                return;
            }
            for (Pattern pattern : Arrays.asList(this.replaceable, this.texttt, this.nolinkurl, this.system, this.subsection, this.subsubsection, this.emph, this.index, this.jamaica)) {
                matcher = pattern.matcher(this.description);
                buffer = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(buffer, matcher.group(1));
                }
                matcher.appendTail(buffer);
                this.description = buffer.toString();
            }
            for (Pattern pattern : Arrays.asList(this.begin, this.end)) {
                matcher = pattern.matcher(this.description);
                buffer = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(buffer, " ");
                }
                matcher.appendTail(buffer);
                this.description = buffer.toString();
            }
        }
    }
}

