/*
 * Decompiled with CFR 0.152.
 */
package jamaica;

import jamaica.ParseException;
import java.text.MessageFormat;

public class Parser {
    private Parser() {
    }

    public static final String baseName(String option) {
        if (option.length() > 0 && option.charAt(0) == '-') {
            int pos = option.indexOf(61);
            if (pos != -1) {
                option = option.substring(0, pos);
            }
            if (option.startsWith("-D")) {
                return option;
            }
            pos = option.indexOf(46);
            return pos == -1 ? option : option.substring(0, pos);
        }
        return option;
    }

    public static final String targetName(String option) throws ParseException {
        int length;
        int pos = option.indexOf(61);
        if (pos != -1) {
            option = option.substring(0, pos);
        }
        if ((length = option.length()) == 0 || option.charAt(0) != '-') {
            return null;
        }
        int position = option.indexOf(46);
        if (length <= position) {
            throw new ParseException("Error: invalid option name '" + option + "'");
        }
        if (position == -1) {
            return null;
        }
        String target = option.substring(position + 1, length);
        if (" default".equals(target)) {
            return null;
        }
        return target;
    }

    public static int timeUnit(String s) {
        String validNumberDigits = "-0123456789";
        int z = 0;
        while (z < s.length() && validNumberDigits.indexOf(s.charAt(z)) >= 0) {
            ++z;
        }
        String valueString = s.substring(0, z);
        String unitString = s.substring(z);
        int unitFactor = 1;
        if (unitString.equalsIgnoreCase("s")) {
            unitFactor = 1000000000;
        } else if (unitString.equalsIgnoreCase("ms")) {
            unitFactor = 1000000;
        } else if (unitString.equalsIgnoreCase("us")) {
            unitFactor = 1000;
        } else if (!unitString.equalsIgnoreCase("ns")) {
            unitString.equalsIgnoreCase("");
        }
        return Integer.parseInt(valueString) * unitFactor;
    }

    public static int time(String name, String valueString, String minValueString, String maxValueString, int defaultValue) throws ParseException {
        int value = 0;
        int minValue = Integer.MIN_VALUE;
        int maxValue = Integer.MAX_VALUE;
        if (valueString == null) {
            value = defaultValue;
        } else {
            try {
                value = Parser.timeUnit(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Error parsing time for option '" + name + "' >>" + valueString + "<<");
            }
            try {
                if (minValueString != null) {
                    minValue = Parser.timeUnit(minValueString);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Error parsing min. time for option '" + name + "' >>" + valueString + "<<");
            }
            try {
                if (maxValueString != null) {
                    maxValue = Parser.timeUnit(maxValueString);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Error parsing max. time for option '" + name + "' >>" + valueString + "<<");
            }
        }
        Parser.checkRange(value, minValue, maxValue, name, valueString, minValueString, maxValueString);
        return value;
    }

    public static int kiloMegaGigaStringToInteger(String s) {
        String validNumberDigits = "-0123456789";
        int z = 0;
        while (z < s.length() && validNumberDigits.indexOf(s.charAt(z)) >= 0) {
            ++z;
        }
        String valueString = s.substring(0, z);
        String unitString = s.substring(z);
        int unitFactor = 1;
        if (unitString.equalsIgnoreCase("g")) {
            unitFactor = 0x40000000;
        } else if (unitString.equalsIgnoreCase("m")) {
            unitFactor = 0x100000;
        } else if (unitString.equalsIgnoreCase("k")) {
            unitFactor = 1024;
        } else {
            unitString.equalsIgnoreCase("");
        }
        return Integer.parseInt(valueString) * unitFactor;
    }

    public static int number(String name, String valueString, int minValue, int maxValue, int defaultValue) throws ParseException {
        return Parser.number(name, valueString, Integer.toString(minValue), Integer.toString(maxValue), defaultValue);
    }

    public static int number(String name, String valueString, String minValueString, String maxValueString, int defaultValue) throws ParseException {
        int value = 0;
        int minValue = Integer.MIN_VALUE;
        int maxValue = Integer.MAX_VALUE;
        if (valueString == null) {
            value = defaultValue;
        } else {
            try {
                value = Parser.kiloMegaGigaStringToInteger(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Error parsing integer for option '" + name + "' " + ">>" + valueString + "<<");
            }
            try {
                if (minValueString != null) {
                    minValue = Parser.kiloMegaGigaStringToInteger(minValueString);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Error parsing min. integer for option '" + name + "' " + ">>" + minValueString + "<<");
            }
            try {
                if (maxValueString != null) {
                    maxValue = Parser.kiloMegaGigaStringToInteger(maxValueString);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Error parsing max. integer for option '" + name + "' " + ">>" + maxValueString + "<<");
            }
        }
        Parser.checkRange(value, minValue, maxValue, name, valueString, minValueString, maxValueString);
        return value;
    }

    public static int keyword(String key, String option, String[] keys, int[] values) throws ParseException {
        int index = 0;
        while (index < keys.length) {
            if (key.equals(keys[index])) {
                return values[index];
            }
            ++index;
        }
        String valid = "";
        int z = 0;
        while (z < keys.length) {
            if (!valid.equals("")) {
                valid = valid.concat(", ");
            }
            valid = valid.concat(keys[z]);
            ++z;
        }
        String message = MessageFormat.format("The value ''{0}'' is not valid for option ''{1}''. Valid values: {2}.", key, option, valid);
        throw new ParseException(message);
    }

    private static void checkRange(int value, int minValue, int maxValue, String name, String valueString) throws ParseException {
        Parser.checkRange(value, minValue, maxValue, name, valueString, Integer.toString(minValue), Integer.toString(maxValue));
    }

    private static void checkRange(int value, int minValue, int maxValue, String name, String valueString, String minValueString, String maxValueString) throws ParseException {
        if (value < minValue || value > maxValue) {
            String msg = minValueString == null ? " must be at most " + maxValueString + "!" : (maxValueString == null ? " must be at least " + minValueString + "!" : " out of allowed range " + minValueString + ".." + maxValueString + "!");
            throw new ParseException("Integer argument '" + name + " >>" + valueString + "<<'" + msg);
        }
    }

    public static String filter_atDEFAULTat(String s, String entry, String defaultValue, boolean fillIn) {
        int posOfDefault;
        while ((posOfDefault = s.indexOf("@DEFAULT@")) != -1) {
            s = String.valueOf(s.substring(0, posOfDefault)) + (fillIn ? "(default: " + (defaultValue == null ? "not used." : defaultValue) + ")" : "") + s.substring(posOfDefault + 9);
        }
        while ((posOfDefault = s.indexOf("@DEFAULT:")) != -1) {
            String rs = s.substring(0, posOfDefault);
            int p2def = s.indexOf(64, posOfDefault + 1);
            s = String.valueOf(rs) + (fillIn ? "(default: " + s.substring(posOfDefault + 9, p2def) + ")" : "") + s.substring(p2def + 1);
        }
        return s;
    }
}

