/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.range;

import com.aicas.jamaica.range.Range;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class StringRange
extends Range {
    private int type;
    private String suffix;
    private String[] rangeTypes = new String[]{"ANY_STRING", "VALID_PATH", "VALID_PATHS", "ANY_FILE", "EXISTING_FILE", "EXISTING_FILES", "ANY_DIRECTORY", "EXISTING_DIRECTORY", "EXISTING_DIRECTORIES", "CLASS_NAME", "CLASS_NAMES", "A_METHOD", "ENVIRONMENT_VARIABLE", "IS_NULL_STRING", "A_COMMAND", "VALID_TARGET"};
    public static final int ANY_STRING = 0;
    public static final int VALID_PATH = 1;
    public static final int VALID_PATHS = 2;
    public static final int ANY_FILE = 3;
    public static final int EXISTING_FILE = 4;
    public static final int EXISTING_FILES = 5;
    public static final int ANY_DIRECTORY = 6;
    public static final int EXISTING_DIRECTORY = 7;
    public static final int EXISTING_DIRECTORIES = 8;
    public static final int CLASS_NAME = 9;
    public static final int CLASS_NAMES = 10;
    public static final int A_METHOD = 11;
    public static final int ENVIRONMENT_VARIABLE = 12;
    public static final int IS_NULL_STRING = 13;
    public static final int A_COMMAND = 14;
    public static final int VALID_TARGET = 15;
    public static final int INPUT_DIALOG = 0;
    public static final int FILE_DIALOG = 1;
    public static final int DIRECTORY_DIALOG = 2;
    public static final int CLASS_BROWSER = 3;

    public StringRange(int type) {
        this(type, null);
    }

    public StringRange(int type, String suffix) {
        this.type = type;
        this.suffix = suffix;
    }

    public int getDialogID() {
        int id = 0;
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                id = 1;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                id = 2;
                break;
            }
            case 9: 
            case 10: {
                id = 3;
                break;
            }
            default: {
                id = 0;
            }
        }
        return id;
    }

    public boolean isListOption() {
        boolean bool = true;
        switch (this.type) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                bool = false;
                break;
            }
            default: {
                bool = true;
            }
        }
        return bool;
    }

    public String toString() {
        String typeString = this.rangeTypes[this.type];
        if (this.suffix != null) {
            return "StringRange(StringRange." + typeString + ", \"" + this.suffix + "\")";
        }
        return "StringRange(StringRange." + typeString + ")";
    }

    public boolean accepts(String value) {
        boolean bool = true;
        switch (this.type) {
            case 2: {
                bool = true;
                StringTokenizer argumentTokens = new StringTokenizer(value, File.pathSeparator, false);
                while (argumentTokens.hasMoreTokens() && bool) {
                    try {
                        bool = new File(argumentTokens.nextToken()).exists();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                break;
            }
            case 3: {
                bool = !new File(value).isDirectory();
                break;
            }
            case 4: {
                bool = new File(value).isFile();
                if (!bool || this.suffix == null || !value.endsWith(this.suffix) && !value.endsWith(this.suffix.toUpperCase())) break;
                bool = true;
                break;
            }
            case 5: {
                bool = true;
                value = value.replace(' ', File.pathSeparatorChar);
                StringTokenizer argumentTokens = new StringTokenizer(value, File.pathSeparator, false);
                while (argumentTokens.hasMoreTokens() && bool) {
                    try {
                        bool = new File(argumentTokens.nextToken()).isFile();
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                break;
            }
            case 6: {
                bool = !new File(value).isFile();
                break;
            }
            case 7: {
                bool = new File(value).exists() && new File(value).isDirectory();
                break;
            }
            case 8: {
                bool = true;
                String specialDir = String.valueOf(File.separator) + "usr";
                value = value.replace(' ', File.pathSeparatorChar);
                StringTokenizer argumentTokens = new StringTokenizer(value, File.pathSeparator, false);
                while (argumentTokens.hasMoreTokens() && bool) {
                    try {
                        String token = argumentTokens.nextToken();
                        bool = new File(token).isDirectory();
                        if (!token.startsWith(specialDir) && !token.startsWith("${")) continue;
                        bool = true;
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                break;
            }
            case 9: {
                int dot = value.indexOf(46);
                int bropen = value.indexOf(40);
                int brclose = value.indexOf(41);
                bool = dot < 0 && bropen < 0 && brclose < 0;
                break;
            }
            case 10: {
                break;
            }
            case 0: {
                bool = true;
                break;
            }
            case 11: {
                int dot = value.indexOf(46);
                int bropen = value.indexOf(40);
                int brclose = value.indexOf(41);
                bool = dot > 0 && bropen > dot && brclose > bropen && dot == value.lastIndexOf(46) && bropen == value.lastIndexOf(40) && brclose == value.lastIndexOf(41) && value.substring(brclose + 1).length() > 0;
                break;
            }
            case 12: {
                bool = true;
                break;
            }
            case 13: {
                bool = value.length() == 0;
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
        }
        return bool;
    }
}

