/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.range;

import com.aicas.jamaica.range.Range;

public class IntegerRange
extends Range {
    private int min;
    private int max;
    private int multipleOf;

    public IntegerRange(int min, int max, int multipleOf) {
        this.min = min;
        this.max = max;
        this.multipleOf = multipleOf;
    }

    public IntegerRange(int min, int max) {
        this(min, max, 1);
    }

    public IntegerRange(int min, Integer max) {
        this(new Integer(min), max, 1);
    }

    public IntegerRange(Integer min, int max) {
        this(min, new Integer(max), 1);
    }

    public IntegerRange(Integer min, Integer max, int multipleOf) {
        this.min = min == null ? Integer.MIN_VALUE : min;
        this.max = max == null ? Integer.MAX_VALUE : max;
        this.multipleOf = multipleOf;
    }

    public String toString() {
        return "IntegerRange(" + this.min + ", " + this.max + ", " + this.multipleOf + ")";
    }

    public boolean accepts(int value) {
        return this.min <= value && value <= this.max && value % this.multipleOf == 0;
    }
}

