/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.ui.OptionEditDialog;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import com.aicas.jamaica.range.Range;
import com.aicas.jamaica.range.StringRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VisualTextOption
extends VisualOption
implements ModifyListener {
    private Text text;
    private Label label;
    private Option option;
    private Composite radioButtons;
    private Button editButton;
    private OptionEditDialog editDialog;
    private String cache = "";

    public VisualTextOption(Option option, Composite parent, int tabType, VisualTarget visualTarget) {
        super(option, parent, tabType, visualTarget);
        this.option = option;
        this.editDialog = new OptionEditDialog(new Shell(16), this);
        while (this.getFreeComposites() < 3 && this.getFreeComposites() > 0) {
            this.createEmptyComposite(parent);
        }
        this.radioButtons = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.radioButtons.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        this.radioButtons.setLayoutData((Object)gridData);
        this.addContextHelp((Control)this.radioButtons);
        this.onRadio = new Button(this.radioButtons, 16400);
        this.onRadio.setText("on");
        this.onRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (VisualTextOption.this.canBeGlobal()) {
                    if (VisualTextOption.this.cache.equals("[from global]")) {
                        VisualTextOption.this.setValue("");
                    } else {
                        VisualTextOption.this.setValue(VisualTextOption.this.cache);
                    }
                }
                VisualTextOption.this.setState("on");
                VisualTextOption.this.widgetSelectionHandler(evt);
            }
        });
        this.offRadio = new Button(this.radioButtons, 16400);
        this.offRadio.setText("off");
        this.offRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (VisualTextOption.this.canBeGlobal()) {
                    VisualTextOption.this.setValue(VisualTextOption.this.cache);
                }
                VisualTextOption.this.setState("off");
                VisualTextOption.this.widgetSelectionHandler(evt);
            }
        });
        if (this.getTabType() != VisualTarget.GLOBAL) {
            this.globalRadio = new Button(this.radioButtons, 16400);
            this.globalRadio.setText("global");
            this.globalRadio.setToolTipText(JamaicaPlugin.getResourceString("Global_ToolTip"));
            this.globalRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    VisualTextOption.this.setState("global");
                    VisualTextOption.this.widgetSelectionHandler(evt);
                }
            });
            if (this.canBeGlobal()) {
                this.globalRadio.setVisible(true);
            } else {
                this.globalRadio.setVisible(false);
            }
        }
        this.label = new Label(this.radioButtons, 0);
        try {
            FontData fd = this.label.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.label.setFont(new Font((Device)this.radioButtons.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        GridData labelGridData = new GridData();
        labelGridData.grabExcessHorizontalSpace = false;
        labelGridData.horizontalAlignment = 3;
        this.label.setText(option.getName());
        this.label.setLayoutData((Object)labelGridData);
        Composite optionComposite = new Composite(parent, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        optionComposite.setLayout((Layout)gridLayout);
        gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        optionComposite.setLayoutData((Object)gridData);
        this.addContextHelp((Control)optionComposite);
        this.text = new Text(optionComposite, 2052);
        GridData textDataLayout = new GridData(768);
        textDataLayout.grabExcessHorizontalSpace = true;
        textDataLayout.widthHint = 1;
        this.text.setLayoutData((Object)textDataLayout);
        this.editButton = new Button(optionComposite, 0);
        this.editButton.setText("...");
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                VisualTextOption.this.editDialog.open();
                VisualTextOption.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void updateLaunchConfigurationDialog() {
        this.visualTarget.updateLaunchConfigurationDialog();
    }

    private void widgetSelectionHandler(SelectionEvent evt) {
        if (evt.widget != null && ((Button)evt.widget).isFocusControl()) {
            this.checkOptionSelections();
            this.updateDependendOptions();
            this.updateLaunchConfigurationDialog();
        }
    }

    public boolean withIn(Range range) {
        String value = this.replaceSystemProperty(this.text.getText(), "${jamaica.home}", JamaicaPlugin.getDefault().getPreferenceStore().getString("JamaicaHome"));
        String projectPath = "";
        ILaunchConfigurationWorkingCopy wc = JavaProjectTypes.getCurrentConfig();
        if (wc != null) {
            try {
                projectPath = JavaProjectTypes.getCurrentConfig().getAttribute("@projectPath", "");
            }
            catch (CoreException coreException) {
                System.err.println("Jamaica Plugin: Error getting Attribute @projectPath");
            }
            value = this.replaceSystemProperty(value, "${jamaica.project}", projectPath);
            return ((StringRange)range).accepts(value);
        }
        return true;
    }

    private String replaceSystemProperty(String str, String pattern, String replace) {
        int s = 0;
        int e = 0;
        StringBuffer result = new StringBuffer();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public String getValue() {
        return this.text.getText();
    }

    public void setValue(String val) {
        if (!val.equals("[from global]") && this.canBeGlobal()) {
            this.cache = val;
        }
        this.text.removeModifyListener((ModifyListener)this);
        this.text.setText(val);
        this.text.addModifyListener((ModifyListener)this);
    }

    public void updateView() {
        if (this.option.getDependency().fulfilled()) {
            this.setRadioButtonsEnabled(true);
            if (this.getState() == "on") {
                this.text.setEnabled(true);
                this.editButton.setEnabled(true);
            }
        } else {
            this.text.setEnabled(false);
            this.editButton.setEnabled(false);
            this.setRadioButtonsEnabled(false);
        }
    }

    public void clear() {
        this.text.setText("");
        this.setState("off");
    }

    public String getState() {
        if (this.onRadio.getSelection()) {
            return "on";
        }
        if (this.offRadio.getSelection()) {
            return "off";
        }
        if (this.globalRadio != null && this.globalRadio.getSelection()) {
            return "global";
        }
        return "off";
    }

    public void initialize(String value, String state) {
        this.setValue(value);
        this.initState(state);
    }

    private void initState(String state) {
        this.onRadio.setSelection(false);
        this.offRadio.setSelection(false);
        if (this.globalRadio != null && this.canBeGlobal()) {
            this.globalRadio.setSelection(false);
        }
        if (state.equals("on")) {
            this.onRadio.setSelection(true);
            this.setState("on");
        } else if (state.equals("off")) {
            this.offRadio.setSelection(true);
            this.setState("off");
        } else if (this.globalRadio != null && state.equals("global") && this.canBeGlobal()) {
            this.globalRadio.setSelection(true);
            this.setState("global");
        } else {
            this.offRadio.setSelection(true);
            this.setState("off");
        }
    }

    private void setState(String newState) {
        if (newState.equals("on")) {
            this.text.setEnabled(true);
            this.text.setEditable(true);
            this.editButton.setEnabled(true);
        } else if (newState.equals("off")) {
            this.text.setEnabled(false);
            this.editButton.setEnabled(false);
        } else if (newState.equals("global") && this.globalRadio != null && this.canBeGlobal()) {
            this.setValue("[from global]");
            this.text.setEnabled(true);
            this.text.setEditable(false);
            this.editButton.setEnabled(false);
        } else {
            this.setState("off");
        }
        this.updateDependendOptions();
    }

    public String validate() {
        if (this.getState().equals("on") && this.getValue().length() > 0 && this.text.isEnabled() && !this.withIn(this.option.getRange())) {
            return "invalid data";
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        if (this.canBeGlobal()) {
            this.cache = this.getValue();
        }
        this.updateDependendOptions();
        this.updateLaunchConfigurationDialog();
    }
}

