/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JamaicaConfSettings;
import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.options.BuilderOptions;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualOptionsGroup;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

public class VisualTarget
extends AbstractLaunchConfigurationTab {
    public static int GLOBAL = 0;
    public static int TARGET = 1;
    public static boolean NEEDS_VALIDATION = true;
    private int tabType;
    private String targetName;
    private TabFolder targetTabFolder;
    private ArrayList visualOptionsGroups;
    private JamaicaConfSettings defaults = new JamaicaConfSettings();

    public VisualTarget(JamaicaConfSettings defaults, int tabType, String tabName) {
        this.defaults = defaults;
        this.tabType = tabType;
        this.targetName = tabName;
    }

    public void createControl(Composite parent) {
        VisualOption visualoption;
        String key;
        Composite wrappedParent = new Composite(parent, 0);
        wrappedParent.setLayout((Layout)new FillLayout());
        wrappedParent.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)wrappedParent);
        this.targetTabFolder = new TabFolder(wrappedParent, 0);
        this.visualOptionsGroups = BuilderOptions.mkOptionsPage(parent, this, this.tabType);
        Hashtable<String, VisualOption> optionPool = new Hashtable<String, VisualOption>();
        Iterator groupItr = this.visualOptionsGroups.iterator();
        while (groupItr.hasNext()) {
            VisualOptionsGroup visualOptionsGroup = (VisualOptionsGroup)groupItr.next();
            visualOptionsGroup.setTabType(this.tabType);
            Hashtable options = visualOptionsGroup.getOptions();
            Iterator it = options.keySet().iterator();
            while (it.hasNext()) {
                String key2 = (String)it.next();
                VisualOption visualOption = (VisualOption)options.get(key2);
                optionPool.put(key2, visualOption);
            }
        }
        Iterator it = optionPool.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            visualoption = (VisualOption)optionPool.get(key);
            visualoption.getOption().getDependency().setOption(optionPool, visualoption.getOption().getName());
        }
        it = optionPool.keySet().iterator();
        while (it.hasNext()) {
            key = (String)it.next();
            visualoption = (VisualOption)optionPool.get(key);
            visualoption.updateView();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy wc) {
        JavaProjectTypes.setCurrentConfig(wc);
        wc.setAttributes(this.defaults.getDefaultsMap());
        wc.setAttribute("@directExecute", false);
        JavaProjectTypes javaProjectTypes = new JavaProjectTypes();
        javaProjectTypes.initializeProjectTypes(wc);
        String name = "";
        String mainClass = "";
        String target = "";
        try {
            mainClass = wc.getAttribute("@mainClassName", "New_configuration");
            if (mainClass.equals("")) {
                mainClass = "Application";
            }
            target = wc.getAttribute("target", "host");
            name = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(String.valueOf(mainClass) + " for " + target);
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error reading attribute of main class");
        }
        if (name.equals("")) {
            name = "New_configuration";
        }
        wc.rename(name);
    }

    public void initializeFrom(ILaunchConfiguration launchConfig) {
        try {
            JavaProjectTypes.setCurrentConfig(launchConfig.getWorkingCopy());
        }
        catch (CoreException coreException) {
            System.err.println("Jamaica Plugin: Error getting working copy of launch configuration");
        }
        Iterator groupItr = this.visualOptionsGroups.iterator();
        while (groupItr.hasNext()) {
            VisualOptionsGroup visualOptionsGroup = (VisualOptionsGroup)groupItr.next();
            Hashtable options = visualOptionsGroup.getOptions();
            Iterator it = options.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                VisualOption visualOption = (VisualOption)options.get(key);
                if (this.targetName.equals("global")) {
                    try {
                        if (visualOption.getTabType() == GLOBAL) {
                            visualOptionsGroup.setMainText(launchConfig.getAttribute("@mainClassName", ""));
                            visualOptionsGroup.setProjectText(launchConfig.getAttribute("@projectName", ""));
                            visualOptionsGroup.setTargetSelection(launchConfig.getAttribute("target", ""));
                            visualOptionsGroup.setDirectExecuteCheck(launchConfig.getAttribute("@directExecute", false));
                        }
                        visualOption.initialize(this.defaults.getAttribute(key), launchConfig.getAttribute(String.valueOf(key) + "_state", "off"));
                        visualOption.initialize(launchConfig.getAttribute(key, ""), launchConfig.getAttribute(String.valueOf(key) + "_state", "off"));
                    }
                    catch (CoreException coreException) {
                        System.err.println("Jamaica Plugin: Error loading values from launch config");
                    }
                    continue;
                }
                try {
                    visualOption.initialize(this.defaults.getAttribute(key), launchConfig.getAttribute(String.valueOf(key) + "_state", "global"));
                    visualOption.initialize(launchConfig.getAttribute(String.valueOf(key) + "." + this.targetName, ""), launchConfig.getAttribute(String.valueOf(key) + "." + this.targetName + "_state", "global"));
                }
                catch (CoreException coreException) {
                    System.err.println("Jamaica Plugin: Error loading values from launch config");
                }
            }
        }
        NEEDS_VALIDATION = true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy wc) {
        JavaProjectTypes.setCurrentConfig(wc);
        Iterator groupItr = this.visualOptionsGroups.iterator();
        while (groupItr.hasNext()) {
            VisualOptionsGroup visualOptionsGroup = (VisualOptionsGroup)groupItr.next();
            Hashtable options = visualOptionsGroup.getOptions();
            Iterator it = options.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                VisualOption visualOption = (VisualOption)options.get(key);
                if (this.targetName.equals("global")) {
                    if (visualOption.getTabType() == GLOBAL) {
                        wc.setAttribute("@mainClassName", visualOptionsGroup.getMainText());
                        wc.setAttribute("@projectName", visualOptionsGroup.getProjectText());
                        wc.setAttribute("target", visualOptionsGroup.getTargetSelection());
                        wc.setAttribute("@directExecute", visualOptionsGroup.getDirectExecuteCheck());
                    }
                    wc.setAttribute(String.valueOf(key) + "_state", visualOption.getState());
                    wc.setAttribute(key, visualOption.getValue());
                    continue;
                }
                wc.setAttribute(String.valueOf(key) + "." + this.targetName + "_state", visualOption.getState());
                wc.setAttribute(String.valueOf(key) + "." + this.targetName, visualOption.getValue());
            }
        }
    }

    public void updateLaunchConfigurationDialog() {
        NEEDS_VALIDATION = true;
        this.getLaunchConfigurationDialog().updateButtons();
    }

    public String getName() {
        return this.targetName;
    }

    public TabFolder getTabFolder() {
        return this.targetTabFolder;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (NEEDS_VALIDATION) {
            NEEDS_VALIDATION = false;
            String errorDetails = "";
            if (this.targetName.equals("global")) {
                if (VisualOptionsGroup.getMainComposite().getProjectText().length() < 1) {
                    this.setErrorMessage("No Java project selected.");
                    this.getLaunchConfigurationDialog().updateMessage();
                    return false;
                }
                if (VisualOptionsGroup.getMainComposite().getProjectText().indexOf(" ") != -1) {
                    this.setErrorMessage("Java projects to be used with Jamaica must not contain spaces in the project name");
                    this.getLaunchConfigurationDialog().updateMessage();
                    return false;
                }
                if (VisualOptionsGroup.getMainComposite().getMainText().length() < 1) {
                    this.setErrorMessage("No main class specified.");
                    this.getLaunchConfigurationDialog().updateMessage();
                    return false;
                }
            }
            Iterator groupItr = this.visualOptionsGroups.iterator();
            while (groupItr.hasNext()) {
                VisualOptionsGroup visualOptionsGroup;
                VisualOptionsGroup optionGroupWithError = visualOptionsGroup = (VisualOptionsGroup)groupItr.next();
                Hashtable options = visualOptionsGroup.getOptions();
                Iterator it = options.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    VisualOption visualOption = (VisualOption)options.get(key);
                    if (visualOption == null || (errorDetails = visualOption.validate()) == null) continue;
                    this.setErrorMessage("Tab '" + optionGroupWithError.getTabItem().getText() + "' ,Option '" + visualOption.getOption().getName() + "': " + errorDetails);
                    this.getLaunchConfigurationDialog().updateMessage();
                    return false;
                }
            }
            this.setErrorMessage(null);
            this.getLaunchConfigurationDialog().updateMessage();
            return true;
        }
        return true;
    }
}

