/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.ui.GeneralMainComposite;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import java.util.AbstractCollection;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class VisualOptionsGroup {
    private int tabType;
    private TabItem tabItem;
    private String groupName;
    private TabFolder targetTab;
    private Hashtable options = new Hashtable();
    private static GeneralMainComposite mainComposite;

    public VisualOptionsGroup(AbstractCollection opts, VisualTarget target, int tabType, String groupName) {
        this.tabType = tabType;
        this.groupName = groupName;
        this.targetTab = target.getTabFolder();
        Composite wrappedParent = new Composite((Composite)this.targetTab, 0);
        wrappedParent.setLayout((Layout)new GridLayout());
        wrappedParent.setLayoutData((Object)new GridData(1808));
        this.tabItem = new TabItem(this.targetTab, 0);
        this.tabItem.setText(groupName);
        this.tabItem.setControl((Control)wrappedParent);
        ScrolledComposite sc = new ScrolledComposite(wrappedParent, 768);
        sc.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite((Composite)sc, 0);
        sc.setContent((Control)composite);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (groupName.equals("General") && tabType == VisualTarget.GLOBAL) {
            mainComposite = new GeneralMainComposite(composite, target);
            mainComposite.createControl();
        }
        VisualOption.setFreeComposites(3);
        Iterator it = opts.iterator();
        while (it.hasNext()) {
            VisualOption opt;
            Option op = (Option)it.next();
            if (tabType == VisualTarget.GLOBAL && (op.getTargetOrGlobal().equals("GLOBAL") || op.getTargetOrGlobal().equals("TARGET_OR_GLOBAL"))) {
                opt = VisualOption.newInstance(op, composite, VisualTarget.GLOBAL, target);
                this.options.put(op.getName(), opt);
                if (op.getName().equals("classpath")) {
                    mainComposite.setClasspathText(opt);
                    continue;
                }
                if (!op.getName().equals("destination")) continue;
                mainComposite.setDestinationText(opt);
                continue;
            }
            if (tabType != VisualTarget.TARGET || !op.getTargetOrGlobal().equals("TARGET") && !op.getTargetOrGlobal().equals("TARGET_OR_GLOBAL")) continue;
            opt = VisualOption.newInstance(op, composite, VisualTarget.TARGET, target);
            this.options.put(op.getName(), opt);
        }
        if (groupName.equals("General")) {
            if (tabType == VisualTarget.GLOBAL) {
                new Label(composite, 0);
                new Label(composite, 0);
            }
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            Label note = new Label(composite, 0);
            note.setLayoutData((Object)gridData);
            note.setText(JamaicaPlugin.getResourceString("Notes"));
        }
        Point minSize = composite.computeSize(-1, -1);
        sc.setExpandVertical(true);
        sc.setMinWidth(minSize.x);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(minSize.y);
    }

    public Hashtable getOptions() {
        return this.options;
    }

    public void setTabType(int type) {
        this.tabType = type;
    }

    public TabItem getTabItem() {
        return this.tabItem;
    }

    public String getMainText() {
        return mainComposite.getMainText();
    }

    public String getProjectText() {
        return mainComposite.getProjectText();
    }

    public void setMainText(String val) {
        mainComposite.setMainText(val);
    }

    public void setProjectText(String val) {
        mainComposite.setProjectText(val);
    }

    public String getTargetSelection() {
        return mainComposite.getTargetSelection();
    }

    public void setTargetSelection(String val) {
        mainComposite.setTargetSelection(val);
    }

    public boolean getDirectExecuteCheck() {
        return mainComposite.getDirectExecuteCheck();
    }

    public void setDirectExecuteCheck(boolean b) {
        mainComposite.setDirectExecuteCheck(b);
    }

    public void setLaunchConfigName(boolean doSave) {
        mainComposite.setLaunchConfigName(doSave);
    }

    public static GeneralMainComposite getMainComposite() {
        return mainComposite;
    }
}

