/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.JamaicaPlugin;
import com.aicas.jamaica.eclipse.JavaProjectTypes;
import com.aicas.jamaica.eclipse.options.BooleanOption;
import com.aicas.jamaica.eclipse.options.IntegerOption;
import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.options.StringOption;
import com.aicas.jamaica.eclipse.ui.VisualBooleanOption;
import com.aicas.jamaica.eclipse.ui.VisualComboOption;
import com.aicas.jamaica.eclipse.ui.VisualIntegerOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import com.aicas.jamaica.eclipse.ui.VisualTextOption;
import com.aicas.jamaica.range.Range;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.dialogs.MessageDialogWithToggle;

public abstract class VisualOption {
    private Composite parent;
    private int tabType;
    protected Option option;
    protected ArrayList dependendOptions = new ArrayList();
    protected VisualTarget visualTarget;
    private static int freeComposites = 3;
    public static final String ON = "on";
    public static final String OFF = "off";
    public static final String GLOBAL = "global";
    public static final String FROMGLOBAL = "[from global]";
    protected Button globalRadio;
    protected Button onRadio;
    protected Button offRadio;

    protected VisualOption(Option option, Composite parent, int tabType, VisualTarget visualTarget) {
        this.option = option;
        this.parent = parent;
        this.tabType = tabType;
        this.visualTarget = visualTarget;
    }

    public static VisualOption newInstance(Option option, Composite parent, int tabType, VisualTarget visualTarget) {
        if (freeComposites <= 0) {
            freeComposites = 3;
        }
        if (option instanceof BooleanOption) {
            --freeComposites;
            return new VisualBooleanOption(option, parent, tabType, visualTarget);
        }
        if (option instanceof StringOption) {
            if (option.getName().equals("XobjectFormat")) {
                --freeComposites;
                return new VisualComboOption(option, new String[]{"none", "ELF"}, parent, tabType, visualTarget);
            }
            if (option.getName().equals("XobjectGenerateCode")) {
                --freeComposites;
                return new VisualComboOption(option, new String[]{"C", "i386", "i486", "i586", "sparc"}, parent, tabType, visualTarget);
            }
            if (option.getName().equals("XlinkStatic")) {
                --freeComposites;
                return new VisualComboOption(option, new String[]{"none", "jamaica", "system", "all"}, parent, tabType, visualTarget);
            }
            if (option.getName().equals("optimise")) {
                --freeComposites;
                return new VisualComboOption(option, new String[]{"none", "size", "speed", "all"}, parent, tabType, visualTarget);
            }
            return new VisualTextOption(option, parent, tabType, visualTarget);
        }
        if (option instanceof IntegerOption) {
            --freeComposites;
            return new VisualIntegerOption(option, parent, tabType, visualTarget);
        }
        return null;
    }

    public void addDependendChild(VisualOption option) {
        this.dependendOptions.add(option);
    }

    protected void addContextHelp(Control control) {
        WorkbenchHelp.setHelp((Control)control, (String)("com.aicas.jamaica.eclipse." + this.option.getName()));
    }

    public Option getOption() {
        return this.option;
    }

    public void setTabType(int type) {
        this.tabType = type;
    }

    public int getTabType() {
        return this.tabType;
    }

    public boolean canBeGlobal() {
        return this.option.getTargetOrGlobal().equals("TARGET_OR_GLOBAL");
    }

    public static void setFreeComposites(int num) {
        freeComposites = num;
    }

    protected int getFreeComposites() {
        return freeComposites;
    }

    protected Label createEmptyComposite(Composite parent) {
        if (--freeComposites < 0) {
            freeComposites = 3;
        }
        return new Label(parent, 0);
    }

    protected void updateDependendOptions() {
        Iterator itr = this.dependendOptions.iterator();
        while (itr.hasNext()) {
            ((VisualOption)itr.next()).updateView();
        }
    }

    public abstract boolean withIn(Range var1);

    public abstract void initialize(String var1, String var2);

    public abstract void setValue(String var1);

    public abstract String getValue();

    public abstract String getState();

    public abstract void updateView();

    public abstract void clear();

    public abstract String validate();

    protected void setRadioButtonsEnabled(boolean b) {
        this.onRadio.setEnabled(b);
        this.offRadio.setEnabled(b);
        if (this.globalRadio != null) {
            this.globalRadio.setEnabled(b);
        }
    }

    protected void checkOptionSelections() {
        if (this.tabType == VisualTarget.GLOBAL) {
            String prefKey;
            IPreferenceStore store;
            boolean promptForHint;
            ILaunchConfigurationWorkingCopy wc = JavaProjectTypes.getCurrentConfig();
            String optionTarget = null;
            String target = "host";
            try {
                target = wc.getAttribute("target", "host");
                optionTarget = wc.getAttribute(String.valueOf(this.getOption().getName()) + "." + target + "_state", null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (optionTarget != null && !optionTarget.equals(GLOBAL) && (promptForHint = (store = JamaicaPlugin.getDefault().getPreferenceStore()).getBoolean(prefKey = "GLOBAL_OPTION_HINT_SHOW_PROMPT"))) {
                String message = JamaicaPlugin.getResourceString("Prompt_HintAboutGlobalOptions");
                MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)new Shell(), (String)"Global and Target Options", (String)message, (String)"Do not show this dialog again", (boolean)false);
                store.setValue(prefKey, !dialog.getToggleState());
            }
        }
    }
}

