/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import com.aicas.jamaica.range.IntegerRange;
import com.aicas.jamaica.range.Range;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.help.WorkbenchHelp;

public class VisualIntegerOption
extends VisualOption
implements ModifyListener,
VerifyListener {
    private Text text;
    private Group radioButtons;
    private Composite parent;
    private String cache = "";

    public VisualIntegerOption(Option option, Composite parent, int tabType, VisualTarget visualTarget) {
        super(option, parent, tabType, visualTarget);
        this.parent = parent;
        this.radioButtons = new Group(parent, 0);
        try {
            FontData fd = this.radioButtons.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.radioButtons.setFont(new Font((Device)this.radioButtons.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.radioButtons.setText(option.getName());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.radioButtons.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.radioButtons.setLayoutData((Object)gridData);
        this.addContextHelp((Control)this.radioButtons);
        this.onRadio = new Button((Composite)this.radioButtons, 16400);
        this.onRadio.setText("on");
        this.onRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (VisualIntegerOption.this.canBeGlobal()) {
                    if (VisualIntegerOption.this.cache.equals("[from global]")) {
                        VisualIntegerOption.this.setValue("");
                    } else {
                        VisualIntegerOption.this.setValue(VisualIntegerOption.this.cache);
                    }
                }
                VisualIntegerOption.this.setState("on");
                VisualIntegerOption.this.widgetSelectionHandler(evt);
            }
        });
        this.offRadio = new Button((Composite)this.radioButtons, 16400);
        this.offRadio.setText("off");
        this.offRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                if (VisualIntegerOption.this.canBeGlobal()) {
                    VisualIntegerOption.this.setValue(VisualIntegerOption.this.cache);
                }
                VisualIntegerOption.this.setState("off");
                VisualIntegerOption.this.widgetSelectionHandler(evt);
            }
        });
        if (this.getTabType() != VisualTarget.GLOBAL) {
            this.globalRadio = new Button((Composite)this.radioButtons, 16400);
            this.globalRadio.setText("global");
            this.globalRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    VisualIntegerOption.this.setState("global");
                    VisualIntegerOption.this.widgetSelectionHandler(evt);
                }
            });
            if (this.canBeGlobal()) {
                this.globalRadio.setVisible(true);
            } else {
                this.globalRadio.setVisible(false);
            }
        }
        this.text = new Text((Composite)this.radioButtons, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.text.setLayoutData((Object)gridData);
        WorkbenchHelp.setHelp((Control)this.text, (String)("com.aicas.jamaica.eclipse." + option.getName()));
    }

    private void updateLaunchConfigurationDialog() {
        this.visualTarget.updateLaunchConfigurationDialog();
    }

    private void widgetSelectionHandler(SelectionEvent evt) {
        if (evt.widget != null && ((Button)evt.widget).isFocusControl()) {
            this.checkOptionSelections();
            this.updateDependendOptions();
            this.updateLaunchConfigurationDialog();
        }
    }

    public boolean withIn(Range range) {
        try {
            if (this.text.getText().endsWith("k") || this.text.getText().endsWith("K")) {
                return ((IntegerRange)range).accepts(Integer.parseInt(this.text.getText(0, this.text.getCharCount() - 2)) * 1024);
            }
            if (this.text.getText().endsWith("M")) {
                return ((IntegerRange)range).accepts(Integer.parseInt(this.text.getText(0, this.text.getCharCount() - 2)) * 1024 * 1024);
            }
            return ((IntegerRange)range).accepts(Integer.parseInt(this.getValue()));
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getValue() {
        return this.text.getText();
    }

    public void setValue(String val) {
        this.text.removeVerifyListener((VerifyListener)this);
        this.text.removeModifyListener((ModifyListener)this);
        if (!val.equals("[from global]") && this.canBeGlobal()) {
            this.cache = val;
        }
        this.text.setText(val);
        this.text.addVerifyListener((VerifyListener)this);
        this.text.addModifyListener((ModifyListener)this);
    }

    public void updateView() {
        if (this.option.getDependency().fulfilled()) {
            this.setRadioButtonsEnabled(true);
            if (this.getState() == "on") {
                this.text.setEnabled(true);
            }
        } else {
            this.text.setEnabled(false);
            this.setRadioButtonsEnabled(false);
        }
    }

    public void clear() {
        this.text.setText("");
        this.setState("off");
    }

    public void initialize(String value, String state) {
        this.setValue(value);
        this.initState(state);
    }

    public String getState() {
        if (this.onRadio.getSelection()) {
            return "on";
        }
        if (this.offRadio.getSelection()) {
            return "off";
        }
        if (this.globalRadio != null && this.globalRadio.getSelection()) {
            return "global";
        }
        return "off";
    }

    public void initState(String state) {
        this.onRadio.setSelection(false);
        this.offRadio.setSelection(false);
        if (this.globalRadio != null && this.canBeGlobal()) {
            this.globalRadio.setSelection(false);
        }
        if (state.equals("on")) {
            this.onRadio.setSelection(true);
            this.setState("on");
        } else if (state.equals("off")) {
            this.offRadio.setSelection(true);
            this.setState("off");
        } else if (this.globalRadio != null && this.canBeGlobal() && state.equals("global")) {
            this.globalRadio.setSelection(true);
            this.setState("global");
        } else {
            this.offRadio.setSelection(true);
            this.setState("off");
        }
    }

    private void setState(String newState) {
        if (newState.equals("on")) {
            this.text.setEnabled(true);
            this.text.setEditable(true);
        } else if (newState.equals("off")) {
            this.text.setEnabled(false);
        } else if (this.globalRadio != null && this.canBeGlobal() && newState.equals("global")) {
            this.setValue("[from global]");
            this.text.setEnabled(true);
            this.text.setEditable(false);
        } else {
            this.setState("off");
        }
        this.updateDependendOptions();
    }

    public String validate() {
        if (this.getState().equals("on") && this.getValue().length() > 0 && this.text.isEnabled() && !this.withIn(this.option.getRange())) {
            return "Integer value out of range";
        }
        return null;
    }

    public void verifyText(VerifyEvent event) {
        block3: {
            Widget source = event.widget;
            if (source == this.text && event.text.length() > 0) {
                try {
                    Integer.parseInt(event.text);
                }
                catch (NumberFormatException numberFormatException) {
                    if (event.text.endsWith("K") || event.text.endsWith("k") || event.text.endsWith("M")) break block3;
                    event.text = "";
                }
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        if (this.canBeGlobal()) {
            this.cache = this.getValue();
        }
        this.updateDependendOptions();
        this.updateLaunchConfigurationDialog();
    }
}

