/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import com.aicas.jamaica.range.Range;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class VisualComboOption
extends VisualOption {
    private Combo combo;
    private Group comboGroup;

    public VisualComboOption(Option option, String[] itemList, Composite parent, int tabType, VisualTarget visualTarget) {
        super(option, parent, tabType, visualTarget);
        this.comboGroup = new Group(parent, 0);
        try {
            FontData fd = this.comboGroup.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.comboGroup.setFont(new Font((Device)this.comboGroup.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.comboGroup.setText(option.getName());
        this.addContextHelp((Control)this.comboGroup);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        this.comboGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.grabExcessHorizontalSpace = true;
        this.comboGroup.setLayoutData((Object)gridData);
        this.combo = new Combo((Composite)this.comboGroup, 76);
        gridData = new GridData(768);
        this.combo.setLayoutData((Object)gridData);
        this.combo.setItems(itemList);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                VisualComboOption.this.setState("on");
                VisualComboOption.this.updateLaunchConfigurationDialog();
                VisualComboOption.this.checkOptionSelections();
            }
        });
        this.combo.select(0);
    }

    private void updateLaunchConfigurationDialog() {
        this.visualTarget.updateLaunchConfigurationDialog();
    }

    public boolean withIn(Range range) {
        return true;
    }

    public void initialize(String value, String state) {
        this.setValue(value);
    }

    public String getValue() {
        return this.combo.getText();
    }

    public void setValue(String val) {
        this.combo.setText(val);
    }

    public void updateView() {
        if (this.option.getDependency().fulfilled()) {
            this.comboGroup.setEnabled(true);
        } else {
            this.comboGroup.setEnabled(true);
        }
    }

    public String getState() {
        if (!this.combo.getText().equals("")) {
            return "on";
        }
        return "off";
    }

    private void setState(String state) {
        if (state.equals("on")) {
            this.combo.setEnabled(true);
        } else if (state.equals("off")) {
            this.combo.setEnabled(true);
        } else {
            this.combo.setEnabled(true);
        }
    }

    public void clear() {
        if (this.combo.getItemCount() > 0) {
            this.combo.select(0);
        }
    }

    public String validate() {
        return null;
    }
}

