/*
 * Decompiled with CFR 0.152.
 */
package com.aicas.jamaica.eclipse.ui;

import com.aicas.jamaica.eclipse.options.Option;
import com.aicas.jamaica.eclipse.ui.VisualOption;
import com.aicas.jamaica.eclipse.ui.VisualTarget;
import com.aicas.jamaica.range.BooleanRange;
import com.aicas.jamaica.range.Range;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class VisualBooleanOption
extends VisualOption {
    private Group radioButtons;

    public VisualBooleanOption(Option option, Composite parent, int tabType, VisualTarget visualTarget) {
        super(option, parent, tabType, visualTarget);
        this.radioButtons = new Group(parent, 0);
        try {
            FontData fd = this.radioButtons.getFont().getFontData()[0];
            fd.setStyle(fd.getStyle() | 1);
            this.radioButtons.setFont(new Font((Device)this.radioButtons.getDisplay(), fd));
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
        }
        this.radioButtons.setText(option.getName());
        this.addContextHelp((Control)this.radioButtons);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        this.radioButtons.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        this.radioButtons.setLayoutData((Object)gridData);
        this.onRadio = new Button((Composite)this.radioButtons, 16400);
        this.onRadio.setText("on");
        this.onRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                VisualBooleanOption.this.widgetSelectionHandler(evt);
            }
        });
        this.offRadio = new Button((Composite)this.radioButtons, 16400);
        this.offRadio.setText("off");
        this.offRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                VisualBooleanOption.this.widgetSelectionHandler(evt);
            }
        });
        if (this.getTabType() != VisualTarget.GLOBAL) {
            this.globalRadio = new Button((Composite)this.radioButtons, 16400);
            this.globalRadio.setText("global");
            this.globalRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    VisualBooleanOption.this.widgetSelectionHandler(evt);
                }
            });
            if (option.getTargetOrGlobal().equals("TARGET_OR_GLOBAL")) {
                this.globalRadio.setVisible(true);
            } else {
                this.globalRadio.setVisible(false);
            }
        }
    }

    private void widgetSelectionHandler(SelectionEvent evt) {
        if (evt.widget != null && ((Button)evt.widget).isFocusControl()) {
            this.checkOptionSelections();
            this.updateDependendOptions();
            this.updateLaunchConfigurationDialog();
        }
    }

    private void updateLaunchConfigurationDialog() {
        this.visualTarget.updateLaunchConfigurationDialog();
    }

    public boolean withIn(Range range) {
        return ((BooleanRange)range).accepts(this.onRadio.getSelection());
    }

    public String getValue() {
        if (this.onRadio.getSelection()) {
            return "true";
        }
        if (this.offRadio.getSelection()) {
            return "false";
        }
        if (this.globalRadio != null && this.globalRadio.getSelection()) {
            return "global";
        }
        return "false";
    }

    public void initialize(String value, String state) {
        this.setValue(value);
        this.initState(state);
    }

    public void setValue(String val) {
        if (val.equals("on")) {
            this.onRadio.setSelection(true);
        } else if (val.equals("off")) {
            this.offRadio.setSelection(true);
        } else if (val.equals("global") && this.globalRadio != null) {
            this.globalRadio.setSelection(true);
        } else {
            this.offRadio.setSelection(true);
        }
    }

    public void updateView() {
        if (this.option.getDependency().fulfilled()) {
            this.setRadioButtonsEnabled(true);
        } else {
            this.setRadioButtonsEnabled(false);
        }
    }

    public String getState() {
        if (this.onRadio.getSelection()) {
            return "on";
        }
        if (this.offRadio.getSelection()) {
            return "off";
        }
        if (this.globalRadio != null && this.globalRadio.getSelection()) {
            return "global";
        }
        return "off";
    }

    public void initState(String state) {
        this.onRadio.setSelection(false);
        this.offRadio.setSelection(false);
        if (this.globalRadio != null && this.canBeGlobal()) {
            this.globalRadio.setSelection(false);
        }
        if (state.equals("on")) {
            this.onRadio.setSelection(true);
        } else if (state.equals("off")) {
            this.offRadio.setSelection(true);
        } else if (state.equals("global") && this.globalRadio != null && this.canBeGlobal()) {
            this.globalRadio.setSelection(true);
        } else {
            this.offRadio.setSelection(true);
        }
        this.updateDependendOptions();
    }

    public void clear() {
        this.offRadio.setSelection(true);
    }

    public String validate() {
        return null;
    }
}

